/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.fx.tree;

import ext.base.core.BcStringUtil;
import ext.base.log.BcLoggableObject;
import ext.lib.fx.tree.FxTreeCell;
import ext.lib.fx.tree.FxTreeFolder;
import ext.lib.fx.tree.FxTreeItem;
import ext.lib.fx.tree.FxTreeItemHelper;
import ext.lib.fx.tree.FxTreeView;
import ext.lib.swg.SwgUtil;
import java.util.ArrayList;
import java.util.List;
import javafx.scene.control.TreeItem;
import javafx.scene.input.MouseEvent;

public abstract class FxTreeItemHelperImpl
extends BcLoggableObject
implements FxTreeItemHelper {
    private FxTreeView treeView;
    private FxTreeItem subTreeItem;
    private FxTreeItemHelperImpl parentTreeItemHelper;
    protected List<FxTreeItemHelperImpl> childTreeItemHelperList = new ArrayList<FxTreeItemHelperImpl>();

    public FxTreeView getTreeView() {
        return this.treeView;
    }

    public FxTreeItem getSubTreeItem() {
        return this.subTreeItem;
    }

    public FxTreeItemHelperImpl getParentTreeItemHelper() {
        return this.parentTreeItemHelper;
    }

    public FxTreeItem creaeTreeItem() throws Exception {
        FxTreeItem treeItem = new FxTreeItem();
        treeItem.setTreeIF(this);
        return treeItem;
    }

    public void setup(FxTreeView treeView) throws Exception {
        this.treeView = treeView;
        this.subTreeItem = this.creaeSubTreeItem();
        if (this.parentTreeItemHelper == null) {
            treeView.setRoot(this.subTreeItem);
        } else {
            this.parentTreeItemHelper.getSubTreeItem().getChildren().add((Object)this.subTreeItem);
        }
        for (FxTreeItemHelperImpl treeItemHelper : this.childTreeItemHelperList) {
            treeItemHelper.parentTreeItemHelper = this;
            treeItemHelper.setup(treeView);
        }
    }

    @Override
    public String getItemText(FxTreeItem treeItem) throws Exception {
        String str = null;
        if (FxTreeFolder.class.isInstance(treeItem.getValue())) {
            FxTreeFolder treeFolder = (FxTreeFolder)treeItem.getValue();
            str = treeFolder.name;
        } else {
            str = BcStringUtil.toString(treeItem.getValue());
        }
        return str;
    }

    @Override
    public void refresh() throws Exception {
        for (FxTreeItemHelper fxTreeItemHelper : this.childTreeItemHelperList) {
            fxTreeItemHelper.refresh();
        }
    }

    @Override
    public void treeItemClicked(MouseEvent ev, FxTreeItem treeItem, FxTreeCell treeCell, boolean doubleClicked) throws Exception {
        for (FxTreeItemHelper fxTreeItemHelper : this.childTreeItemHelperList) {
            fxTreeItemHelper.treeItemClicked(ev, treeItem, treeCell, doubleClicked);
        }
    }

    @Override
    public void treeItemExpanded(TreeItem.TreeModificationEvent ev) throws Exception {
        for (FxTreeItemHelper fxTreeItemHelper : this.childTreeItemHelperList) {
            fxTreeItemHelper.treeItemExpanded(ev);
        }
    }

    @Override
    public void treeItemCollapsed(TreeItem.TreeModificationEvent ev) throws Exception {
        for (FxTreeItemHelper fxTreeItemHelper : this.childTreeItemHelperList) {
            fxTreeItemHelper.treeItemCollapsed(ev);
        }
    }

    @Override
    public void destruct() throws Exception {
        for (FxTreeItemHelper fxTreeItemHelper : this.childTreeItemHelperList) {
            fxTreeItemHelper.destruct();
        }
    }

    public void handleException(Throwable throwable) {
        SwgUtil.getExceptionHandler().handleException(throwable, this);
    }
}

