/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xsod.dao;

import ext.base.core.BcStringUtil;
import ext.base.log.BcLogUtil;
import ext.base.util.BcCollectionUtil;
import ext.lib.datasource.DtsSession;
import ext.lib.orm.dao.OrmAbstractDAO;
import ext.lib.sql.SqlUtil;
import ext.lib.sql.context.SqlContext;
import ext.lib.sql.model.SqlSelectQuery;
import ext.lib.sql.model.SqlWhereElement;
import ext.module.xsod.model.XsodMerchandise;
import java.util.List;

public class XsodMerchandiseDAO
extends OrmAbstractDAO<XsodMerchandise> {
    public static final int MODE_default = 1;

    private XsodMerchandiseDAO() {
        super(new XsodMerchandise[0]);
        this.setTableName("xsod_merchandise");
    }

    public static XsodMerchandiseDAO getInstance() {
        return SingletonHolder.instance;
    }

    public SqlSelectQuery createSelectSql(SqlContext sqlContext, int mode, String alias, String merchandiseCode) throws Exception {
        String aliasWk = SqlUtil.tableAliasToNotNull(alias);
        SqlSelectQuery selectQuery = new SqlSelectQuery();
        if (!BcStringUtil.isEmpty(merchandiseCode)) {
            SqlWhereElement whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(String.valueOf(aliasWk) + "code" + sqlContext.toCondition_string("=", merchandiseCode));
            selectQuery.addWhereElement(whereElement);
        }
        selectQuery.setFromClause(String.valueOf(this.getTableName()) + " AS " + alias);
        if (mode == 1) {
            selectQuery.getOrderByList().add(String.valueOf(aliasWk) + "code");
        }
        return selectQuery;
    }

    public List<XsodMerchandise> getList(DtsSession dtsSession, String merchandiseCode) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        String alias = "mchd";
        SqlSelectQuery selectQuery = this.createSelectSql(sqlContext, 1, alias, merchandiseCode);
        selectQuery.getSelectColumnList().addAll(this.getColumnNameList(alias));
        String query = sqlContext.buildSelectQuery(selectQuery);
        BcLogUtil.debug("query=" + query);
        return this.getEntityList(dtsSession, query);
    }

    public XsodMerchandise getByCode(DtsSession dtsSession, String merchandiseCode) throws Exception {
        if (BcStringUtil.isEmpty(merchandiseCode)) {
            return null;
        }
        List<XsodMerchandise> entityList = this.getList(dtsSession, merchandiseCode);
        return BcCollectionUtil.getFirst(entityList);
    }

    public int deleteByCode(DtsSession dtsSession, String merchandiseCode) throws Exception {
        if (BcStringUtil.isEmpty(merchandiseCode)) {
            return 0;
        }
        XsodMerchandise merchandise = new XsodMerchandise();
        merchandise.code = merchandiseCode;
        int deleteCount = this.getPersistenceProxy().deleteEntity(dtsSession, this.getTableName(), merchandise);
        return deleteCount;
    }

    /* synthetic */ XsodMerchandiseDAO(XsodMerchandiseDAO xsodMerchandiseDAO) {
        this();
    }

    private static final class SingletonHolder {
        private static final XsodMerchandiseDAO instance = new XsodMerchandiseDAO(null);

        private SingletonHolder() {
        }
    }
}

