/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.comm;

import ext.base.log.BcLogUtil;
import ext.base.log.BcLoggableObject;
import ext.lib.comm.CommSerialParameters;
import gnu.io.CommPortIdentifier;
import gnu.io.CommPortOwnershipListener;
import gnu.io.NoSuchPortException;
import gnu.io.PortInUseException;
import gnu.io.SerialPort;
import gnu.io.UnsupportedCommOperationException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class CommSerialConnection
extends BcLoggableObject
implements CommPortOwnershipListener {
    protected CommSerialParameters serialParameters;
    protected CommPortIdentifier portId;
    protected SerialPort serialPort;
    protected boolean isOpen;
    public OutputStream portOs;
    public InputStream portIs;

    public synchronized void open(CommSerialParameters serialParameters, int timeout, String appName) throws Exception {
        this.serialParameters = serialParameters;
        try {
            this.portId = CommPortIdentifier.getPortIdentifier((String)serialParameters.getPortName());
        }
        catch (NoSuchPortException ex) {
            throw new IOException("\u30b7\u30ea\u30a2\u30eb\u30dd\u30fc\u30c8 '" + serialParameters.getPortName() + "' \u3092\u8a8d\u8b58\u3067\u304d\u307e\u305b\u3093\u3002", ex);
        }
        try {
            this.serialPort = (SerialPort)this.portId.open(appName, timeout);
        }
        catch (PortInUseException ex) {
            throw new IOException("\u30b7\u30ea\u30a2\u30eb\u30dd\u30fc\u30c8 '" + serialParameters.getPortName() + "' \u3092\u30aa\u30fc\u30d7\u30f3\u3067\u304d\u307e\u305b\u3093\u3002");
        }
        try {
            this.setConnectionParameters();
        }
        catch (Exception ex) {
            this.serialPort.close();
            throw ex;
        }
        try {
            this.portOs = this.serialPort.getOutputStream();
            this.portIs = this.serialPort.getInputStream();
        }
        catch (IOException ex) {
            this.serialPort.close();
            throw ex;
        }
        this.serialPort.notifyOnDataAvailable(true);
        this.serialPort.notifyOnBreakInterrupt(true);
        try {
            this.serialPort.enableReceiveTimeout(30);
        }
        catch (UnsupportedCommOperationException ex) {
            this.serialPort.close();
            throw ex;
        }
        this.portId.addPortOwnershipListener((CommPortOwnershipListener)this);
        this.isOpen = true;
    }

    public void setConnectionParameters() throws Exception {
        int oldBaudRate = this.serialPort.getBaudRate();
        int oldDatabits = this.serialPort.getDataBits();
        int oldStopbits = this.serialPort.getStopBits();
        int oldParity = this.serialPort.getParity();
        try {
            this.serialPort.setSerialPortParams(this.serialParameters.getBaudRate(), this.serialParameters.getDataBits(), this.serialParameters.getStopBits(), this.serialParameters.getParity());
        }
        catch (UnsupportedCommOperationException ex) {
            this.serialParameters.setBaudRate(oldBaudRate);
            this.serialParameters.setDataBits(oldDatabits);
            this.serialParameters.setStopBits(oldStopbits);
            this.serialParameters.setParity(oldParity);
            throw new Exception("Unsupported parameter");
        }
        try {
            this.serialPort.setFlowControlMode(this.serialParameters.getFlowControlIn() | this.serialParameters.getFlowControlOut());
        }
        catch (UnsupportedCommOperationException ex) {
            throw new Exception("Unsupported flow control");
        }
    }

    public synchronized void close() throws Exception {
        if (!this.isOpen) {
            throw new Exception("port is not opend");
        }
        try {
            this.portOs.close();
        }
        catch (Exception ex) {
            BcLogUtil.debug(ex);
        }
        try {
            this.portIs.close();
        }
        catch (Exception ex) {
            BcLogUtil.debug(ex);
        }
        try {
            this.serialPort.close();
        }
        catch (Exception ex) {
            BcLogUtil.debug(ex);
        }
        try {
            this.portId.removePortOwnershipListener((CommPortOwnershipListener)this);
        }
        catch (Exception ex) {
            BcLogUtil.debug(ex);
        }
        this.isOpen = false;
    }

    public void ownershipChange(int type) {
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public SerialPort getSerialPort() {
        return this.serialPort;
    }
}

