/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.AbstractListModel;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.filechooser.FileSystemView;
import javax.swing.plaf.basic.BasicFileChooserUI;
import sun.awt.shell.ShellFolder;

public class BasicDirectoryModel
extends AbstractListModel<Object>
implements PropertyChangeListener {
    private final JFileChooser filechooser;
    private final Vector<File> fileCache = new Vector(50);
    private LoadFilesThread loadThread = null;
    private Vector<File> files = null;
    private Vector<File> directories = null;
    private final AtomicInteger fetchID = new AtomicInteger();
    private PropertyChangeSupport changeSupport;
    private boolean busy = false;

    public BasicDirectoryModel(JFileChooser jFileChooser) {
        this.filechooser = jFileChooser;
        this.validateFileCache();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string == "directoryChanged" || string == "fileViewChanged" || string == "fileFilterChanged" || string == "FileHidingChanged" || string == "fileSelectionChanged") {
            this.validateFileCache();
        } else if ("UI".equals(string)) {
            BasicFileChooserUI basicFileChooserUI;
            BasicDirectoryModel basicDirectoryModel;
            Object object = propertyChangeEvent.getOldValue();
            if (object instanceof BasicFileChooserUI && (basicDirectoryModel = (basicFileChooserUI = (BasicFileChooserUI)object).getModel()) != null) {
                basicDirectoryModel.invalidateFileCache();
            }
        } else if ("JFileChooserDialogIsClosingProperty".equals(string)) {
            this.invalidateFileCache();
        }
    }

    public void invalidateFileCache() {
        if (this.loadThread != null) {
            this.loadThread.interrupt();
            this.loadThread.cancelRunnables();
            this.loadThread = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<File> getDirectories() {
        Vector<File> vector = this.fileCache;
        synchronized (vector) {
            if (this.directories != null) {
                return this.directories;
            }
            Vector<File> vector2 = this.getFiles();
            return this.directories;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<File> getFiles() {
        Vector<File> vector = this.fileCache;
        synchronized (vector) {
            if (this.files != null) {
                return this.files;
            }
            this.files = new Vector();
            this.directories = new Vector();
            this.directories.addElement(this.filechooser.getFileSystemView().createFileObject(this.filechooser.getCurrentDirectory(), ".."));
            for (int i = 0; i < this.getSize(); ++i) {
                File file = this.fileCache.get(i);
                if (this.filechooser.isTraversable(file)) {
                    this.directories.add(file);
                    continue;
                }
                this.files.add(file);
            }
            return this.files;
        }
    }

    public void validateFileCache() {
        File file = this.filechooser.getCurrentDirectory();
        if (file == null) {
            return;
        }
        if (this.loadThread != null) {
            this.loadThread.interrupt();
            this.loadThread.cancelRunnables();
        }
        int n = this.fetchID.incrementAndGet();
        this.setBusy(true, n);
        this.loadThread = new LoadFilesThread(file, n);
        this.loadThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean renameFile(File file, File file2) {
        Vector<File> vector = this.fileCache;
        synchronized (vector) {
            if (file.renameTo(file2)) {
                this.validateFileCache();
                return true;
            }
            return false;
        }
    }

    public void fireContentsChanged() {
        this.fireContentsChanged(this, 0, this.getSize() - 1);
    }

    @Override
    public int getSize() {
        return this.fileCache.size();
    }

    public boolean contains(Object object) {
        return this.fileCache.contains(object);
    }

    public int indexOf(Object object) {
        return this.fileCache.indexOf(object);
    }

    @Override
    public Object getElementAt(int n) {
        return this.fileCache.get(n);
    }

    public void intervalAdded(ListDataEvent listDataEvent) {
    }

    public void intervalRemoved(ListDataEvent listDataEvent) {
    }

    protected void sort(Vector<? extends File> vector) {
        ShellFolder.sort(vector);
    }

    protected boolean lt(File file, File file2) {
        int n = file.getName().toLowerCase().compareTo(file2.getName().toLowerCase());
        if (n != 0) {
            return n < 0;
        }
        return file.getName().compareTo(file2.getName()) < 0;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.changeSupport == null) {
            this.changeSupport = new PropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.changeSupport != null) {
            this.changeSupport.removePropertyChangeListener(propertyChangeListener);
        }
    }

    public PropertyChangeListener[] getPropertyChangeListeners() {
        if (this.changeSupport == null) {
            return new PropertyChangeListener[0];
        }
        return this.changeSupport.getPropertyChangeListeners();
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange(string, object, object2);
        }
    }

    private synchronized void setBusy(final boolean bl, int n) {
        if (n == this.fetchID.get()) {
            boolean bl2 = this.busy;
            this.busy = bl;
            if (this.changeSupport != null && bl != bl2) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        BasicDirectoryModel.this.firePropertyChange("busy", !bl, bl);
                    }
                });
            }
        }
    }

    private final class DoChangeContents
    implements Runnable {
        private final List<File> addFiles;
        private final List<File> remFiles;
        private boolean doFire = true;
        private final int fid;
        private int addStart = 0;
        private int remStart = 0;

        DoChangeContents(List<File> list, int n, List<File> list2, int n2, int n3) {
            this.addFiles = list;
            this.addStart = n;
            this.remFiles = list2;
            this.remStart = n2;
            this.fid = n3;
        }

        synchronized void cancel() {
            this.doFire = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void run() {
            if (BasicDirectoryModel.this.fetchID.get() == this.fid && this.doFire) {
                int n = this.remFiles == null ? 0 : this.remFiles.size();
                int n2 = this.addFiles == null ? 0 : this.addFiles.size();
                Vector vector = BasicDirectoryModel.this.fileCache;
                synchronized (vector) {
                    if (n > 0) {
                        BasicDirectoryModel.this.fileCache.removeAll(this.remFiles);
                    }
                    if (n2 > 0) {
                        BasicDirectoryModel.this.fileCache.addAll(this.addStart, this.addFiles);
                    }
                    BasicDirectoryModel.this.files = null;
                    BasicDirectoryModel.this.directories = null;
                }
                if (n > 0 && n2 == 0) {
                    BasicDirectoryModel.this.fireIntervalRemoved(BasicDirectoryModel.this, this.remStart, this.remStart + n - 1);
                } else if (n2 > 0 && n == 0 && this.addStart + n2 <= BasicDirectoryModel.this.fileCache.size()) {
                    BasicDirectoryModel.this.fireIntervalAdded(BasicDirectoryModel.this, this.addStart, this.addStart + n2 - 1);
                } else {
                    BasicDirectoryModel.this.fireContentsChanged();
                }
            }
        }
    }

    private final class LoadFilesThread
    extends Thread {
        private final FileSystemView fileSystemView;
        private final boolean useFileHiding;
        private final boolean fileSelectionEnabled;
        private final int fid;
        private final File currentDirectory;
        private volatile DoChangeContents runnable;

        private LoadFilesThread(File file, int n) {
            super("Basic L&F File Loading Thread");
            this.currentDirectory = file;
            this.fid = n;
            this.fileSystemView = BasicDirectoryModel.this.filechooser.getFileSystemView();
            this.useFileHiding = BasicDirectoryModel.this.filechooser.isFileHidingEnabled();
            this.fileSelectionEnabled = BasicDirectoryModel.this.filechooser.isFileSelectionEnabled();
        }

        @Override
        public void run() {
            this.run0();
            BasicDirectoryModel.this.setBusy(false, this.fid);
        }

        private void run0() {
            FileSystemView fileSystemView = this.fileSystemView;
            if (this.isInterrupted()) {
                return;
            }
            File[] fileArray = fileSystemView.getFiles(this.currentDirectory, this.useFileHiding);
            if (this.isInterrupted()) {
                return;
            }
            final Vector<File> vector = new Vector<File>();
            Vector<File> vector2 = new Vector<File>();
            for (File file : fileArray) {
                if (!BasicDirectoryModel.this.filechooser.accept(file)) continue;
                boolean bl = BasicDirectoryModel.this.filechooser.isTraversable(file);
                if (bl) {
                    vector.addElement(file);
                } else if (this.fileSelectionEnabled) {
                    vector2.addElement(file);
                }
                if (!this.isInterrupted()) continue;
                return;
            }
            BasicDirectoryModel.this.sort(vector);
            BasicDirectoryModel.this.sort(vector2);
            vector.addAll(vector2);
            this.runnable = ShellFolder.invoke(new Callable<DoChangeContents>(){

                @Override
                public DoChangeContents call() {
                    int n;
                    int n2 = vector.size();
                    if (n2 > (n = BasicDirectoryModel.this.fileCache.size())) {
                        int n3 = n;
                        int n4 = n2;
                        block0: for (int i = 0; i < n; ++i) {
                            if (((File)vector.get(i)).equals(BasicDirectoryModel.this.fileCache.get(i))) continue;
                            n3 = i;
                            for (int j = i; j < n2; ++j) {
                                if (!((File)vector.get(j)).equals(BasicDirectoryModel.this.fileCache.get(i))) continue;
                                n4 = j;
                                break block0;
                            }
                            break;
                        }
                        if (n3 >= 0 && n4 > n3 && vector.subList(n4, n2).equals(BasicDirectoryModel.this.fileCache.subList(n3, n))) {
                            if (LoadFilesThread.this.isInterrupted()) {
                                return null;
                            }
                            return new DoChangeContents(vector.subList(n3, n4), n3, null, 0, LoadFilesThread.this.fid);
                        }
                    } else if (n2 < n) {
                        int n5 = -1;
                        int n6 = -1;
                        for (int i = 0; i < n2; ++i) {
                            if (((File)vector.get(i)).equals(BasicDirectoryModel.this.fileCache.get(i))) continue;
                            n5 = i;
                            n6 = i + n - n2;
                            break;
                        }
                        if (n5 >= 0 && n6 > n5 && BasicDirectoryModel.this.fileCache.subList(n6, n).equals(vector.subList(n5, n2))) {
                            if (LoadFilesThread.this.isInterrupted()) {
                                return null;
                            }
                            return new DoChangeContents(null, 0, new Vector<File>(BasicDirectoryModel.this.fileCache.subList(n5, n6)), n5, LoadFilesThread.this.fid);
                        }
                    }
                    if (!BasicDirectoryModel.this.fileCache.equals(vector)) {
                        if (LoadFilesThread.this.isInterrupted()) {
                            LoadFilesThread.this.cancelRunnables();
                        }
                        return new DoChangeContents(vector, 0, BasicDirectoryModel.this.fileCache, 0, LoadFilesThread.this.fid);
                    }
                    return null;
                }
            });
            if (this.runnable != null && !this.isInterrupted()) {
                SwingUtilities.invokeLater(this.runnable);
            }
        }

        private void cancelRunnables() {
            if (this.runnable != null) {
                this.runnable.cancel();
            }
        }
    }
}

