/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.transforms;

import com.sun.org.apache.xml.internal.security.c14n.CanonicalizationException;
import com.sun.org.apache.xml.internal.security.c14n.InvalidCanonicalizerException;
import com.sun.org.apache.xml.internal.security.exceptions.AlgorithmAlreadyRegisteredException;
import com.sun.org.apache.xml.internal.security.exceptions.XMLSecurityException;
import com.sun.org.apache.xml.internal.security.signature.XMLSignatureInput;
import com.sun.org.apache.xml.internal.security.transforms.ClassLoaderUtils;
import com.sun.org.apache.xml.internal.security.transforms.InvalidTransformException;
import com.sun.org.apache.xml.internal.security.transforms.TransformSpi;
import com.sun.org.apache.xml.internal.security.transforms.TransformationException;
import com.sun.org.apache.xml.internal.security.transforms.implementations.TransformBase64Decode;
import com.sun.org.apache.xml.internal.security.transforms.implementations.TransformC14N;
import com.sun.org.apache.xml.internal.security.transforms.implementations.TransformC14N11;
import com.sun.org.apache.xml.internal.security.transforms.implementations.TransformC14N11_WithComments;
import com.sun.org.apache.xml.internal.security.transforms.implementations.TransformC14NExclusive;
import com.sun.org.apache.xml.internal.security.transforms.implementations.TransformC14NExclusiveWithComments;
import com.sun.org.apache.xml.internal.security.transforms.implementations.TransformC14NWithComments;
import com.sun.org.apache.xml.internal.security.transforms.implementations.TransformEnvelopedSignature;
import com.sun.org.apache.xml.internal.security.transforms.implementations.TransformXPath;
import com.sun.org.apache.xml.internal.security.transforms.implementations.TransformXPath2Filter;
import com.sun.org.apache.xml.internal.security.transforms.implementations.TransformXSLT;
import com.sun.org.apache.xml.internal.security.utils.HelperNodeList;
import com.sun.org.apache.xml.internal.security.utils.JavaUtils;
import com.sun.org.apache.xml.internal.security.utils.SignatureElementProxy;
import com.sun.org.apache.xml.internal.security.utils.XMLUtils;
import com.sun.org.slf4j.internal.Logger;
import com.sun.org.slf4j.internal.LoggerFactory;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class Transform
extends SignatureElementProxy {
    private static final Logger LOG = LoggerFactory.getLogger(Transform.class);
    private static Map<String, TransformSpi> transformSpiHash = new ConcurrentHashMap<String, TransformSpi>();
    private final TransformSpi transformSpi;

    public Transform(Document document, String string) throws InvalidTransformException {
        this(document, string, (NodeList)null);
    }

    public Transform(Document document, String string, Element element) throws InvalidTransformException {
        super(document);
        this.setLocalAttribute("Algorithm", string);
        this.transformSpi = this.initializeTransform(string);
        if (element != null) {
            HelperNodeList helperNodeList = new HelperNodeList();
            XMLUtils.addReturnToElement(document, helperNodeList);
            helperNodeList.appendChild(element);
            XMLUtils.addReturnToElement(document, helperNodeList);
            int n = helperNodeList.getLength();
            for (int i = 0; i < n; ++i) {
                this.appendSelf(helperNodeList.item(i).cloneNode(true));
            }
            LOG.debug("The NodeList is {}", helperNodeList);
        }
    }

    public Transform(Document document, String string, NodeList nodeList) throws InvalidTransformException {
        super(document);
        this.setLocalAttribute("Algorithm", string);
        this.transformSpi = this.initializeTransform(string);
        if (nodeList != null) {
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                this.appendSelf(nodeList.item(i).cloneNode(true));
            }
            LOG.debug("The NodeList is {}", nodeList);
        }
    }

    public Transform(Element element, String string) throws InvalidTransformException, TransformationException, XMLSecurityException {
        super(element, string);
        String string2 = element.getAttributeNS(null, "Algorithm");
        if (string2 == null || string2.length() == 0) {
            Object[] objectArray = new Object[]{"Algorithm", "Transform"};
            throw new TransformationException("xml.WrongContent", objectArray);
        }
        this.transformSpi = this.initializeTransform(string2);
    }

    public static void register(String string, String string2) throws AlgorithmAlreadyRegisteredException, ClassNotFoundException, InvalidTransformException {
        JavaUtils.checkRegisterPermission();
        TransformSpi transformSpi = transformSpiHash.get(string);
        if (transformSpi != null) {
            Object[] objectArray = new Object[]{string, transformSpi};
            throw new AlgorithmAlreadyRegisteredException("algorithm.alreadyRegistered", objectArray);
        }
        Class<?> clazz = ClassLoaderUtils.loadClass(string2, Transform.class);
        try {
            transformSpiHash.put(string, (TransformSpi)JavaUtils.newInstanceWithEmptyConstructor(clazz));
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException reflectiveOperationException) {
            Object[] objectArray = new Object[]{string};
            throw new InvalidTransformException(reflectiveOperationException, "signature.Transform.UnknownTransform", objectArray);
        }
    }

    public static void register(String string, Class<? extends TransformSpi> clazz) throws AlgorithmAlreadyRegisteredException, InvalidTransformException {
        JavaUtils.checkRegisterPermission();
        TransformSpi transformSpi = transformSpiHash.get(string);
        if (transformSpi != null) {
            Object[] objectArray = new Object[]{string, transformSpi};
            throw new AlgorithmAlreadyRegisteredException("algorithm.alreadyRegistered", objectArray);
        }
        try {
            transformSpiHash.put(string, JavaUtils.newInstanceWithEmptyConstructor(clazz));
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException reflectiveOperationException) {
            Object[] objectArray = new Object[]{string};
            throw new InvalidTransformException(reflectiveOperationException, "signature.Transform.UnknownTransform", objectArray);
        }
    }

    public static void registerDefaultAlgorithms() {
        transformSpiHash.put("http://www.w3.org/2000/09/xmldsig#base64", new TransformBase64Decode());
        transformSpiHash.put("http://www.w3.org/TR/2001/REC-xml-c14n-20010315", new TransformC14N());
        transformSpiHash.put("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments", new TransformC14NWithComments());
        transformSpiHash.put("http://www.w3.org/2006/12/xml-c14n11", new TransformC14N11());
        transformSpiHash.put("http://www.w3.org/2006/12/xml-c14n11#WithComments", new TransformC14N11_WithComments());
        transformSpiHash.put("http://www.w3.org/2001/10/xml-exc-c14n#", new TransformC14NExclusive());
        transformSpiHash.put("http://www.w3.org/2001/10/xml-exc-c14n#WithComments", new TransformC14NExclusiveWithComments());
        transformSpiHash.put("http://www.w3.org/TR/1999/REC-xpath-19991116", new TransformXPath());
        transformSpiHash.put("http://www.w3.org/2000/09/xmldsig#enveloped-signature", new TransformEnvelopedSignature());
        transformSpiHash.put("http://www.w3.org/TR/1999/REC-xslt-19991116", new TransformXSLT());
        transformSpiHash.put("http://www.w3.org/2002/06/xmldsig-filter2", new TransformXPath2Filter());
    }

    public String getURI() {
        return this.getLocalAttribute("Algorithm");
    }

    public XMLSignatureInput performTransform(XMLSignatureInput xMLSignatureInput, boolean bl) throws IOException, CanonicalizationException, InvalidCanonicalizerException, TransformationException {
        return this.performTransform(xMLSignatureInput, null, bl);
    }

    public XMLSignatureInput performTransform(XMLSignatureInput xMLSignatureInput, OutputStream outputStream, boolean bl) throws IOException, CanonicalizationException, InvalidCanonicalizerException, TransformationException {
        XMLSignatureInput xMLSignatureInput2 = null;
        try {
            xMLSignatureInput2 = this.transformSpi.enginePerformTransform(xMLSignatureInput, outputStream, this.getElement(), this.baseURI, bl);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            Object[] objectArray = new Object[]{this.getURI(), "ParserConfigurationException"};
            throw new CanonicalizationException(parserConfigurationException, "signature.Transform.ErrorDuringTransform", objectArray);
        }
        catch (SAXException sAXException) {
            Object[] objectArray = new Object[]{this.getURI(), "SAXException"};
            throw new CanonicalizationException(sAXException, "signature.Transform.ErrorDuringTransform", objectArray);
        }
        return xMLSignatureInput2;
    }

    @Override
    public String getBaseLocalName() {
        return "Transform";
    }

    private TransformSpi initializeTransform(String string) throws InvalidTransformException {
        TransformSpi transformSpi = transformSpiHash.get(string);
        if (transformSpi == null) {
            Object[] objectArray = new Object[]{string};
            throw new InvalidTransformException("signature.Transform.UnknownTransform", objectArray);
        }
        LOG.debug("Create URI \"{}\" class \"{}\"", string, transformSpi.getClass());
        return transformSpi;
    }
}

