/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.statement.upsert;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.expression.operators.relational.ItemsList;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.StatementVisitor;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.upsert.UpsertType;

public class Upsert
implements Statement {
    private Table table;
    private List<Column> columns;
    private ItemsList itemsList;
    private boolean useValues = true;
    private Select select;
    private boolean useSelectBrackets = true;
    private boolean useDuplicate = false;
    private List<Column> duplicateUpdateColumns;
    private List<Expression> duplicateUpdateExpressionList;
    private UpsertType upsertType = UpsertType.UPSERT;
    private boolean isUsingInto;

    @Override
    public void accept(StatementVisitor statementVisitor) {
        statementVisitor.visit(this);
    }

    public UpsertType getUpsertType() {
        return this.upsertType;
    }

    public void setUpsertType(UpsertType upsertType) {
        this.upsertType = upsertType;
    }

    public Upsert withUpsertType(UpsertType upsertType) {
        this.setUpsertType(upsertType);
        return this;
    }

    public boolean isUsingInto() {
        return this.isUsingInto;
    }

    public void setUsingInto(boolean useInto) {
        this.isUsingInto = useInto;
    }

    public Upsert withUsingInto(boolean useInto) {
        this.setUsingInto(useInto);
        return this;
    }

    public void setTable(Table name) {
        this.table = name;
    }

    public Table getTable() {
        return this.table;
    }

    public void setColumns(List<Column> list) {
        this.columns = list;
    }

    public List<Column> getColumns() {
        return this.columns;
    }

    public void setItemsList(ItemsList list) {
        this.itemsList = list;
    }

    public ItemsList getItemsList() {
        return this.itemsList;
    }

    public List<Expression> getSetExpressions() {
        List<Expression> expressions = null;
        if (this.itemsList instanceof ExpressionList) {
            ExpressionList expressionList = (ExpressionList)this.itemsList;
            expressions = expressionList.getExpressions();
        }
        return expressions;
    }

    public void setUseValues(boolean useValues) {
        this.useValues = useValues;
    }

    public boolean isUseValues() {
        return this.useValues;
    }

    public void setSelect(Select select) {
        this.select = select;
    }

    public Select getSelect() {
        return this.select;
    }

    public void setUseSelectBrackets(boolean useSelectBrackets) {
        this.useSelectBrackets = useSelectBrackets;
    }

    public boolean isUseSelectBrackets() {
        return this.useSelectBrackets;
    }

    public void setUseDuplicate(boolean useDuplicate) {
        this.useDuplicate = useDuplicate;
    }

    public boolean isUseDuplicate() {
        return this.useDuplicate;
    }

    public void setDuplicateUpdateColumns(List<Column> duplicateUpdateColumns) {
        this.duplicateUpdateColumns = duplicateUpdateColumns;
    }

    public List<Column> getDuplicateUpdateColumns() {
        return this.duplicateUpdateColumns;
    }

    public void setDuplicateUpdateExpressionList(List<Expression> duplicateUpdateExpressionList) {
        this.duplicateUpdateExpressionList = duplicateUpdateExpressionList;
    }

    public List<Expression> getDuplicateUpdateExpressionList() {
        return this.duplicateUpdateExpressionList;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        switch (this.upsertType) {
            case REPLACE: 
            case REPLACE_SET: {
                sb.append("REPLACE ");
                break;
            }
            case INSERT_OR_ABORT: {
                sb.append("INSERT OR ABORT ");
                break;
            }
            case INSERT_OR_FAIL: {
                sb.append("INSERT OR FAIL ");
                break;
            }
            case INSERT_OR_IGNORE: {
                sb.append("INSERT OR IGNORE ");
                break;
            }
            case INSERT_OR_REPLACE: {
                sb.append("INSERT OR REPLACE ");
                break;
            }
            case INSERT_OR_ROLLBACK: {
                sb.append("INSERT OR ROLLBACK ");
                break;
            }
            default: {
                sb.append("UPSERT ");
            }
        }
        if (this.isUsingInto) {
            sb.append("INTO ");
        }
        sb.append(this.table).append(" ");
        if (this.upsertType == UpsertType.REPLACE_SET) {
            sb.append("SET ");
            List<Expression> expressions = this.getSetExpressions();
            int s = this.columns.size();
            for (int i = 0; i < s; ++i) {
                sb.append(this.columns.get(i)).append("=").append(expressions.get(i));
                sb.append(i < s - 1 ? ", " : "");
            }
        } else {
            if (this.columns != null) {
                sb.append(PlainSelect.getStringList(this.columns, true, true)).append(" ");
            }
            if (this.useValues) {
                sb.append("VALUES ");
            }
            if (this.itemsList != null) {
                sb.append(this.itemsList);
            } else {
                if (this.useSelectBrackets) {
                    sb.append("(");
                }
                if (this.select != null) {
                    sb.append(this.select);
                }
                if (this.useSelectBrackets) {
                    sb.append(")");
                }
            }
        }
        if (this.useDuplicate) {
            sb.append(" ON DUPLICATE KEY UPDATE ");
            for (int i = 0; i < this.getDuplicateUpdateColumns().size(); ++i) {
                if (i != 0) {
                    sb.append(", ");
                }
                sb.append(this.duplicateUpdateColumns.get(i)).append(" = ");
                sb.append(this.duplicateUpdateExpressionList.get(i));
            }
        }
        return sb.toString();
    }

    public Upsert withUseValues(boolean useValues) {
        this.setUseValues(useValues);
        return this;
    }

    public Upsert withSelect(Select select) {
        this.setSelect(select);
        return this;
    }

    public Upsert withUseSelectBrackets(boolean useSelectBrackets) {
        this.setUseSelectBrackets(useSelectBrackets);
        return this;
    }

    public Upsert withUseDuplicate(boolean useDuplicate) {
        this.setUseDuplicate(useDuplicate);
        return this;
    }

    public Upsert withDuplicateUpdateColumns(List<Column> duplicateUpdateColumns) {
        this.setDuplicateUpdateColumns(duplicateUpdateColumns);
        return this;
    }

    public Upsert withDuplicateUpdateExpressionList(List<Expression> duplicateUpdateExpressionList) {
        this.setDuplicateUpdateExpressionList(duplicateUpdateExpressionList);
        return this;
    }

    public Upsert withTable(Table table) {
        this.setTable(table);
        return this;
    }

    public Upsert withColumns(List<Column> columns) {
        this.setColumns(columns);
        return this;
    }

    public Upsert withItemsList(ItemsList itemsList) {
        this.setItemsList(itemsList);
        return this;
    }

    public Upsert addColumns(Column ... columns) {
        List collection = Optional.ofNullable(this.getColumns()).orElseGet(ArrayList::new);
        Collections.addAll(collection, columns);
        return this.withColumns(collection);
    }

    public Upsert addColumns(Collection<? extends Column> columns) {
        List collection = Optional.ofNullable(this.getColumns()).orElseGet(ArrayList::new);
        collection.addAll(columns);
        return this.withColumns(collection);
    }

    public Upsert addDuplicateUpdateColumns(Column ... duplicateUpdateColumns) {
        List collection = Optional.ofNullable(this.getDuplicateUpdateColumns()).orElseGet(ArrayList::new);
        Collections.addAll(collection, duplicateUpdateColumns);
        return this.withDuplicateUpdateColumns(collection);
    }

    public Upsert addDuplicateUpdateColumns(Collection<? extends Column> duplicateUpdateColumns) {
        List collection = Optional.ofNullable(this.getDuplicateUpdateColumns()).orElseGet(ArrayList::new);
        collection.addAll(duplicateUpdateColumns);
        return this.withDuplicateUpdateColumns(collection);
    }

    public Upsert addDuplicateUpdateExpressionList(Expression ... duplicateUpdateExpressionList) {
        List collection = Optional.ofNullable(this.getDuplicateUpdateExpressionList()).orElseGet(ArrayList::new);
        Collections.addAll(collection, duplicateUpdateExpressionList);
        return this.withDuplicateUpdateExpressionList(collection);
    }

    public Upsert addDuplicateUpdateExpressionList(Collection<? extends Expression> duplicateUpdateExpressionList) {
        List collection = Optional.ofNullable(this.getDuplicateUpdateExpressionList()).orElseGet(ArrayList::new);
        collection.addAll(duplicateUpdateExpressionList);
        return this.withDuplicateUpdateExpressionList(collection);
    }

    public <E extends ItemsList> E getItemsList(Class<E> type) {
        return (E)((ItemsList)type.cast(this.getItemsList()));
    }
}

