/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.config.Config;
import com.sun.deploy.security.AuthCacheBridge;
import com.sun.deploy.security.AuthKey;
import com.sun.deploy.security.CredentialInfo;
import com.sun.deploy.trace.Trace;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import sun.net.www.protocol.http.AuthCache;
import sun.net.www.protocol.http.AuthCacheImpl;
import sun.net.www.protocol.http.AuthCacheValue;

public class CredentialManager {
    public static final long LOGIN_SESSION_INVALID = -1L;
    static CredentialManager instance = null;
    private CredentialCache credCache = new CredentialCache();
    private CredentialPersistor persistor = new CredentialPersistor();
    private Map serverMap = CredentialPersistor.access$000(this.persistor);

    CredentialManager() {
        if (this.persistor.getSavedCredentialCount() > this.serverMap.size()) {
            this.persistor.persistAllCredentials(this.serverMap);
        }
        AuthCacheValue.setAuthCache((AuthCache)this.credCache);
    }

    public static synchronized CredentialManager getInstance() {
        if (instance == null) {
            instance = new CredentialManager();
        }
        return instance;
    }

    protected long getLoginSessionId() {
        return -1L;
    }

    protected boolean isPasswordEncryptionSupported() {
        return false;
    }

    protected boolean isPasswordStorageSupported() {
        return this.isPasswordEncryptionSupported();
    }

    protected byte[] encryptPassword(char[] cArray) {
        return new byte[0];
    }

    protected char[] decryptPassword(byte[] byArray) {
        return new char[0];
    }

    public void saveCredential(AuthKey authKey, CredentialInfo credentialInfo) {
        credentialInfo.setSessionId(this.getLoginSessionId());
        CredentialInfo credentialInfo2 = (CredentialInfo)credentialInfo.clone();
        if (this.isPasswordEncryptionSupported() && credentialInfo2.isPasswordSaveApproved()) {
            credentialInfo2.setEncryptedPassword(this.encryptPassword(credentialInfo.getPassword()));
        } else {
            credentialInfo2.setPassword(null);
        }
        String string = CredentialManager.buildConnectionKey(authKey);
        this.serverMap.put(string, credentialInfo2);
        this.persistor.persistCredential(string);
    }

    public boolean isCredentialValid(CredentialInfo credentialInfo) {
        boolean bl = false;
        if (credentialInfo.getUserName().length() > 0 && credentialInfo.getPassword().length > 0 && credentialInfo.getSessionId() != -1L && credentialInfo.getSessionId() == this.getLoginSessionId()) {
            bl = true;
        }
        return bl;
    }

    public static void removePersistantCredentials() {
        try {
            File file = new File(Config.getUserAuthFile());
            if (!file.delete()) {
                file.deleteOnExit();
            }
        }
        catch (Exception exception) {
            Trace.securityPrintException(exception);
        }
    }

    public void clearCredentialPassword(AuthKey authKey) {
        String string = CredentialManager.buildConnectionKey(authKey);
        CredentialInfo credentialInfo = this.findServerCredential(string);
        if (!this.serverMap.containsKey(string) && credentialInfo != null) {
            credentialInfo.setPassword(null);
            this.saveCredential(authKey, credentialInfo);
        }
        this.persistor.persistCredential(string);
    }

    protected CredentialInfo getCredential(AuthKey authKey) {
        byte[] byArray;
        String string = CredentialManager.buildConnectionKey(authKey);
        CredentialInfo credentialInfo = (CredentialInfo)this.serverMap.get(string);
        if (credentialInfo == null || credentialInfo != null && credentialInfo.isCredentialEmpty()) {
            credentialInfo = this.findServerCredential(string);
            if (credentialInfo != null) {
                credentialInfo.setSessionId(-1L);
            } else {
                credentialInfo = new CredentialInfo();
            }
        }
        if (credentialInfo.getPassword().length == 0 && (byArray = credentialInfo.getEncryptedPassword()).length > 0) {
            credentialInfo.setPassword(this.decryptPassword(byArray));
        }
        return credentialInfo;
    }

    private CredentialInfo findServerCredential(String string) {
        CredentialInfo credentialInfo = null;
        Set set = this.serverMap.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext() && (credentialInfo == null || credentialInfo.getEncryptedPassword().length == 0)) {
            CredentialInfo credentialInfo2;
            String string2 = (String)iterator.next();
            if (!CredentialManager.getServerFromKey(string).equals(CredentialManager.getServerFromKey(string2)) || (credentialInfo2 = (CredentialInfo)this.serverMap.get(string2)).isCredentialEmpty()) continue;
            credentialInfo = (CredentialInfo)this.serverMap.get(string2);
        }
        return credentialInfo;
    }

    private static String getServerFromKey(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        return stringTokenizer.nextToken();
    }

    public static String buildConnectionKey(AuthKey authKey) {
        StringBuffer stringBuffer = new StringBuffer();
        if (authKey.isProxy()) {
            stringBuffer.append("p:");
        } else {
            stringBuffer.append("s:");
        }
        stringBuffer.append(authKey.getProtocolScheme());
        stringBuffer.append(':');
        stringBuffer.append(authKey.getHost());
        stringBuffer.append(':');
        stringBuffer.append(authKey.getPort());
        stringBuffer.append(':');
        stringBuffer.append(authKey.getPath());
        return stringBuffer.toString().toLowerCase();
    }

    private class CredentialCache
    extends AuthCacheImpl {
        HashMap map = new HashMap();

        public CredentialCache() {
            this.setMap(this.map);
        }

        public void remove(String string, AuthCacheValue authCacheValue) {
            try {
                super.remove(string, authCacheValue);
                AuthKey authKey = AuthCacheBridge.create(authCacheValue);
                CredentialManager.getInstance().clearCredentialPassword(authKey);
            }
            catch (Exception exception) {
                Trace.securityPrintException(exception);
            }
        }
    }

    private class CredentialPersistor {
        private int credentialCount = 0;

        private int getSavedCredentialCount() {
            return this.credentialCount;
        }

        private synchronized void persistCredential(String string) {
            ObjectOutputStream objectOutputStream = null;
            try {
                CredentialInfo credentialInfo = (CredentialInfo)CredentialManager.this.serverMap.get(string);
                if (credentialInfo != null) {
                    OutputStream outputStream = this.openOutputFile(true);
                    objectOutputStream = new ObjectOutputStream(outputStream);
                    objectOutputStream.writeObject(string);
                    credentialInfo.writeExternal(objectOutputStream);
                    objectOutputStream.flush();
                    objectOutputStream.close();
                    outputStream.flush();
                    outputStream.close();
                }
            }
            catch (Exception exception) {
                Trace.securityPrintException(exception);
            }
        }

        private synchronized void deleteCredentials() {
            try {
                File file = new File(Config.getUserAuthFile());
                if (!file.delete()) {
                    file.deleteOnExit();
                }
            }
            catch (Exception exception) {
                Trace.securityPrintException(exception);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        private synchronized void persistAllCredentials(Map map) {
            block12: {
                ObjectOutputStream objectOutputStream = null;
                OutputStream outputStream = null;
                outputStream = this.openOutputFile(false);
                Set set = map.keySet();
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    objectOutputStream = new ObjectOutputStream(outputStream);
                    String string = (String)iterator.next();
                    CredentialInfo credentialInfo = (CredentialInfo)map.get(string);
                    objectOutputStream.writeObject(string);
                    credentialInfo.writeExternal(objectOutputStream);
                    objectOutputStream.flush();
                }
                Object var9_9 = null;
                try {
                    if (objectOutputStream != null) {
                        objectOutputStream.flush();
                    }
                    outputStream.flush();
                    outputStream.close();
                }
                catch (Exception exception) {
                    Trace.securityPrintException(exception);
                }
                break block12;
                {
                    catch (Throwable throwable) {
                        Trace.securityPrintException(throwable);
                        Object var9_10 = null;
                        try {
                            if (objectOutputStream != null) {
                                objectOutputStream.flush();
                            }
                            outputStream.flush();
                            outputStream.close();
                        }
                        catch (Exception exception) {
                            Trace.securityPrintException(exception);
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var9_11 = null;
                    try {
                        if (objectOutputStream != null) {
                            objectOutputStream.flush();
                        }
                        outputStream.flush();
                        outputStream.close();
                    }
                    catch (Exception exception) {
                        Trace.securityPrintException(exception);
                    }
                    throw throwable;
                }
            }
        }

        private synchronized void getPersistedCredential(ObjectInputStream objectInputStream, String string) {
            try {
                CredentialInfo credentialInfo = new CredentialInfo();
                credentialInfo.readExternal(objectInputStream);
                CredentialManager.this.serverMap.put(string, credentialInfo);
            }
            catch (Exception exception) {
                Trace.securityPrintException(exception);
            }
        }

        private synchronized InputStream openInputStream() {
            InputStream inputStream = null;
            try {
                final File file = new File(Config.getUserAuthFile());
                inputStream = (InputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IOException {
                        if (!file.exists()) {
                            file.getParentFile().mkdirs();
                            file.createNewFile();
                        }
                        return new BufferedInputStream(new FileInputStream(file));
                    }
                });
            }
            catch (Exception exception) {
                Trace.securityPrintException(exception);
            }
            return inputStream;
        }

        private synchronized OutputStream openOutputFile(final boolean bl) {
            OutputStream outputStream = null;
            try {
                final File file = new File(Config.getUserAuthFile());
                outputStream = (OutputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IOException {
                        if (!file.exists()) {
                            file.getParentFile().mkdirs();
                            file.createNewFile();
                        }
                        return new BufferedOutputStream(new FileOutputStream(file, bl));
                    }
                });
            }
            catch (Exception exception) {
                Trace.securityPrintException(exception);
            }
            return outputStream;
        }

        private synchronized Map getAllPersistedCredentials() {
            ObjectInputStream objectInputStream = null;
            InputStream inputStream = null;
            HashMap<String, CredentialInfo> hashMap = null;
            try {
                hashMap = new HashMap<String, CredentialInfo>();
                inputStream = this.openInputStream();
                objectInputStream = new ObjectInputStream(inputStream);
                while (objectInputStream != null) {
                    String string = (String)objectInputStream.readObject();
                    CredentialInfo credentialInfo = new CredentialInfo();
                    credentialInfo.readExternal(objectInputStream);
                    hashMap.put(string, credentialInfo);
                    ++this.credentialCount;
                    objectInputStream = new ObjectInputStream(inputStream);
                }
                inputStream.close();
            }
            catch (EOFException eOFException) {
            }
            catch (Exception exception) {
                Trace.securityPrintException(exception);
                try {
                    inputStream.close();
                    if (this.credentialCount > 0) {
                        this.persistAllCredentials(hashMap);
                    }
                }
                catch (Exception exception2) {
                    Trace.securityPrintException(exception);
                }
            }
            return hashMap;
        }

        static /* synthetic */ Map access$000(CredentialPersistor credentialPersistor) {
            return credentialPersistor.getAllPersistedCredentials();
        }
    }
}

