/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xdts.rmo;

import ext.base.core.BcConstants;
import ext.base.core.BcStringUtil;
import ext.base.io.BcFileUtil;
import ext.base.log.BcLogUtil;
import ext.base.mmd.MmdField;
import ext.base.mmd.MmdModel;
import ext.base.table.BcTableColumnModel;
import ext.base.table.BcTableModel;
import ext.base.util.BcCollectionUtil;
import ext.base.util.BcResult;
import ext.lib.datasource.DtsSession;
import ext.lib.datasource.DtsSessionFactory;
import ext.lib.datasource.util.ScfMmdServerUtil;
import ext.lib.rmi.common.RmiRemoteMethod;
import ext.lib.rmi.model.RmiRmoArgument;
import ext.lib.rmi.rmo.RmiAbstractRMO;
import ext.lib.sql.SqlExecutor;
import ext.lib.sql.context.SqlContext;
import ext.lib.sql.context.SqlContextFactory;
import ext.lib.sql.context.SqlTableMetadata;
import ext.module.xdts.common.XdtsConstants;
import ext.module.xdts.common.XdtsUtil;
import ext.module.xdts.model.XdtsProcessCondition;
import ext.module.xdts.model.XdtsSchemaObject;
import ext.module.xdts.model.XsysCompareCondition;
import ext.module.xdts.server.XdtsServerUtil;
import ext.module.xdts.server.XdtsSessionFactoryManager;
import ext.module.xdts.server.XsysCompareTask;
import ext.module.xmmd.model.XmmdModel;
import ext.module.xmmd.server.XmmdServerUtil;
import ext.scf.server.ScfServerLogger;
import ext.scf.server.ScfServerLoggerManager;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;

public class XdtsSchemaRMO
extends RmiAbstractRMO {
    public static final String METHOD_getTableNameList = "getTableNameList";
    public static final String METHOD_getViewNameList = "getViewNameList";
    public static final String METHOD_getMmdModelMap = "getMmdModelMap";
    public static final String METHOD_getXmmdModelMap = "getXmmdModelMap";
    public static final String METHOD_getTableMetadataMap = "getTableMetadataMap";
    public static final String METHOD_updateQuery = "updateQuery";
    public static final String METHOD_createCrateTableSql = "createCrateTableSql";
    public static final String METHOD_createInsertSql = "createInsertSql";
    public static final String METHOD_copyToOther = "copyToOther";
    public static final String METHOD_countSize = "countSize";
    public static final String METHOD_compareSchema = "compareSchema";

    public void getTableNameList(RmiRmoArgument rmoArg) throws Exception {
        int profileId = rmoArg.getRequest().getDataAsInteger();
        DtsSession dtsSession = rmoArg.getDtsSession(this);
        DtsSessionFactory dtsSessionFactoryWk1 = XdtsSessionFactoryManager.getInstance().getSessionFactory(dtsSession, profileId);
        Throwable throwable = null;
        Object var6_8 = null;
        try (DtsSession dtsSessionWk1 = dtsSessionFactoryWk1.createSession(this);){
            SqlContext sqlContextWk1 = dtsSessionWk1.getSqlContext();
            List<String> tableNameList = sqlContextWk1.getTableNameList(dtsSessionWk1.getConnection());
            if (XdtsConstants.LIMIT_tableCount > 0) {
                int n = BcCollectionUtil.setHeadSize(tableNameList, XdtsConstants.LIMIT_tableCount);
            }
            rmoArg.getRespons().addData(tableNameList);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void getViewNameList(RmiRmoArgument rmoArg) throws Exception {
        int profileId1 = rmoArg.getRequest().getDataAsInteger();
        DtsSession dtsSession = rmoArg.getDtsSession(this);
        DtsSessionFactory dtsSessionFactoryWk1 = XdtsSessionFactoryManager.getInstance().getSessionFactory(dtsSession, profileId1);
        Throwable throwable = null;
        Object var6_8 = null;
        try (DtsSession dtsSessionWk1 = dtsSessionFactoryWk1.createSession(this);){
            SqlContext sqlContextWk1 = dtsSessionWk1.getSqlContext();
            List<String> viewNameList = sqlContextWk1.getViewNameList(dtsSessionWk1.getConnection());
            if (XdtsConstants.LIMIT_tableCount > 0) {
                int n = BcCollectionUtil.setHeadSize(viewNameList, XdtsConstants.LIMIT_tableCount);
            }
            rmoArg.getRespons().addData(viewNameList);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void getMmdModelMap(RmiRmoArgument rmoArg) throws Exception {
        int profileId1 = rmoArg.getRequest().getDataAsInteger();
        Collection tableNameCollection = (Collection)rmoArg.getRequest().getData();
        DtsSession dtsSession = rmoArg.getDtsSession(this);
        DtsSessionFactory dtsSessionFactoryWk1 = XdtsSessionFactoryManager.getInstance().getSessionFactory(dtsSession, profileId1);
        Throwable throwable = null;
        Object var7_9 = null;
        try (DtsSession dtsSessionWk1 = dtsSessionFactoryWk1.createSession(this);){
            Map<String, MmdModel> mmdMap = XdtsServerUtil.getInstance().createMmdModelMap(dtsSessionWk1, tableNameCollection);
            for (Map.Entry<String, MmdModel> mapEntry : mmdMap.entrySet()) {
                MmdModel mmdModel = mapEntry.getValue();
                int i = 0;
                while (i < mmdModel.getFieldCount()) {
                    MmdField mmdField = mmdModel.getField(i);
                    ScfMmdServerUtil.setMmdDisplayName(mmdField, dtsSessionFactoryWk1.wordManager, Locale.JAPANESE);
                    ++i;
                }
            }
            rmoArg.getRespons().addData(mmdMap);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void getXmmdModelMap(RmiRmoArgument rmoArg) throws Exception {
        int profileId1 = rmoArg.getRequest().getDataAsInteger();
        Collection tableNameCollection = (Collection)rmoArg.getRequest().getData();
        DtsSession dtsSession = rmoArg.getDtsSession(this);
        DtsSessionFactory dtsSessionFactoryWk1 = XdtsSessionFactoryManager.getInstance().getSessionFactory(dtsSession, profileId1);
        Throwable throwable = null;
        Object var7_9 = null;
        try (DtsSession dtsSessionWk1 = dtsSessionFactoryWk1.createSession(this);){
            SqlContext sqlContextWk = dtsSessionWk1.getSqlContext();
            TreeMap<String, XmmdModel> xmmdMap = new TreeMap<String, XmmdModel>();
            for (String tableName : tableNameCollection) {
                XmmdModel xmmdModel = XmmdServerUtil.getInstance().createXmmdModel(dtsSessionWk1.getConnection(), tableName, true, sqlContextWk);
                xmmdModel.schemaId = profileId1;
                xmmdMap.put(tableName, xmmdModel);
            }
            rmoArg.getRespons().addData(xmmdMap);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void getTableMetadataMap(RmiRmoArgument rmoArg) throws Exception {
        int profileId1 = rmoArg.getRequest().getDataAsInteger();
        Collection tableNameCollection = (Collection)rmoArg.getRequest().getData();
        DtsSession dtsSession = rmoArg.getDtsSession(this);
        DtsSessionFactory dtsSessionFactoryWk1 = XdtsSessionFactoryManager.getInstance().getSessionFactory(dtsSession, profileId1);
        Throwable throwable = null;
        Object var7_9 = null;
        try (DtsSession dtsSessionWk1 = dtsSessionFactoryWk1.createSession(this);){
            SqlContext sqlContextWk = dtsSessionWk1.getSqlContext();
            TreeMap<String, SqlTableMetadata> tableMetadataMap = new TreeMap<String, SqlTableMetadata>();
            for (String tableName : tableNameCollection) {
                String tableName2 = sqlContextWk.tableNameToDB(dtsSession.getConnection(), tableName);
                SqlTableMetadata tableMetadata = sqlContextWk.getTableMetadata(dtsSession.getConnection(), tableName2);
                tableMetadataMap.put(tableName2, tableMetadata);
            }
            rmoArg.getRespons().addData(tableMetadataMap);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void updateQuery(RmiRmoArgument rmoArg) throws Exception {
        XdtsProcessCondition processCondition = (XdtsProcessCondition)rmoArg.getRequest().getData();
        String loggerHandleId = (String)rmoArg.getRequest().getObject("lhId");
        ScfServerLogger logger = ScfServerLoggerManager.getInstance().getLogger(loggerHandleId);
        DtsSession dtsSession = rmoArg.getDtsSession(this);
        DtsSessionFactory dtsSessionFactoryWk1 = XdtsSessionFactoryManager.getInstance().getSessionFactory(dtsSession, processCondition.profileId);
        Throwable throwable = null;
        Object var8_10 = null;
        try (DtsSession dtsSessionWk1 = dtsSessionFactoryWk1.createSession(this);){
            if (processCondition.commitMode == XdtsConstants.CommitMode.AUTO) {
                dtsSessionWk1.getConnection().setAutoCommit(true);
            }
            this.updateQuery_L2(logger, dtsSessionWk1, processCondition);
            rmoArg.getRespons().addData("success");
            if (processCondition.commitMode == XdtsConstants.CommitMode.FINAL) {
                dtsSessionWk1.commit();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected void updateQuery_L2(ScfServerLogger logger, DtsSession dtsSessionWk1, XdtsProcessCondition processCondition) throws Exception {
        SqlContext sqlContextWk1 = dtsSessionWk1.getSqlContext();
        File destFile = new File(processCondition.destFilePath);
        logger.info("destFile=" + destFile.getPath());
        BcFileUtil.makeParent(destFile);
        File errorFile = new File(processCondition.errorFilePath);
        logger.info("errorFile=" + errorFile.getPath());
        BcFileUtil.makeParent(errorFile);
        OutputStreamWriter writer1 = null;
        OutputStreamWriter errorWriter = null;
        try {
            writer1 = new OutputStreamWriter((OutputStream)new FileOutputStream(destFile, processCondition.append), BcConstants.charset.name());
            errorWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(errorFile, processCondition.append), BcConstants.charset.name());
            SqlExecutor sqlExecutor = new SqlExecutor();
            sqlExecutor.iqnoreException = processCondition.ignoreException;
            int i = 0;
            while (i < processCondition.schemaObjectList.size()) {
                XdtsSchemaObject schemaObject = processCondition.schemaObjectList.get(i);
                logger.info("[" + (i + 1) + "/" + processCondition.schemaObjectList.size() + "] tableName=" + schemaObject.name1);
                if (i > 0) {
                    writer1.write(BcStringUtil.lineSeparator);
                }
                this.updateQuery_L3(logger, dtsSessionWk1, processCondition, schemaObject, writer1, errorWriter, sqlExecutor);
                ++i;
            }
        }
        finally {
            if (writer1 != null) {
                try {
                    writer1.close();
                }
                catch (Exception ex) {
                    logger.error(ex);
                }
            }
            if (errorWriter != null) {
                try {
                    errorWriter.close();
                }
                catch (Exception ex) {
                    logger.error(ex);
                }
            }
        }
    }

    protected void updateQuery_L3(ScfServerLogger logger, DtsSession dtsSessionWk1, XdtsProcessCondition processCondition, XdtsSchemaObject schemaObject, Writer writer1, Writer errorWriter, SqlExecutor sqlExecutor) throws Exception {
        block7: {
            SqlContext sqlContextWk1 = dtsSessionWk1.getSqlContext();
            String query = null;
            if (schemaObject.schemaObjectType == XdtsConstants.SchemaObjectType.table) {
                query = processCondition.query.replace("${tableName}", schemaObject.name1);
            } else if (schemaObject.schemaObjectType == XdtsConstants.SchemaObjectType.view) {
                query = processCondition.query.replace("${viewName}", schemaObject.name1);
            }
            logger.info("query=" + query);
            writer1.write(query);
            writer1.write(59);
            writer1.write(BcStringUtil.lineSeparator);
            if (processCondition.executeQuery) {
                try {
                    StringReader stringReader = new StringReader(query);
                    sqlExecutor.execute(dtsSessionWk1.getConnection(), sqlContextWk1, stringReader, new Object[0]);
                    if (processCondition.commitMode == XdtsConstants.CommitMode.TABLE) {
                        dtsSessionWk1.commit();
                    }
                }
                catch (Exception ex) {
                    String stackTrace = BcLogUtil.getStackTrace(ex);
                    errorWriter.append(stackTrace);
                    logger.error(stackTrace);
                    if (processCondition.ignoreException) break block7;
                    throw ex;
                }
            }
        }
    }

    public void createCrateTableSql(RmiRmoArgument rmoArg) throws Exception {
        XdtsProcessCondition processCondition = (XdtsProcessCondition)rmoArg.getRequest().getData();
        String loggerHandleId = (String)rmoArg.getRequest().getObject("lhId");
        ScfServerLogger logger = ScfServerLoggerManager.getInstance().getLogger(loggerHandleId);
        DtsSession dtsSession = rmoArg.getDtsSession(this);
        DtsSessionFactory dtsSessionFactoryWk1 = XdtsSessionFactoryManager.getInstance().getSessionFactory(dtsSession, processCondition.profileId);
        Throwable throwable = null;
        Object var8_10 = null;
        try (DtsSession dtsSessionWk1 = dtsSessionFactoryWk1.createSession(this);){
            this.createCrateTableSql_L2(dtsSessionWk1, processCondition, logger);
            rmoArg.getRespons().addData("success");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected void createCrateTableSql_L2(DtsSession dtsSessionWk1, XdtsProcessCondition processCondition, ScfServerLogger logger) throws Exception {
        SqlContext sqlContextWk1 = dtsSessionWk1.getSqlContext();
        SqlContext sqlContextWk2 = SqlContextFactory.getSqlContext(processCondition.databaseProduct);
        File destFile = new File(processCondition.destFilePath);
        logger.info("destFile=" + destFile.getPath());
        BcFileUtil.makeParent(destFile);
        FileOutputStream os = new FileOutputStream(destFile, processCondition.append);
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)os, BcConstants.charset.name());){
            int i = 0;
            while (i < processCondition.schemaObjectList.size()) {
                if (i > 0) {
                    writer.write(BcStringUtil.lineSeparator);
                }
                XdtsSchemaObject schemaObject = processCondition.schemaObjectList.get(i);
                logger.info("tableName=" + schemaObject.name1);
                MmdModel mmdModel1 = sqlContextWk1.createModelMetaData(dtsSessionWk1.getConnection(), schemaObject.name1);
                String query = sqlContextWk2.createCreateTableQuery(mmdModel1, true, processCondition.definitionCondition);
                writer.write(query);
                writer.write(59);
                writer.write(BcStringUtil.lineSeparator);
                ++i;
            }
        }
    }

    public void createInsertSql(RmiRmoArgument rmoArg) throws Exception {
        XdtsProcessCondition processCondition = (XdtsProcessCondition)rmoArg.getRequest().getData();
        String loggerHandleId = (String)rmoArg.getRequest().getObject("lhId");
        ScfServerLogger logger = ScfServerLoggerManager.getInstance().getLogger(loggerHandleId);
        DtsSession dtsSession = rmoArg.getDtsSession(this);
        DtsSessionFactory dtsSessionFactoryWk1 = XdtsSessionFactoryManager.getInstance().getSessionFactory(dtsSession, processCondition.profileId);
        Throwable throwable = null;
        Object var8_10 = null;
        try (DtsSession dtsSessionWk1 = dtsSessionFactoryWk1.createSession(this);){
            SqlContext sqlContextWk2 = SqlContextFactory.getSqlContext(processCondition.databaseProduct);
            XdtsServerUtil.getInstance().createInsertQuery_L2(dtsSessionWk1, processCondition.schemaObjectList, sqlContextWk2, processCondition, logger);
            rmoArg.getRespons().addData("success");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void copyToOther(RmiRmoArgument rmoArg) throws Exception {
        XdtsProcessCondition processCondition = (XdtsProcessCondition)rmoArg.getRequest().getData();
        String loggerHandleId = (String)rmoArg.getRequest().getObject("lhId");
        ScfServerLogger logger = ScfServerLoggerManager.getInstance().getLogger(loggerHandleId);
        DtsSession dtsSession = rmoArg.getDtsSession(this);
        DtsSessionFactory dtsSessionFactoryWk1 = XdtsSessionFactoryManager.getInstance().getSessionFactory(dtsSession, processCondition.profileId);
        DtsSessionFactory dtsSessionFactoryWk2 = XdtsSessionFactoryManager.getInstance().createSessionFactory(processCondition.profile2);
        Throwable throwable = null;
        Object var9_11 = null;
        try {
            DtsSession dtsSessionWk1 = dtsSessionFactoryWk1.createSession(this);
            try {
                try (DtsSession dtsSessionWk2 = dtsSessionFactoryWk2.createSession(this);){
                    XdtsServerUtil.getInstance().copyRecords(dtsSessionWk1.getConnection(), dtsSessionWk2.getConnection(), processCondition.schemaObjectList, processCondition, logger);
                }
                if (dtsSessionWk1 != null) {
                    dtsSessionWk1.close();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (dtsSessionWk1 != null) {
                    dtsSessionWk1.close();
                }
                throw throwable;
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    public void countSize(RmiRmoArgument rmoArg) throws Exception {
        int profileId1 = rmoArg.getRequest().getDataAsInteger();
        List schemaObjectList = (List)rmoArg.getRequest().getData();
        String loggerHandleId = (String)rmoArg.getRequest().getObject("lhId");
        ScfServerLogger logger = ScfServerLoggerManager.getInstance().getLogger(loggerHandleId);
        DtsSession dtsSession = rmoArg.getDtsSession(this);
        DtsSessionFactory dtsSessionFactoryWk1 = XdtsSessionFactoryManager.getInstance().getSessionFactory(dtsSession, profileId1);
        Throwable throwable = null;
        Object var9_11 = null;
        try (DtsSession dtsSessionWk1 = dtsSessionFactoryWk1.createSession(this);){
            BcTableColumnModel tableColumnModel = XdtsUtil.createSizeTableColumnModel();
            BcTableModel tableModel = new BcTableModel(tableColumnModel);
            this.countSize_L2(dtsSessionWk1, schemaObjectList, tableModel, logger);
            rmoArg.getRespons().addData(tableModel);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected void countSize_L2(DtsSession dtsSessionWk1, List<XdtsSchemaObject> schemaObjectList, BcTableModel tableModel, ScfServerLogger logger) throws Exception {
        int i = 0;
        while (i < schemaObjectList.size()) {
            XdtsSchemaObject schemaObject = schemaObjectList.get(i);
            SqlContext sqlContextWk1 = dtsSessionWk1.getSqlContext();
            if (sqlContextWk1.existTable(dtsSessionWk1.getConnection(), schemaObject.name1)) {
                List row = this.countSize_L3(dtsSessionWk1, schemaObject, logger);
                tableModel.addRow(row);
            }
            ++i;
        }
    }

    protected List countSize_L3(DtsSession dtsSessionWk1, XdtsSchemaObject schemaObject, ScfServerLogger logger) throws Exception {
        SqlContext sqlContextWk1 = dtsSessionWk1.getSqlContext();
        ArrayList<Object> row = new ArrayList<Object>();
        logger.info("schemaObject=" + schemaObject.name1);
        row.add(schemaObject.name1);
        long rowCount = sqlContextWk1.getRowCount(dtsSessionWk1.getConnection(), schemaObject.name1);
        row.add(rowCount);
        MmdModel mmdModel = sqlContextWk1.createModelMetaData(dtsSessionWk1.getConnection(), schemaObject.name1);
        long sizeSum = this.countSize(mmdModel, logger);
        row.add(sizeSum);
        return row;
    }

    protected long countSize(MmdModel mmdModel, ScfServerLogger logger) throws Exception {
        long sizeSum = 0L;
        int i = 0;
        while (i < mmdModel.getFieldCount()) {
            MmdField mmdField = mmdModel.getField(i);
            sizeSum += this.countSize(mmdField, logger);
            ++i;
        }
        return sizeSum;
    }

    protected long countSize(MmdField mmdField, ScfServerLogger logger) throws Exception {
        long size = 0L;
        switch (mmdField.sqlTypeId) {
            case -7: 
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                size = mmdField.dataSize;
                break;
            }
            case 1: 
            case 12: {
                size = mmdField.dataSize;
                break;
            }
            case 91: 
            case 92: 
            case 93: {
                size = mmdField.dataSize;
                break;
            }
            case -4: 
            case -3: 
            case -2: 
            case -1: {
                logger.info("error");
                break;
            }
            case 1111: 
            case 2000: 
            case 2001: 
            case 2002: 
            case 2003: 
            case 2004: 
            case 2005: 
            case 2006: {
                logger.info("error");
                break;
            }
            default: {
                throw new Exception("Not suport sqlType=" + mmdField.sqlTypeId);
            }
        }
        return size;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void compareSchema(RmiRmoArgument rmoArg) throws Exception {
        XsysCompareCondition compareCondition = (XsysCompareCondition)rmoArg.getRequest().getData();
        String loggerHandleId = (String)rmoArg.getRequest().getObject("lhId");
        ScfServerLogger logger = ScfServerLoggerManager.getInstance().getLogger(loggerHandleId);
        DtsSession dtsSession = rmoArg.getDtsSession(this);
        Throwable throwable = null;
        Object var7_9 = null;
        try {
            DtsSessionFactory dtsSessionFactoryWk1 = XdtsSessionFactoryManager.getInstance().createSessionFactory(compareCondition.profile1);
            try {
                try (DtsSessionFactory dtsSessionFactoryWk2 = XdtsSessionFactoryManager.getInstance().createSessionFactory(compareCondition.profile2);){
                    Throwable throwable2 = null;
                    Object var11_17 = null;
                    try {
                        DtsSession dtsSessionWk1 = dtsSessionFactoryWk1.createSession(this);
                        try {
                            try (DtsSession dtsSessionWk2 = dtsSessionFactoryWk2.createSession(this);){
                                XsysCompareTask compareTask = new XsysCompareTask();
                                compareTask.setLogger(logger);
                                compareTask.setCondition(compareCondition, dtsSessionWk1, dtsSessionWk2);
                                BcResult result = compareTask.taskProcess();
                                rmoArg.getRespons().addData(result);
                                rmoArg.getRespons().addData(compareTask.tableTable);
                                rmoArg.getRespons().addData(compareTask.viewTable);
                                rmoArg.getRespons().addData(compareTask.tableFieldMap);
                                rmoArg.getRespons().addData(compareTask.viewFieldMap);
                            }
                            if (dtsSessionWk1 != null) {
                                dtsSessionWk1.close();
                            }
                        }
                        catch (Throwable throwable3) {
                            if (throwable2 == null) {
                                throwable2 = throwable3;
                            } else if (throwable2 != throwable3) {
                                throwable2.addSuppressed(throwable3);
                            }
                            if (dtsSessionWk1 == null) throw throwable2;
                            dtsSessionWk1.close();
                            throw throwable2;
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable2 == null) {
                            throwable2 = throwable4;
                            throw throwable2;
                        } else {
                            if (throwable2 == throwable4) throw throwable2;
                            throwable2.addSuppressed(throwable4);
                        }
                        throw throwable2;
                    }
                }
                if (dtsSessionFactoryWk1 == null) return;
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                } else if (throwable != throwable5) {
                    throwable.addSuppressed(throwable5);
                }
                if (dtsSessionFactoryWk1 == null) throw throwable;
                dtsSessionFactoryWk1.close();
                throw throwable;
            }
            dtsSessionFactoryWk1.close();
            return;
        }
        catch (Throwable throwable6) {
            if (throwable == null) {
                throwable = throwable6;
                throw throwable;
            } else {
                if (throwable == throwable6) throw throwable;
                throwable.addSuppressed(throwable6);
            }
            throw throwable;
        }
    }

    public static enum Method implements RmiRemoteMethod
    {
        countSize;


        @Override
        public String getMethodName() {
            return this.name();
        }
    }
}

