/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.orm.persistence;

import ext.base.core.BcInteger;
import ext.base.core.BcTimeUtil;
import ext.base.mmd.MmdField;
import ext.lib.datasource.DtsSession;
import ext.lib.orm.entity.OrmGeneralData;
import ext.lib.orm.entity.OrmOverwrite;
import ext.lib.orm.persistence.OrmAbstractPersistence;
import ext.lib.sql.SqlResultSet;
import ext.lib.sql.SqlUtil;
import ext.lib.sql.context.SqlContext;
import ext.lib.sql.model.SqlSetClause;
import ext.lib.sql.model.SqlUpdateQuery;
import java.sql.PreparedStatement;
import java.util.List;

public class OrmPersistenceOverwrite
extends OrmAbstractPersistence {
    public void preTrans(DtsSession dtsSession, int userId, String tableName, Object entity) throws Exception {
        Class<?> entityType = entity.getClass();
        OrmOverwrite etdmOverwrite = (OrmOverwrite)entity;
        if (etdmOverwrite.getDataId() > 0) {
            etdmOverwrite.setUpdateTimestamp(BcTimeUtil.createCalendar());
            etdmOverwrite.setUpdateUserId(userId);
        }
    }

    @Override
    public void setSetClause(SqlContext sqlContext, List<String> setElementList, Object dataObject) throws Exception {
        if (!OrmOverwrite.class.isAssignableFrom(dataObject.getClass())) {
            return;
        }
        OrmOverwrite etdmOverwrite = (OrmOverwrite)dataObject;
        setElementList.add("sy_update_time=" + sqlContext.toSet(etdmOverwrite.getUpdateTimestamp()));
        setElementList.add("sy_update_user_id=" + etdmOverwrite.getUpdateUserId());
        setElementList.add("sy_delete_time=" + sqlContext.toSet(etdmOverwrite.getDeleteTimestamp()));
        setElementList.add("sy_delete_user_id=" + etdmOverwrite.getDeleteUserId());
    }

    @Override
    public void setSetClause(SqlUpdateQuery updateQuery, Object dataObject) throws Exception {
        if (!OrmOverwrite.class.isAssignableFrom(dataObject.getClass())) {
            return;
        }
        OrmOverwrite etdmOverwrite = (OrmOverwrite)dataObject;
        updateQuery.addSetClause(new SqlSetClause("sy_update_time", etdmOverwrite.getUpdateTimestamp()));
        updateQuery.addSetClause(new SqlSetClause("sy_update_user_id", etdmOverwrite.getUpdateUserId()));
        updateQuery.addSetClause(new SqlSetClause("sy_delete_time", etdmOverwrite.getDeleteTimestamp()));
        updateQuery.addSetClause(new SqlSetClause("sy_delete_user_id", etdmOverwrite.getDeleteUserId()));
    }

    @Override
    public void setSetClause(List<String> setColumnList, Class entityType) throws Exception {
        if (!OrmOverwrite.class.isAssignableFrom(entityType)) {
            return;
        }
        setColumnList.add("sy_update_time");
        setColumnList.add("sy_update_user_id");
        setColumnList.add("sy_delete_time");
        setColumnList.add("sy_delete_user_id");
    }

    @Override
    public void setSetClause(SqlUpdateQuery updateQuery, OrmGeneralData generalData, Class entityType) throws Exception {
        if (!OrmOverwrite.class.isAssignableFrom(entityType)) {
            return;
        }
        int i = 0;
        while (i < generalData.getModel().getFieldCount()) {
            MmdField mmdField = generalData.getModel().getField(i);
            Object valueObject = generalData.getValue(i);
            if (mmdField.columnName.equals("sy_update_time")) {
                updateQuery.addSetClause(new SqlSetClause("sy_update_time", valueObject));
            } else if (mmdField.columnName.equals("sy_update_user_id")) {
                updateQuery.addSetClause(new SqlSetClause("sy_update_user_id", valueObject));
            } else if (mmdField.columnName.equals("sy_delete_time")) {
                updateQuery.addSetClause(new SqlSetClause("sy_delete_time", valueObject));
            } else if (mmdField.columnName.equals("sy_delete_user_id")) {
                updateQuery.addSetClause(new SqlSetClause("sy_delete_user_id", valueObject));
            }
            ++i;
        }
    }

    @Override
    public void getJdbcTypes(List<Integer> sqlTypeList, Class entityType) throws Exception {
        if (!OrmOverwrite.class.isAssignableFrom(entityType)) {
            return;
        }
        sqlTypeList.add(93);
        sqlTypeList.add(4);
        sqlTypeList.add(93);
        sqlTypeList.add(4);
    }

    @Override
    public void setPreStmtValue(SqlContext sqlContext, PreparedStatement preStmt, BcInteger columnIndex, Object dataObject) throws Exception {
        if (!OrmOverwrite.class.isAssignableFrom(dataObject.getClass())) {
            return;
        }
        OrmOverwrite etdmOverwrite = (OrmOverwrite)dataObject;
        sqlContext.setPreStmtValue(preStmt, columnIndex, 93, (Object)etdmOverwrite.getUpdateTimestamp());
        sqlContext.setPreStmtValue(preStmt, columnIndex, 4, (Object)etdmOverwrite.getUpdateUserId());
        sqlContext.setPreStmtValue(preStmt, columnIndex, 93, (Object)etdmOverwrite.getDeleteTimestamp());
        sqlContext.setPreStmtValue(preStmt, columnIndex, 4, (Object)etdmOverwrite.getDeleteUserId());
    }

    @Override
    public void setValueList(List<Object> valueList, Object dataObject) throws Exception {
        if (!OrmOverwrite.class.isAssignableFrom(dataObject.getClass())) {
            return;
        }
        OrmOverwrite etdmOverwrite = (OrmOverwrite)dataObject;
        valueList.add(etdmOverwrite.getUpdateTimestamp());
        valueList.add(etdmOverwrite.getUpdateUserId());
        valueList.add(etdmOverwrite.getDeleteTimestamp());
        valueList.add(etdmOverwrite.getDeleteUserId());
    }

    @Override
    public void getSelectColumnName(List<String> columnNameList, String tableAlias, Class entityType) throws Exception {
        if (!OrmOverwrite.class.isAssignableFrom(entityType)) {
            return;
        }
        String tableAlias2 = SqlUtil.tableAliasToNotNull(tableAlias);
        columnNameList.add(String.valueOf(tableAlias2) + "sy_update_time");
        columnNameList.add(String.valueOf(tableAlias2) + "sy_update_user_id");
        columnNameList.add(String.valueOf(tableAlias2) + "sy_delete_time");
        columnNameList.add(String.valueOf(tableAlias2) + "sy_delete_user_id");
    }

    @Override
    public void setResultSet(DtsSession dtsSession, SqlResultSet rs, BcInteger columnIndex, Object dataObject) throws Exception {
        if (!OrmOverwrite.class.isAssignableFrom(dataObject.getClass())) {
            return;
        }
        OrmOverwrite etdmOverwrite = (OrmOverwrite)dataObject;
        etdmOverwrite.setUpdateTimestamp(rs.getCalendar(columnIndex));
        etdmOverwrite.setUpdateUserId(rs.getInt(columnIndex));
        etdmOverwrite.setDeleteTimestamp(rs.getCalendar(columnIndex));
        etdmOverwrite.setDeleteUserId(rs.getInt(columnIndex));
    }
}

