/*
 * Decompiled with CFR 0.152.
 */
package ext.libx.fx.viewer;

import ext.base.core.BcStringUtil;
import ext.base.log.BcLogUtil;
import ext.base.net.BcNetUtil;
import ext.lib.fx.FxPlatform;
import ext.lib.fx.layout.FxBorderPane;
import ext.lib.fx.skin.FxCssUtil;
import ext.lib.fx.util.FxDragAndDropHelper;
import ext.lib.fx.util.FxUtil;
import ext.lib.task.TskAbstractCallable;
import ext.libx.fx.FxxMouseEventUtil;
import ext.libx.fx.media.FxxMediaPane;
import ext.libx.fx.viewer.FxxContentNode;
import ext.libx.fx.viewer.FxxFileManager;
import ext.libx.fx.viewer.FxxLayoutCondition;
import ext.libx.fx.viewer.FxxMultiTouchRegion;
import ext.libx.fx.viewer.FxxViewControlPane;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javafx.scene.Node;
import javafx.scene.control.ScrollPane;
import javafx.scene.image.Image;
import javafx.scene.layout.Region;

public class FxxMultiTouchViewPane
extends FxBorderPane {
    FxxMultiTouchRegion multiTouchRegion = new FxxMultiTouchRegion();
    ScrollPane scrollPane = new ScrollPane();
    public FxxViewControlPane viewControlPane = new FxxViewControlPane();
    FxxLayoutCondition layoutCondition = new FxxLayoutCondition();
    Map<String, Node> uriMap = new HashMap<String, Node>();
    public List<FxxContentNode> contentList = new ArrayList<FxxContentNode>();
    FxDragAndDropHelper dagAndDropHelper = new InnerDragAndDropHelper();
    TempTask tempTask;

    public FxxMultiTouchViewPane() throws Exception {
        this.viewControlPane.setFxxOvserver(this.multiTouchRegion);
        this.viewControlPane.setLayoutCondition(this.layoutCondition);
        this.viewControlPane.setPrefHeight(60.0);
        this.setBottom((Node)this.viewControlPane);
        this.multiTouchRegion.setOpacity(1.0);
        this.scrollPane.setContent((Node)this.multiTouchRegion);
        this.scrollPane.setFitToWidth(true);
        FxUtil.setMinSizeBinding((Region)this.scrollPane, this.multiTouchRegion);
        this.setCenter((Node)this.scrollPane);
        this.clear();
        StringBuilder style = new StringBuilder();
        BcStringUtil.appendExceptEmpty(style, ";", FxCssUtil.css_backgroundColor_linearGradient("#1B314B", "#465B77", 4));
        this.setStyle(style.toString());
        this.dagAndDropHelper.setup((Node)this.multiTouchRegion);
    }

    public void clear() throws Exception {
        this.uriMap.clear();
        FxxFileManager.getInstance().clear();
        if (this.tempTask != null) {
            this.tempTask.exit = true;
        }
        this.multiTouchRegion.getNodeList().clear();
        this.layoutCondition.clear();
        this.contentList.clear();
    }

    public void addContentNode(FxxContentNode contentNode) throws Exception {
        if (this.contentList.contains((Object)contentNode)) {
            return;
        }
        this.contentList.add(contentNode);
        FxxMouseEventUtil.layoutChildren((Region)this.multiTouchRegion, (Node)contentNode, this.layoutCondition);
        this.multiTouchRegion.getNodeList().add((Object)contentNode);
        FxxMouseEventUtil.setMoveLotate((Node)contentNode);
    }

    public FxxContentNode addUri(URI uri) throws Exception {
        FxxContentNode contentNode = (FxxContentNode)this.uriMap.get(uri.toString());
        if (contentNode != null) {
            return contentNode;
        }
        contentNode = new FxxContentNode();
        contentNode.uri = uri;
        contentNode.text.setText(BcNetUtil.getFileName(uri));
        this.addContentNode(contentNode);
        this.uriMap.put(uri.toString(), (Node)contentNode);
        FxxFileManager.getInstance().addUri(uri);
        if (this.tempTask == null) {
            this.tempTask = new TempTask();
        }
        if (this.tempTask.finished) {
            this.tempTask.finished = false;
            this.tempTask.exit = false;
            ExecutorService executorService = Executors.newCachedThreadPool();
            Future future = executorService.submit(this.tempTask);
        }
        return contentNode;
    }

    class InnerDragAndDropHelper
    extends FxDragAndDropHelper {
        @Override
        protected void cathFileList(List<File> fileList) {
            int i = 0;
            while (i < fileList.size()) {
                File file = fileList.get(i);
                BcLogUtil.debug("file=" + file.getPath());
                try {
                    URI uri = file.toURI();
                    FxxMultiTouchViewPane.this.addUri(uri);
                    FxxMediaPane mediaNode = FxxMouseEventUtil.createMediaNode(uri);
                    FxxContentNode contentNode = new FxxContentNode();
                    contentNode.setCenter((Node)mediaNode);
                    FxxMultiTouchViewPane.this.addContentNode(contentNode);
                }
                catch (Exception ex) {
                    FxxMultiTouchViewPane.this.handleException(ex);
                }
                ++i;
            }
        }
    }

    class TempTask
    extends TskAbstractCallable {
        boolean exit;
        boolean finished = true;

        protected Object taskProcess() throws Exception {
            URI uri;
            while (!this.exit && (uri = FxxFileManager.getInstance().pollUri()) != null) {
                final FxxContentNode contentNode = (FxxContentNode)FxxMultiTouchViewPane.this.uriMap.get(uri.toString());
                FxPlatform.runLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Image image = FxxFileManager.getInstance().getImage(uri);
                            Node node = FxxMouseEventUtil.createNode(uri, image);
                            contentNode.setCenter(node);
                        }
                        catch (Exception ex) {
                            TempTask.this.handleException(ex);
                        }
                    }
                });
            }
            this.finished = true;
            return null;
        }
    }
}

