/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config.plugins.processor;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Map;
import java.util.TreeMap;
import org.apache.logging.log4j.core.config.plugins.processor.PluginEntry;
import org.apache.logging.log4j.util.Strings;

public class PluginCache {
    private final Map<String, Map<String, PluginEntry>> categories = new TreeMap<String, Map<String, PluginEntry>>();

    public Map<String, Map<String, PluginEntry>> getAllCategories() {
        return this.categories;
    }

    public Map<String, PluginEntry> getCategory(String category) {
        String key = Strings.toRootLowerCase(category);
        return this.categories.computeIfAbsent(key, ignored -> new TreeMap());
    }

    public void writeCache(OutputStream os) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (DataOutputStream out = new DataOutputStream(new BufferedOutputStream(os));){
            out.writeInt(this.categories.size());
            for (Map.Entry<String, Map<String, PluginEntry>> category : this.categories.entrySet()) {
                out.writeUTF(category.getKey());
                Map<String, PluginEntry> m = category.getValue();
                out.writeInt(m.size());
                for (Map.Entry<String, PluginEntry> entry : m.entrySet()) {
                    PluginEntry plugin = entry.getValue();
                    out.writeUTF(plugin.getKey());
                    out.writeUTF(plugin.getClassName());
                    out.writeUTF(plugin.getName());
                    out.writeBoolean(plugin.isPrintable());
                    out.writeBoolean(plugin.isDefer());
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void loadCacheFiles(Enumeration<URL> resources) throws IOException {
        this.categories.clear();
        while (resources.hasMoreElements()) {
            URL url = resources.nextElement();
            Throwable throwable = null;
            Object var4_5 = null;
            try (DataInputStream in = new DataInputStream(new BufferedInputStream(url.openStream()));){
                int count = in.readInt();
                int i = 0;
                while (i < count) {
                    String category = in.readUTF();
                    Map<String, PluginEntry> m = this.getCategory(category);
                    int entries = in.readInt();
                    int j = 0;
                    while (j < entries) {
                        String key = in.readUTF();
                        String className = in.readUTF();
                        String name = in.readUTF();
                        boolean printable = in.readBoolean();
                        boolean defer = in.readBoolean();
                        m.computeIfAbsent(key, k -> {
                            PluginEntry entry = new PluginEntry();
                            entry.setKey((String)k);
                            entry.setClassName(className);
                            entry.setName(name);
                            entry.setPrintable(printable);
                            entry.setDefer(defer);
                            entry.setCategory(category);
                            return entry;
                        });
                        ++j;
                    }
                    ++i;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    public int size() {
        return this.categories.size();
    }
}

