/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataInput;
import java.io.IOException;
import java.util.Objects;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.ClassFormatException;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.classfile.ExceptionTable;
import org.apache.bcel.classfile.FieldOrMethod;
import org.apache.bcel.classfile.LineNumberTable;
import org.apache.bcel.classfile.LocalVariableTable;
import org.apache.bcel.classfile.ParameterAnnotationEntry;
import org.apache.bcel.classfile.Utility;
import org.apache.bcel.classfile.Visitor;
import org.apache.bcel.generic.Type;
import org.apache.bcel.util.BCELComparator;

public final class Method
extends FieldOrMethod {
    private static BCELComparator bcelComparator = new BCELComparator(){

        @Override
        public boolean equals(Object o1, Object o2) {
            Method THIS = (Method)o1;
            Method THAT = (Method)o2;
            return Objects.equals(THIS.getName(), THAT.getName()) && Objects.equals(THIS.getSignature(), THAT.getSignature());
        }

        @Override
        public int hashCode(Object o) {
            Method THIS = (Method)o;
            return THIS.getSignature().hashCode() ^ THIS.getName().hashCode();
        }
    };
    private ParameterAnnotationEntry[] parameterAnnotationEntries;

    public Method() {
    }

    public Method(Method c) {
        super(c);
    }

    Method(DataInput file, ConstantPool constant_pool) throws IOException, ClassFormatException {
        super(file, constant_pool);
    }

    public Method(int access_flags, int name_index, int signature_index, Attribute[] attributes, ConstantPool constant_pool) {
        super(access_flags, name_index, signature_index, attributes, constant_pool);
    }

    @Override
    public void accept(Visitor v) {
        v.visitMethod(this);
    }

    public Code getCode() {
        Attribute[] attributeArray = super.getAttributes();
        int n = attributeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Attribute attribute = attributeArray[n2];
            if (attribute instanceof Code) {
                return (Code)attribute;
            }
            ++n2;
        }
        return null;
    }

    public ExceptionTable getExceptionTable() {
        Attribute[] attributeArray = super.getAttributes();
        int n = attributeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Attribute attribute = attributeArray[n2];
            if (attribute instanceof ExceptionTable) {
                return (ExceptionTable)attribute;
            }
            ++n2;
        }
        return null;
    }

    public LocalVariableTable getLocalVariableTable() {
        Code code = this.getCode();
        if (code == null) {
            return null;
        }
        return code.getLocalVariableTable();
    }

    public LineNumberTable getLineNumberTable() {
        Code code = this.getCode();
        if (code == null) {
            return null;
        }
        return code.getLineNumberTable();
    }

    public String toString() {
        String str;
        String access = Utility.accessToString(super.getAccessFlags());
        ConstantUtf8 c = (ConstantUtf8)super.getConstantPool().getConstant(super.getSignatureIndex(), (byte)1);
        String signature = c.getBytes();
        c = (ConstantUtf8)super.getConstantPool().getConstant(super.getNameIndex(), (byte)1);
        String name = c.getBytes();
        signature = Utility.methodSignatureToString(signature, name, access, true, this.getLocalVariableTable());
        StringBuilder buf = new StringBuilder(signature);
        Attribute[] attributeArray = super.getAttributes();
        int n = attributeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Attribute attribute = attributeArray[n2];
            if (!(attribute instanceof Code) && !(attribute instanceof ExceptionTable)) {
                buf.append(" [").append(attribute).append("]");
            }
            ++n2;
        }
        ExceptionTable e = this.getExceptionTable();
        if (e != null && !(str = e.toString()).isEmpty()) {
            buf.append("\n\t\tthrows ").append(str);
        }
        return buf.toString();
    }

    public Method copy(ConstantPool _constant_pool) {
        return (Method)this.copy_(_constant_pool);
    }

    public Type getReturnType() {
        return Type.getReturnType(this.getSignature());
    }

    public Type[] getArgumentTypes() {
        return Type.getArgumentTypes(this.getSignature());
    }

    public static BCELComparator getComparator() {
        return bcelComparator;
    }

    public static void setComparator(BCELComparator comparator) {
        bcelComparator = comparator;
    }

    public boolean equals(Object obj) {
        return bcelComparator.equals(this, obj);
    }

    public int hashCode() {
        return bcelComparator.hashCode(this);
    }

    public ParameterAnnotationEntry[] getParameterAnnotationEntries() {
        if (this.parameterAnnotationEntries == null) {
            this.parameterAnnotationEntries = ParameterAnnotationEntry.createParameterAnnotationEntries(this.getAttributes());
        }
        return this.parameterAnnotationEntries;
    }
}

