/*
 * Decompiled with CFR 0.152.
 */
package ext.scf5.swg;

import ext.base.core.BcStringUtil;
import ext.base.mmd.MmdField;
import ext.lib.swg.SwgBorderPanel;
import ext.lib.swg.SwgComponentUnit;
import ext.lib.swg.SwgFormLayout;
import ext.lib.swg.SwgLabel;
import ext.lib.swg.SwgTextField;
import ext.lib.swg.SwgUtil;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;

public class IswgRowDetailPanel
extends SwgBorderPanel {
    private static final long serialVersionUID = -9144609351871314156L;
    protected List<MmdField> mmdFieldList;
    protected List<JComponent> componentList = new ArrayList<JComponent>();
    protected SwgFormLayout formLayout = new SwgFormLayout();

    public IswgRowDetailPanel() throws Exception {
        this.centerPanel.setLayout(this.formLayout);
    }

    public void setMmdFieldList(List<MmdField> mmdFieldList) throws Exception {
        this.mmdFieldList = mmdFieldList;
        this.componentList.clear();
        this.formLayout.componentUnitList.clear();
        int i = 0;
        while (i < mmdFieldList.size()) {
            MmdField mmdField = mmdFieldList.get(i);
            SwgLabel label = new SwgLabel();
            label.setText(mmdField.tableColumnName);
            SwgTextField textField = new SwgTextField();
            int prefColumnCount = mmdField.dataSize;
            if (prefColumnCount <= 0) {
                prefColumnCount = 20;
            }
            if (prefColumnCount > 200) {
                prefColumnCount = 200;
            }
            textField.setPreferredSize(SwgUtil.getTextFieldSize(this.getFont(), prefColumnCount));
            textField.setEditable(false);
            SwgComponentUnit controlUnit = new SwgComponentUnit((Component)label, textField);
            this.formLayout.componentUnitList.add(controlUnit);
            this.componentList.add(textField);
            ++i;
        }
        this.centerPanel.doLayout();
        this.centerPanel.repaint();
    }

    public void setRow(List<Object> row) throws Exception {
        int i = 0;
        while (i < this.mmdFieldList.size()) {
            MmdField mmdField = this.mmdFieldList.get(i);
            SwgTextField textField = (SwgTextField)this.componentList.get(i);
            Object value = row.get(i);
            String str = BcStringUtil.toString(value);
            textField.setText(BcStringUtil.toString(value));
            ++i;
        }
    }
}

