/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xfil.swg;

import ext.base.core.BcStringUtil;
import ext.base.log.BcLogUtil;
import ext.base.table.BcTableModel;
import ext.base.util.BcCollectionUtil;
import ext.base.util.BcCsvUtil;
import ext.lib.awt.AwtImageUtil;
import ext.lib.swg.SwgImagePanel;
import ext.lib.swg.SwgTableCellRenderer;
import ext.module.xfil.common.XfilUtil;
import ext.module.xfil.swg.XfilImagePanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellRenderer;

class XfilTableCellRendererThumbnail
extends SwgTableCellRenderer
implements TableCellRenderer,
Serializable {
    int columnId_entityId;
    Map<Long, Component> componentMap = new HashMap<Long, Component>();

    public XfilTableCellRendererThumbnail(int columnId_entityId) throws Exception {
        this.columnId_entityId = columnId_entityId;
    }

    @Override
    public Component getTableCellRendererComponent(JTable tableView, Object value, boolean isSelected, boolean hasFocus, int rowId, int columnId) {
        Component component = null;
        try {
            component = this.getComponent(tableView, value, isSelected, hasFocus, rowId, columnId);
            if (component != null) {
                this.setColor(tableView, isSelected, hasFocus, rowId, columnId, component);
            }
        }
        catch (Exception ex) {
            BcLogUtil.error(ex);
        }
        return component;
    }

    protected Component getComponent(JTable tableView, Object value, boolean isSelected, boolean hasFocus, int rowId, int columnId) throws Exception {
        BcTableModel tableModel = (BcTableModel)tableView.getModel();
        long entityId = (Long)tableView.getValueAt(rowId, this.columnId_entityId);
        Component component = this.componentMap.get(entityId);
        if (component == null) {
            component = this.createComponent(value, entityId);
            this.componentMap.put(entityId, component);
        }
        return component;
    }

    protected Component createComponent(Object value, long entityId) throws Exception {
        JPanel component = null;
        String csv = (String)value;
        List<BufferedImage> bufferedImageList = this.createBufferedImageIlist(csv, entityId);
        if (BcCollectionUtil.isEmpty(bufferedImageList)) {
            return component;
        }
        ArrayList<XfilImagePanel> ImagePanelList = new ArrayList<XfilImagePanel>();
        int i = 0;
        while (i < bufferedImageList.size()) {
            BufferedImage bufferedImage = bufferedImageList.get(i);
            XfilImagePanel imagePanel = new XfilImagePanel();
            imagePanel.setKeepRatio(true);
            imagePanel.setScaling(true);
            imagePanel.setImage(bufferedImage);
            imagePanel.setPreferredSize(new Dimension(240, 20));
            ImagePanelList.add(imagePanel);
            ++i;
        }
        JPanel panel = new JPanel();
        GridLayout gridLayout = new GridLayout();
        gridLayout.setHgap(1);
        gridLayout.setVgap(1);
        gridLayout.setColumns(5);
        panel.setLayout(gridLayout);
        int i2 = 0;
        while (i2 < ImagePanelList.size()) {
            SwgImagePanel imagePanel = (SwgImagePanel)ImagePanelList.get(i2);
            panel.add(imagePanel);
            ++i2;
        }
        component = panel;
        return component;
    }

    protected List<BufferedImage> createBufferedImageIlist(String csv, long entityId) throws Exception {
        ArrayList<BufferedImage> bufferedImageList = null;
        if (BcStringUtil.isEmpty(csv)) {
            return bufferedImageList;
        }
        List<String> fileNameList = BcCsvUtil.parseCsvRow(csv, true);
        File dir = XfilUtil.getTthumbnailsDir(entityId);
        bufferedImageList = new ArrayList<BufferedImage>();
        int i = 0;
        while (i < fileNameList.size()) {
            BufferedImage bufferedImage;
            String fileName = fileNameList.get(i);
            File file = new File(dir, fileName);
            if (file.exists() && (bufferedImage = AwtImageUtil.loadImage(file)) != null) {
                bufferedImageList.add(bufferedImage);
            }
            ++i;
        }
        return bufferedImageList;
    }

    protected Object[] getImage(JTable tableView, int rowId, Point point, Rectangle cellRectangle) throws Exception {
        long entityId = (Long)tableView.getValueAt(rowId, this.columnId_entityId);
        Component component1 = this.componentMap.get(entityId);
        if (component1 == null) {
            return null;
        }
        Container container = (Container)component1;
        Point point1 = new Point();
        point1.x = point.x - cellRectangle.x;
        point1.y = point.y - cellRectangle.y;
        Component component3 = null;
        int i = 0;
        while (i < container.getComponentCount()) {
            Component component2 = container.getComponent(i);
            Rectangle rectangle2 = component2.getBounds();
            if (rectangle2.contains(point1)) {
                component3 = component2;
            }
            ++i;
        }
        BufferedImage bufferedImage = null;
        Rectangle rectangle2 = null;
        if (component3 != null) {
            SwgImagePanel imagePanel = (SwgImagePanel)component3;
            bufferedImage = (BufferedImage)imagePanel.getImage();
            Point pointWk = new Point();
            pointWk.x = cellRectangle.x + imagePanel.getX();
            pointWk.y = cellRectangle.y + imagePanel.getY();
            SwingUtilities.convertPointToScreen(pointWk, tableView);
            rectangle2 = new Rectangle(pointWk.x, pointWk.y, imagePanel.getWidth(), imagePanel.getHeight());
        }
        Object[] res = new Object[]{bufferedImage, rectangle2};
        return res;
    }
}

