/*
 * Decompiled with CFR 0.152.
 */
package ext.module.wcam.fx;

import com.github.sarxos.webcam.Webcam;
import ext.base.log.BcLogUtil;
import ext.lib.fx.layout.FxBorderPane;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Task;
import javafx.embed.swing.SwingFXUtils;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.WritableImage;
import javafx.scene.layout.Pane;

public class WcamCameraPane
extends FxBorderPane {
    Pane pane = new Pane();
    ImageView imageView = new ImageView();
    Webcam webCam;
    BufferedImage bufferedImage1;
    BufferedImage bufferedImageRev;
    Dimension cameraSize;
    ObjectProperty<Image> imageProperty = new SimpleObjectProperty();
    private boolean stopCamera = false;
    Canvas canvas = new Canvas(176.0, 144.0);

    public WcamCameraPane() {
        this.pane.getChildren().addAll((Object[])new Node[]{this.imageView});
        this.imageView.fitWidthProperty().bind((ObservableValue)this.pane.widthProperty());
        this.imageView.fitHeightProperty().bind((ObservableValue)this.pane.heightProperty());
        this.setCenter((Node)this.pane);
        this.initCamera();
    }

    void initCamera() {
        List webcomList = Webcam.getWebcams();
        BcLogUtil.debug("webcomList.size()=" + webcomList.size());
        for (Webcam webcam : webcomList) {
            System.out.println(webcam.getName());
        }
        this.webCam = (Webcam)webcomList.get(1);
        this.webCam.open();
        this.cameraSize = this.webCam.getViewSize();
        BcLogUtil.debug("cameraSize.getWidth()=" + this.cameraSize.getWidth() + " cameraSize.getHeight()=" + this.cameraSize.getHeight());
        double width = (int)this.cameraSize.getWidth() << 2;
        double height = (int)this.cameraSize.getHeight() << 2;
        System.out.printf("\u30b5\u30a4\u30ba\u30ab\u30e1\u30e9:(%d,%d)\n", this.cameraSize.width, this.cameraSize.height);
        this.startWebCamStream();
        this.imageView.setOnMouseMoved(e -> {
            int x = (int)e.getX();
            int y = (int)e.getY();
            int color = this.bufferedImageRev.getRGB(x >> 2, y >> 2);
            String string = String.format("(%3d,%3d)\u8272#%07X", x, y, color & 0xFFFFFF);
        });
    }

    protected void startWebCamStream() {
        this.stopCamera = false;
        Task<Void> task = new Task<Void>(){

            protected Void call() throws Exception {
                final AtomicReference<WritableImage> atomicReference = new AtomicReference<WritableImage>();
                while (!WcamCameraPane.this.stopCamera) {
                    try {
                        WcamCameraPane.this.bufferedImage1 = WcamCameraPane.this.webCam.getImage();
                        if (WcamCameraPane.this.bufferedImage1 == null) continue;
                        WcamCameraPane.this.bufferedImageRev = WcamCameraPane.createMirrorImage(WcamCameraPane.this.bufferedImage1);
                        atomicReference.set(SwingFXUtils.toFXImage((BufferedImage)WcamCameraPane.this.bufferedImageRev, (WritableImage)((WritableImage)atomicReference.get())));
                        WcamCameraPane.this.bufferedImage1.flush();
                        Platform.runLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                (this).WcamCameraPane.this.imageProperty.set((Object)((Image)atomicReference.get()));
                                GraphicsContext gc = (this).WcamCameraPane.this.canvas.getGraphicsContext2D();
                                gc.drawImage((Image)SwingFXUtils.toFXImage((BufferedImage)(this).WcamCameraPane.this.bufferedImage1, null), 0.0, 0.0);
                            }
                        });
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                return null;
            }
        };
        Thread th = new Thread((Runnable)task);
        th.setDaemon(true);
        th.start();
        this.imageView.imageProperty().bind(this.imageProperty);
    }

    public static BufferedImage createMirrorImage(BufferedImage img) {
        int width = img.getWidth();
        int height = img.getHeight();
        int size = width * height;
        int[] buf = new int[size];
        img.getRGB(0, 0, width, height, buf, 0, width);
        int y = 0;
        while (y < size) {
            int x1 = 0;
            int x2 = width - 1;
            while (x1 < x2) {
                int temp = buf[y + x1];
                buf[y + x1++] = buf[y + x2];
                buf[y + x2--] = temp;
            }
            y += width;
        }
        BufferedImage img2 = new BufferedImage(width, height, 6);
        img2.setRGB(0, 0, width, height, buf, 0, width);
        return img2;
    }
}

