/*
 * Decompiled with CFR 0.152.
 */
package ext.module.dcmn.swg;

import ext.base.core.BcStringUtil;
import ext.base.log.BcLogUtil;
import ext.base.thread.BcMonitor;
import ext.base.util.BcDataCheckUtil;
import ext.base.util.BcWords;
import ext.lib.awt.AwtImageHelper;
import ext.lib.swg.SwgButton;
import ext.lib.swg.SwgDecoratePanel;
import ext.lib.swg.SwgDialog;
import ext.lib.swg.SwgFileChooser;
import ext.lib.swg.SwgNumberField;
import ext.lib.swg.SwgTextField;
import ext.lib.swg.SwgUtil;
import ext.module.dcmn.model.DcmnDocumentTemplate;
import ext.module.dcmn.stub.DcmnDocumentTemplateStub;
import ext.scf.client.ScfClientContainer;
import ext.scf2.client.ScfFileUploader;
import ext.scf2.stub.ScfFileStub;
import ext.scf5.model.ScfFileResource;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JOptionPane;

public class DcmnDocumentTemplatePanel
extends SwgDecoratePanel {
    private static final long serialVersionUID = -8995553747733834894L;
    protected SwgNumberField idField = new SwgNumberField(-1, 0, false, "-1");
    protected SwgTextField codeField = new SwgTextField();
    protected SwgTextField nameField = new SwgTextField();
    protected SwgNumberField classIdField = new SwgNumberField(-1, 0, false, "-1");
    protected SwgNumberField displayNoField = new SwgNumberField(-1, 0, false, "-1");
    protected SwgTextField noteField = new SwgTextField();
    protected SwgNumberField fileResourceIdField = new SwgNumberField(-1, 0, false, "-1");
    protected SwgTextField fileResourceNameField = new SwgTextField();
    protected SwgTextField defFilePathField = new SwgTextField();
    protected SwgButton defFileBrowsButton = new SwgButton("\u53c2\u7167");
    protected SwgFileChooser fileChooser = new SwgFileChooser();
    protected ScfFileUploader fileUploader;
    protected DcmnDocumentTemplate documentTemplate;
    protected boolean resBool;
    protected Window window;
    protected Component thisComp;

    public DcmnDocumentTemplatePanel() throws Exception {
        this.setBorderSize(20, 32, 8, 8);
        this.thisComp = this;
        this.defFileBrowsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                DcmnDocumentTemplatePanel.this.fileChooser.resetChoosableFileFilters();
                if (!BcStringUtil.isEmpty(DcmnDocumentTemplatePanel.this.defFilePathField.getText())) {
                    DcmnDocumentTemplatePanel.this.fileChooser.setSelectedFile(new File(DcmnDocumentTemplatePanel.this.defFilePathField.getText()));
                }
                switch (DcmnDocumentTemplatePanel.this.fileChooser.showDialog(DcmnDocumentTemplatePanel.this.thisComp, BcWords.getInstance().select)) {
                    case 0: {
                        DcmnDocumentTemplatePanel.this.defFilePathField.setText(DcmnDocumentTemplatePanel.this.fileChooser.getSelectedFile().getPath());
                        break;
                    }
                }
            }
        });
        this.setLine();
        this.setOkButton(BcWords.getInstance().completion);
        this.setCancelButton(BcWords.getInstance().cancel);
        this.idField.setEditable(false);
        this.fileResourceIdField.setEditable(false);
        this.fileResourceNameField.setEditable(false);
        this.fileUploader = new ScfFileUploader(ScfClientContainer.getInstance().getAgent());
        this.initComponent();
    }

    protected void initComponent() {
        int rowHeight = SwgUtil.getTextFieldHeight(this.getFont(), null);
        int rowGap = SwgUtil.getRowDiff(this.getFont());
        int colGap = SwgUtil.getColDiff(this.getFont());
        int c1x = 0;
        int c1w = 80;
        int c2x = c1x + c1w + colGap;
        int ly = rowHeight;
        SwgUtil.setLocation(this.centerPanel, new JLabel("ID", 4), (double)c1x, (double)ly, (double)c1w, (double)rowHeight);
        SwgUtil.setLocation(this.centerPanel, this.idField, (double)c2x, (double)ly, 60.0, (double)rowHeight);
        SwgUtil.setLocation(this.centerPanel, new JLabel("\u30b3\u30fc\u30c9", 4), (double)c1x, (double)(ly += rowHeight + rowGap), (double)c1w, (double)rowHeight);
        SwgUtil.setLocation(this.centerPanel, this.codeField, (double)c2x, (double)ly, 120.0, (double)rowHeight);
        SwgUtil.setLocation(this.centerPanel, new JLabel("\u540d\u79f0", 4), (double)c1x, (double)(ly += rowHeight + rowGap), (double)c1w, (double)rowHeight);
        SwgUtil.setLocation(this.centerPanel, this.nameField, (double)c2x, (double)ly, 400.0, (double)rowHeight);
        SwgUtil.setLocation(this.centerPanel, new JLabel("\u533a\u5206ID", 4), (double)c1x, (double)(ly += rowHeight + rowGap), (double)c1w, (double)rowHeight);
        SwgUtil.setLocation(this.centerPanel, this.classIdField, (double)c2x, (double)ly, 60.0, (double)rowHeight);
        SwgUtil.setLocation(this.centerPanel, new JLabel("\u8868\u793a\uff2e\uff4f.", 4), (double)c1x, (double)(ly += rowHeight + rowGap), (double)c1w, (double)rowHeight);
        SwgUtil.setLocation(this.centerPanel, this.displayNoField, (double)c2x, (double)ly, 60.0, (double)rowHeight);
        SwgUtil.setLocation(this.centerPanel, new JLabel("\u5099\u8003", 4), (double)c1x, (double)(ly += rowHeight + rowGap), (double)c1w, (double)rowHeight);
        SwgUtil.setLocation(this.centerPanel, this.noteField, (double)c2x, (double)ly, 300.0, (double)rowHeight);
        ly += rowHeight + rowGap;
        SwgUtil.setLocation(this.centerPanel, new JLabel("\u30ea\u30bd\u30fc\u30b9ID", 4), (double)c1x, (double)(ly += rowHeight + rowGap), (double)c1w, (double)rowHeight);
        SwgUtil.setLocation(this.centerPanel, this.fileResourceIdField, (double)c2x, (double)ly, 60.0, (double)rowHeight);
        SwgUtil.setLocation(this.centerPanel, new JLabel("\u30ea\u30bd\u30fc\u30b9\u540d", 4), (double)c1x, (double)(ly += rowHeight + rowGap), (double)c1w, (double)rowHeight);
        SwgUtil.setLocation(this.centerPanel, this.fileResourceNameField, (double)c2x, (double)ly, 400.0, (double)rowHeight);
        SwgUtil.setLocation(this.centerPanel, new JLabel(BcWords.getInstance().file, 4), (double)c1x, (double)(ly += rowHeight + rowGap), (double)c1w, (double)rowHeight);
        SwgUtil.setLocation(this.centerPanel, this.defFilePathField, (double)c2x, (double)ly, 500.0, (double)rowHeight);
        SwgUtil.setLocation(this.centerPanel, this.defFileBrowsButton, (double)(c2x + 500), (double)ly, -1.0, (double)rowHeight);
        ly += rowHeight + rowGap;
    }

    protected void setDataId(int templeteId) throws Exception {
        this.resBool = false;
        if (templeteId <= 0) {
            this.documentTemplate = new DcmnDocumentTemplate();
            this.idField.setText(Integer.toString(this.documentTemplate.getDataId()));
        } else {
            this.documentTemplate = DcmnDocumentTemplateStub.getInstance().getTemplate(templeteId);
            this.idField.setText(Integer.toString(this.documentTemplate.getDataId()));
            this.codeField.setText(this.documentTemplate.code);
            this.nameField.setText(this.documentTemplate.name);
            this.noteField.setText(this.documentTemplate.note);
            ScfFileResource fileResource = DcmnDocumentTemplateStub.getInstance().getFileResource(this.documentTemplate.fileResourceId);
            this.fileResourceIdField.setText(Integer.toString(fileResource.getDataId()));
            this.fileResourceNameField.setText(fileResource.fileName);
        }
    }

    @Override
    protected void okButtonAction() throws Exception {
        ArrayList<String> msgList = new ArrayList<String>();
        BcDataCheckUtil.textNotNullable(this.codeField.getText(), "\u30b3\u30fc\u30c9", msgList);
        BcDataCheckUtil.textNotNullable(this.nameField.getText(), "\u540d\u79f0", msgList);
        File defFile = null;
        if (!BcStringUtil.isEmpty(this.defFilePathField.getText()) && !(defFile = new File(this.defFilePathField.getText())).exists()) {
            msgList.add("\u30d5\u30a1\u30a4\u30eb\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002");
        }
        if (msgList.size() > 0) {
            JOptionPane.showMessageDialog(this, SwgUtil.createMessageComponent(null, msgList), BcWords.getInstance().warning, 2);
            return;
        }
        if (defFile != null) {
            String svDirPath = ScfFileStub.getInstance().getTemporaryDirPath();
            BcMonitor mon = new BcMonitor();
            this.fileUploader.upload(defFile, svDirPath, mon, null);
            mon.sync();
        }
        this.documentTemplate.code = this.codeField.getText();
        this.documentTemplate.name = this.nameField.getText();
        this.documentTemplate.note = this.noteField.getText();
        if (defFile != null) {
            DcmnDocumentTemplateStub.getInstance().putDocumentTemplate(this.documentTemplate, defFile.getName());
        } else {
            DcmnDocumentTemplateStub.getInstance().putDocumentTemplate(this.documentTemplate, null);
        }
        this.resBool = true;
        this.close();
    }

    @Override
    protected void cancelButtonAction() throws Exception {
        this.documentTemplate = null;
        this.close();
    }

    @Override
    public void close() {
        this.window.dispose();
    }

    public boolean showAsDialog(int templeteId, Component ownerCompo) throws Exception {
        this.setDataId(templeteId);
        SwgDialog dialog = SwgUtil.createDialog(ownerCompo);
        dialog.getContentPane().add((Component)this, "Center");
        dialog.setModal(true);
        dialog.setResizable(false);
        dialog.setDefaultCloseOperation(0);
        dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent ev) {
                try {
                    DcmnDocumentTemplatePanel.this.cancelButtonAction();
                }
                catch (Exception ex) {
                    BcLogUtil.error(ex);
                }
            }
        });
        dialog.setTitle(BcWords.getInstance().template);
        dialog.setIconImage(AwtImageHelper.getWindowIconImage());
        this.window = dialog;
        SwgUtil.setCenter(this.window, 720.0, 400.0);
        this.window.setVisible(true);
        return this.resBool;
    }
}

