/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.swg;

import ext.base.runtime.BcRuntimeUtil;
import java.awt.event.FocusEvent;
import java.awt.im.InputSubset;
import javax.swing.text.JTextComponent;

public class SwgInputContextHelper {
    protected JTextComponent jTextComponent;
    protected BcRuntimeUtil.OsType osType;
    protected int imeMode = -1;
    protected boolean preCompositionEnabled;

    public SwgInputContextHelper(JTextComponent jTextComponent) {
        this.jTextComponent = jTextComponent;
        this.osType = BcRuntimeUtil.getOsType();
    }

    public void setImeMode(int imeMode) {
        this.imeMode = imeMode;
        if (this.jTextComponent.getInputContext() == null) {
            return;
        }
        switch (imeMode) {
            case 1: {
                if (this.osType != BcRuntimeUtil.OsType.Windows) break;
                this.jTextComponent.getInputContext().setCompositionEnabled(false);
                break;
            }
            case 2: {
                if (this.osType != BcRuntimeUtil.OsType.Windows) break;
                this.jTextComponent.getInputContext().setCharacterSubsets(new Character.Subset[]{InputSubset.KANJI});
            }
        }
    }

    public void focusEvent(FocusEvent ev) {
        if (this.jTextComponent.getInputContext() == null) {
            return;
        }
        switch (ev.getID()) {
            case 1004: {
                if (this.osType == BcRuntimeUtil.OsType.Windows) {
                    this.preCompositionEnabled = this.jTextComponent.getInputContext().isCompositionEnabled();
                }
                if (!this.jTextComponent.isEnabled() || !this.jTextComponent.isEditable()) break;
                this.setImeMode(this.imeMode);
                break;
            }
            case 1005: {
                if (this.osType != BcRuntimeUtil.OsType.Windows) break;
                this.jTextComponent.getInputContext().setCompositionEnabled(this.preCompositionEnabled);
            }
        }
    }
}

