/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.rmi.server;

import ext.base.log.BcLoggableObject;
import ext.base.reflect.BcReflectUtil;
import ext.lib.datasource.DtsSession;
import ext.lib.datasource.DtsSessionFactory;
import ext.lib.datasource.DtsSessionFactoryManegaer;
import ext.lib.rmi.agent.RmiAgent;
import ext.lib.rmi.common.RmiMethodContext;
import ext.lib.rmi.common.RmiRemoteObject;
import ext.lib.rmi.model.RmiRequest;
import ext.lib.rmi.model.RmiRespons;
import ext.lib.rmi.model.RmiRmoArgument;
import ext.lib.rmi.server.RmiAgentEventHandler;
import ext.lib.rmi.util.RmiObjectPoolManager;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RmiRmoInvoker
extends BcLoggableObject {
    protected Map<String, RmiMethodContext> aliasMap = new HashMap<String, RmiMethodContext>();
    protected List<RmiAgentEventHandler> agentEventHandlerList;

    public void setAgentEventHandlerList(List<RmiAgentEventHandler> agentEventHandlerList) {
        this.agentEventHandlerList = agentEventHandlerList;
    }

    public RmiRespons executeRequest(RmiAgent rmixAgent, RmiRequest rmiReq) {
        RmiRespons rmiRes = null;
        try {
            rmiRes = this.executeRequest2(rmixAgent, rmiReq);
        }
        catch (Exception ex) {
            this.getLogger().error(ex);
            rmiRes = new RmiRespons();
            rmiRes.setRequestId(rmiReq.getId());
            rmiRes.setStatusId(-9);
            rmiRes.setException(ex);
        }
        return rmiRes;
    }

    protected RmiRespons executeRequest2(RmiAgent rmixAgent, RmiRequest rmiReq) throws Exception {
        RmiRmoArgument rmoArg;
        block22: {
            rmixAgent.getContext().lastHertBeatTime = System.currentTimeMillis();
            rmoArg = new RmiRmoArgument();
            rmoArg.setAgent(rmixAgent);
            rmiReq.setDataIndex(-1);
            rmoArg.setRequest(rmiReq);
            if (rmiReq.getPacketType() == 11) {
                RmiRespons rmiRes = new RmiRespons();
                rmiRes.setRequestId(rmiReq.getId());
                rmiRes.setStatusId(1);
                rmoArg.setRespons(rmiRes);
            }
            try {
                String className = rmiReq.getClassName();
                String methodName = rmiReq.getMethodName();
                if (className == null) {
                    RmiMethodContext methodContext = this.getMethodContext(methodName);
                    if (methodContext != null) {
                        className = methodContext.className;
                        methodName = methodContext.methodName;
                    } else {
                        throw new Exception("notfound methodContext:methodName='" + methodName + "'");
                    }
                }
                Object[] methodParams = null;
                methodParams = rmiReq.getMethodParameter() != null ? rmiReq.getMethodParameter() : new Object[]{rmoArg};
                int i = 0;
                while (i < methodParams.length) {
                    if (DtsSession.class.isAssignableFrom(methodParams[i].getClass())) {
                        methodParams[i] = rmoArg.getDtsSession(this);
                    }
                    ++i;
                }
                Class[] methodParamTypes = null;
                if (rmiReq.getMethodParamTypes() != null) {
                    methodParamTypes = rmiReq.getMethodParamTypes();
                } else {
                    methodParamTypes = new Class[methodParams.length];
                    int i2 = 0;
                    while (i2 < methodParams.length) {
                        methodParamTypes[i2] = methodParams[i2].getClass();
                        ++i2;
                    }
                }
                Class<?> clazz = Class.forName(className);
                if (clazz == null) {
                    throw new ClassNotFoundException(className);
                }
                Method method = BcReflectUtil.getMethod(clazz, methodName, methodParamTypes);
                if (method == null) {
                    throw new NoSuchMethodException(String.valueOf(className) + "." + methodName);
                }
                DtsSessionFactory dtsSessionFactory = DtsSessionFactoryManegaer.getInstance().getSessionFactoryMain();
                rmoArg.setSessionFactory(dtsSessionFactory);
                Object targetObj = null;
                if (!Modifier.isStatic(method.getModifiers()) && (targetObj = RmiObjectPoolManager.getInstance().getObject(className)) == null) {
                    RmiRemoteObject remoteObject;
                    targetObj = BcReflectUtil.getInstance(clazz);
                    if (RmiRemoteObject.class.isAssignableFrom(clazz) && (remoteObject = (RmiRemoteObject)targetObj).objectPoolEnabled()) {
                        RmiObjectPoolManager.getInstance().addObject(className, targetObj);
                    }
                }
                Object respons = method.invoke(targetObj, methodParams);
                if (!method.getGenericReturnType().equals(Void.TYPE)) {
                    rmoArg.getRespons().addData(respons);
                }
                rmoArg.commit();
            }
            catch (InvocationTargetException ex) {
                this.getLogger().error(ex);
                rmoArg.rollback();
                this.setThrowable(rmoArg, ex.getCause());
                rmoArg.desturuct();
                break block22;
            }
            catch (Exception ex) {
                try {
                    this.getLogger().error(ex);
                    this.setThrowable(rmoArg, ex);
                    break block22;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    rmoArg.desturuct();
                }
            }
            rmoArg.desturuct();
        }
        if (rmoArg.getRespons() != null) {
            rmoArg.getRespons().setDataIndex(-1);
        }
        return rmoArg.getRespons();
    }

    protected void setThrowable(RmiRmoArgument rmixArg, Throwable throwable) {
        RmiRespons respons = rmixArg.getRespons();
        respons.clear();
        respons.setRequestId(rmixArg.getRequest().getId());
        respons.setStatusId(-9);
        if (Exception.class.isAssignableFrom(throwable.getClass())) {
            Exception ex = (Exception)throwable;
            respons.setException(ex);
        } else {
            respons.setException(new Exception(throwable.getMessage()));
        }
        if (this.agentEventHandlerList != null) {
            RmiAgentEventHandler[] agentEventHandlers = this.agentEventHandlerList.toArray(new RmiAgentEventHandler[0]);
            int i = 0;
            while (i < agentEventHandlers.length) {
                RmiAgentEventHandler eventHandler = agentEventHandlers[i];
                try {
                    eventHandler.invokeException(rmixArg, throwable);
                }
                catch (Exception ex) {
                    this.getLogger().error(ex);
                }
                ++i;
            }
        }
    }

    public void addMethodContext(String alias, RmiMethodContext methodContext) {
        this.aliasMap.put(alias, methodContext);
    }

    public RmiMethodContext removeMethodContext(String alias) {
        return this.aliasMap.remove(alias);
    }

    public RmiMethodContext getMethodContext(String alias) {
        return this.aliasMap.get(alias);
    }
}

