/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.doc.util;

import ext.base.core.BcNumberUtil;
import ext.base.core.BcStringUtil;
import ext.base.io.BcFileUtil;
import ext.base.log.BcLogUtil;
import ext.base.thread.BcMonitor;
import ext.base.util.BcUuidUtil;
import ext.base.xml.BcXmlUtil;
import ext.base.zip.BcZipUtil;
import ext.lib.doc.script.DcfScriptConstants;
import ext.lib.doc.script.DcfScriptGenerator;
import ext.lib.doc.script.DcfScriptParser;
import ext.lib.doc.util.DcfPageReader;
import ext.lib.doc.util.DcfPageWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import nlc.lib.doc.DcfBook;
import nlc.lib.doc.DcfPage;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;
import org.apache.tools.zip.ZipOutputStream;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DcfBookFile
implements DcfPageWriter,
DcfPageReader {
    protected BcMonitor monitor = new BcMonitor();
    public static final int MODE_init = -1;
    public static final int MODE_write = 1;
    public static final int MODE_read = 2;
    protected int mode = -1;
    protected String title;
    protected String author;
    protected int pageId;
    protected boolean isPageCash;
    protected int pageCashMax = 20;
    protected List<DcfPage> dcfPageList;
    protected File tempDirectory;
    protected File destDir;
    protected ZipFile zipFile;
    protected DcfScriptParser scriptParser = new DcfScriptParser();
    protected DcfScriptGenerator scriptGenerator = new DcfScriptGenerator();
    protected boolean isBgPageCash;
    protected int bgPageCashMax = 2;
    protected boolean bgPageEnabled;
    protected List<String> pagePathList;
    protected Map<String, DcfPage> bgPageMap;
    public static final String ZEP_page = "page";
    public static final String ZEP_bgPage = "bg_page";
    public static final int PAGE_NO_LENGTH = 8;
    public static final String ZEN_metaData = "metaData.xml";
    public static final String XTAG_metaData = "metaData";
    public static final String XTAG_title = "title";
    public static final String XTAG_author = "author";
    public static final String XTAG_pageIndex = "pageIndex";
    public static final String XTAG_pageNo = "pageNo";
    public static final String XTAG_zipEntry = "zipEntry";

    public DcfBookFile() throws Exception {
        this.dcfPageList = new ArrayList<DcfPage>();
        this.bgPageMap = new HashMap<String, DcfPage>();
    }

    @Override
    public String getTitle() throws Exception {
        return this.title;
    }

    @Override
    public void setTitle(String title) throws Exception {
        this.title = title;
    }

    @Override
    public String getAuthor() throws Exception {
        return this.author;
    }

    @Override
    public void setAuthor(String author) throws Exception {
        this.author = author;
    }

    public void setWriteMode(File tempDirectory) throws Exception {
        if (this.mode != -1) {
            throw new Exception("mode is " + this.mode);
        }
        this.mode = 1;
        this.tempDirectory = tempDirectory;
        this.isPageCash = true;
        this.pageId = 0;
    }

    public void setReadMode(File zip) throws Exception {
        if (this.mode != -1) {
            throw new Exception("mode is " + this.mode);
        }
        this.mode = 2;
        this.zipFile = new ZipFile(zip);
        this.isPageCash = false;
        this.pagePathList = new ArrayList<String>();
        this.parseMetaData();
    }

    @Override
    public int addPage(DcfPage dcfPage) throws Exception {
        int pageIndex = this.getPageCount();
        this.setPage(pageIndex, dcfPage);
        return pageIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPage(int pageIndex, DcfPage dcfPage) throws Exception {
        if (this.mode != 1) {
            throw new Exception("mode is " + this.mode);
        }
        BcMonitor bcMonitor = this.monitor;
        synchronized (bcMonitor) {
            if (this.isPageCash) {
                if (this.dcfPageList.size() < this.pageCashMax) {
                    if (pageIndex == this.dcfPageList.size()) {
                        this.dcfPageList.add(dcfPage);
                    } else {
                        this.dcfPageList.set(pageIndex, dcfPage);
                    }
                } else {
                    this.flush();
                    ++this.pageId;
                    File destFile = new File(this.destDir, this.toFileName(this.pageId));
                    BcLogUtil.debug("setPage:destFile=" + destFile.getPath());
                    StringBuilder script = this.scriptGenerator.toScript(dcfPage);
                    byte[] bytes = script.toString().getBytes(DcfScriptConstants.CHAR_SET);
                    BcFileUtil.save(destFile, bytes);
                    this.pagePathList.add(pageIndex, destFile.getPath());
                }
            } else {
                ++this.pageId;
                File destFile = new File(this.destDir, this.toFileName(this.pageId));
                BcLogUtil.debug("setPage:destFile=" + destFile.getPath());
                StringBuilder script = this.scriptGenerator.toScript(dcfPage);
                byte[] bytes = script.toString().getBytes(DcfScriptConstants.CHAR_SET);
                BcFileUtil.save(destFile, bytes);
                this.pagePathList.add(pageIndex, destFile.getPath());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void flush() throws Exception {
        BcMonitor bcMonitor = this.monitor;
        synchronized (bcMonitor) {
            UUID uuid = BcUuidUtil.createUUID();
            this.destDir = new File(this.tempDirectory, uuid.toString());
            if (this.destDir.exists()) {
                throw new Exception("directory is already exists:" + this.destDir.getPath());
            }
            if (!this.destDir.mkdirs()) {
                throw new Exception("can not create:" + this.destDir.getPath());
            }
            this.pagePathList = new ArrayList<String>();
            int i = 0;
            while (i < this.dcfPageList.size()) {
                ++this.pageId;
                DcfPage dcfPage2 = this.dcfPageList.get(i);
                File destFile = new File(this.destDir, this.toFileName(this.pageId));
                BcLogUtil.debug("flush:destFile=" + destFile.getPath());
                StringBuilder script = this.scriptGenerator.toScript(dcfPage2);
                byte[] bytes = script.toString().getBytes(DcfScriptConstants.CHAR_SET);
                BcFileUtil.save(destFile, bytes);
                this.pagePathList.add(this.pageId - 1, destFile.getPath());
                ++i;
            }
            this.isPageCash = false;
            this.dcfPageList.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePage(int pageIndex) throws Exception {
        BcMonitor bcMonitor = this.monitor;
        synchronized (bcMonitor) {
            if (this.isPageCash) {
                this.dcfPageList.remove(pageIndex);
            } else {
                String filePath = this.pagePathList.remove(pageIndex);
                File file = new File(filePath);
                if (!file.delete()) {
                    throw new Exception("dekete fhjhjj. " + file.getPath());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DcfPage getPage(int pageIndex) throws Exception {
        BcMonitor bcMonitor = this.monitor;
        synchronized (bcMonitor) {
            if (this.zipFile != null) {
                if (pageIndex < this.dcfPageList.size()) {
                    return this.dcfPageList.get(pageIndex);
                }
                String entryName = this.pagePathList.get(pageIndex);
                byte[] bytes = BcZipUtil.getAsByteArray(this.zipFile, entryName);
                String script = new String(bytes, DcfScriptConstants.CHAR_SET);
                DcfPage dcfPage = this.scriptParser.toPage(script);
                int gap = pageIndex - this.dcfPageList.size() + 1;
                int i = 0;
                while (i < gap) {
                    this.dcfPageList.add(null);
                    ++i;
                }
                this.dcfPageList.set(pageIndex, dcfPage);
                return dcfPage;
            }
            if (this.isPageCash) {
                return this.dcfPageList.get(pageIndex);
            }
            String filePath = this.pagePathList.get(pageIndex);
            File file = new File(filePath);
            byte[] bytes = BcFileUtil.read(file);
            DcfPage dcfPage = this.scriptParser.toPage(new String(bytes, DcfScriptConstants.CHAR_SET));
            return dcfPage;
        }
    }

    @Override
    public int getPageCount() {
        if (this.isPageCash) {
            return this.dcfPageList.size();
        }
        return this.pagePathList.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws Exception {
        BcMonitor bcMonitor = this.monitor;
        synchronized (bcMonitor) {
            if (this.mode == 1) {
                if (this.destDir != null) {
                    BcFileUtil.deleteFile(this.destDir);
                }
                this.mode = -1;
            } else if (this.mode == 2) {
                this.zipFile.close();
                this.zipFile = null;
                this.mode = -1;
            } else {
                throw new Exception("mode is " + this.mode);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DcfPage getPage(String entryName) throws Exception {
        BcMonitor bcMonitor = this.monitor;
        synchronized (bcMonitor) {
            byte[] bytes = BcZipUtil.getAsByteArray(this.zipFile, entryName);
            DcfPage dcfPage = this.scriptParser.toPage(new String(bytes, DcfScriptConstants.CHAR_SET));
            return dcfPage;
        }
    }

    public DcfBook toBook() throws Exception {
        DcfBook dcfBook = new DcfBook();
        int i = 0;
        while (i < this.getPageCount()) {
            dcfBook.addPage(this.getPage(i));
            ++i;
        }
        return dcfBook;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toZipFile(File zipFile) throws Exception {
        BcMonitor bcMonitor = this.monitor;
        synchronized (bcMonitor) {
            try (ZipOutputStream zipOs = new ZipOutputStream(new FileOutputStream(zipFile));){
                Document xmlDoc = BcXmlUtil.createDocument(XTAG_metaData, true);
                Element rootNode = xmlDoc.getDocumentElement();
                BcXmlUtil.addTextValue(rootNode, XTAG_title, this.title);
                BcXmlUtil.addTextValue(rootNode, XTAG_author, this.author);
                Element xmlElemL1 = xmlDoc.createElement(XTAG_pageIndex);
                rootNode.appendChild(xmlElemL1);
                if (this.isPageCash) {
                    this.flush();
                }
                int i = 0;
                while (i < this.pagePathList.size()) {
                    String filePath = this.pagePathList.get(i);
                    int pageNo = i + 1;
                    File file = new File(filePath);
                    byte[] bytes = BcFileUtil.read(file);
                    ZipEntry zipEntry = new ZipEntry(this.toZipEntryName(pageNo));
                    zipOs.putNextEntry(zipEntry);
                    zipOs.write(bytes);
                    Element xmlElemL2 = xmlDoc.createElement("index");
                    xmlElemL1.appendChild(xmlElemL2);
                    xmlElemL2.setAttribute(XTAG_pageNo, Integer.toString(pageNo));
                    xmlElemL2.setAttribute(XTAG_zipEntry, zipEntry.getName());
                    ++i;
                }
                ZipEntry zipEntry = new ZipEntry(ZEN_metaData);
                zipOs.putNextEntry(zipEntry);
                BcXmlUtil.output(xmlDoc, zipOs, false);
            }
        }
    }

    protected void parseMetaData() throws Exception {
        ZipEntry zipEntry = this.zipFile.getEntry(ZEN_metaData);
        Document xmlDoc = BcXmlUtil.createDocument(this.zipFile.getInputStream(zipEntry));
        Element rootNode = xmlDoc.getDocumentElement();
        this.title = BcXmlUtil.getTextValue(rootNode, XTAG_title);
        this.author = BcXmlUtil.getTextValue(rootNode, XTAG_author);
        Node xmlElemL1 = BcXmlUtil.getFirstNode((Node)rootNode, XTAG_pageIndex);
        NodeList nodeList = xmlElemL1.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node node = nodeList.item(i);
            String pageNo = BcXmlUtil.getAttribute(node, XTAG_pageNo);
            String zipEntryName = BcXmlUtil.getAttribute(node, XTAG_zipEntry);
            this.pagePathList.add(BcNumberUtil.parseInteger(pageNo) - 1, zipEntryName);
            ++i;
        }
    }

    protected String toZipEntryName(int pageNox) throws Exception {
        return ZEP_page + BcStringUtil.fillPrefix(pageNox, 8, '0') + "." + "dfs";
    }

    protected String toZipEntryName_BG(int pageIndex) throws Exception {
        return ZEP_bgPage + BcStringUtil.fillPrefix(pageIndex, 8, '0') + "." + "dfs";
    }

    protected String toFileName(int pageId) throws Exception {
        return "tmp_" + BcStringUtil.fillPrefix(pageId, 8, '0') + "." + "dfs";
    }

    @Override
    public boolean isBgPageEnabled() {
        return this.bgPageEnabled;
    }

    @Override
    public void setBgPageEnabled(boolean bgPageEnabled) throws Exception {
        this.bgPageEnabled = bgPageEnabled;
    }

    /*
     * Enabled aggressive block sorting
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public int addBgPage(String pageName, DcfPage dcfPage) throws Exception {
        BcMonitor bcMonitor = this.monitor;
        // MONITORENTER : bcMonitor
        // MONITOREXIT : bcMonitor
        return -1;
    }

    @Override
    public DcfPage getBgPage(String pageName) throws Exception {
        return null;
    }

    public Object clone() throws CloneNotSupportedException {
        DcfBookFile obj = (DcfBookFile)super.clone();
        return obj;
    }
}

