/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.codec.video.colorspace;

import com.sun.media.BasicCodec;
import com.sun.media.JMFSecurityManager;
import com.sun.media.util.Arch;
import java.awt.Dimension;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.RGBFormat;

public class NativeRGBToRGB
extends BasicCodec {
    private static boolean loaded = false;
    protected int rm1;
    protected int rm2;
    protected int gm1;
    protected int gm2;
    protected int bm1;
    protected int bm2;
    protected int rMask;
    protected int gMask;
    protected int bMask;
    protected int rShift;
    protected int gShift;
    protected int bShift;
    private int conversionFun = 0;

    public String getName() {
        return "RGB To RGB Converter";
    }

    protected boolean supportedRGB(Format format) {
        if (!(format instanceof RGBFormat)) {
            return false;
        }
        RGBFormat rgb = (RGBFormat)format;
        int bitsPerPixel = rgb.getBitsPerPixel();
        int pixelStride = rgb.getPixelStride();
        int lineStride = rgb.getLineStride();
        int redMask = rgb.getRedMask();
        int greenMask = rgb.getGreenMask();
        int blueMask = rgb.getBlueMask();
        Dimension size = rgb.getSize();
        Class dataType = rgb.getDataType();
        int elementsPerPixel = 1;
        switch (bitsPerPixel) {
            case 15: 
            case 16: {
                if (dataType != Format.byteArray && dataType != Format.shortArray) {
                    return false;
                }
                if (dataType != Format.byteArray) break;
                elementsPerPixel = 2;
                break;
            }
            case 24: {
                if (dataType != Format.byteArray) {
                    return false;
                }
                elementsPerPixel = 3;
                break;
            }
            case 32: {
                if (dataType != Format.byteArray) break;
                elementsPerPixel = 4;
            }
        }
        if (size != null) {
            if (lineStride < size.width * elementsPerPixel) {
                return false;
            }
            if (pixelStride < elementsPerPixel) {
                return false;
            }
        }
        return true;
    }

    public Format[] getSupportedInputFormats() {
        Format[] formats = new RGBFormat[]{new RGBFormat(null, -1, Format.byteArray, -1.0f, 24, 3, 2, 1, 3, -1, 0, -1), new RGBFormat(null, -1, Format.byteArray, -1.0f, 16, 63488, 2016, 31, 2, -1, 0, -1)};
        return formats;
    }

    public Format[] getSupportedOutputFormats(Format in) {
        if (!this.supportedRGB(in)) {
            return new RGBFormat[]{new RGBFormat()};
        }
        RGBFormat rgb = (RGBFormat)in;
        Dimension size = rgb.getSize();
        if (size == null) {
            size = new Dimension(320, 240);
        }
        Format[] formats = new RGBFormat[]{new RGBFormat(size, size.width * size.height, Format.intArray, rgb.getFrameRate(), 32, 0xFF0000, 65280, 255, 1, size.width, rgb.getFlipped(), rgb.getEndian()), new RGBFormat(size, size.width * size.height * 4, Format.byteArray, rgb.getFrameRate(), 32, 2, 3, 4, 4, size.width * 4, rgb.getFlipped(), rgb.getEndian()), new RGBFormat(size, size.width * size.height * 3, Format.byteArray, rgb.getFrameRate(), 24, 1, 2, 3, 3, size.width * 3, rgb.getFlipped(), rgb.getEndian()), new RGBFormat(size, size.width * size.height, Format.shortArray, rgb.getFrameRate(), 16, 63488, 2016, 31, 1, size.width, rgb.getFlipped(), rgb.getEndian()), new RGBFormat(size, size.width * size.height, Format.byteArray, rgb.getFrameRate(), 16, 63488, 2016, 31, 2, size.width * 2, rgb.getFlipped(), rgb.getEndian()), new RGBFormat(size, size.width * size.height, Format.shortArray, rgb.getFrameRate(), 16, 31744, 992, 31, 1, size.width, rgb.getFlipped(), rgb.getEndian())};
        return formats;
    }

    public void open() throws ResourceUnavailableException {
        if (!loaded) {
            try {
                JMFSecurityManager.loadLibrary("jmutil");
                loaded = true;
            }
            catch (UnsatisfiedLinkError e2) {
                throw new ResourceUnavailableException(e2.getMessage());
            }
        }
        if (!this.supportedRGB(this.inputFormat) || !this.supportedRGB(this.outputFormat)) {
            throw new ResourceUnavailableException("Invalid Formats");
        }
    }

    protected void initialize() {
        RGBFormat rgb1 = (RGBFormat)this.inputFormat;
        RGBFormat rgb2 = (RGBFormat)this.outputFormat;
        this.rm1 = rgb1.getRedMask();
        this.gm1 = rgb1.getGreenMask();
        this.bm1 = rgb1.getBlueMask();
        this.rm2 = rgb2.getRedMask();
        this.gm2 = rgb2.getGreenMask();
        this.bm2 = rgb2.getBlueMask();
        boolean packed1 = rgb1.getDataType() != Format.byteArray;
        boolean packed2 = rgb2.getDataType() != Format.byteArray;
        int bytesPerPixel1 = rgb1.getBitsPerPixel();
        int bytesPerPixel2 = rgb2.getBitsPerPixel();
        bytesPerPixel1 = bytesPerPixel1 == 15 ? 2 : (bytesPerPixel1 /= 8);
        bytesPerPixel2 = bytesPerPixel2 == 15 ? 2 : (bytesPerPixel2 /= 8);
        switch (bytesPerPixel1) {
            case 3: {
                if (Arch.isBigEndian()) {
                    this.rm1 = 255 << (3 - this.rm1) * 8;
                    this.gm1 = 255 << (3 - this.gm1) * 8;
                    this.bm1 = 255 << (3 - this.bm1) * 8;
                    break;
                }
                this.rm1 = 255 << this.rm1 * 8;
                this.gm1 = 255 << this.gm1 * 8;
                this.bm1 = 255 << this.bm1 * 8;
                break;
            }
            case 4: {
                if (packed1) break;
                if (Arch.isBigEndian()) {
                    this.rm1 = 255 << (4 - this.rm1) * 8;
                    this.gm1 = 255 << (4 - this.gm1) * 8;
                    this.bm1 = 255 << (4 - this.bm1) * 8;
                    break;
                }
                this.rm1 = 255 << (this.rm1 - 1) * 8;
                this.gm1 = 255 << (this.gm1 - 1) * 8;
                this.bm1 = 255 << (this.bm1 - 1) * 8;
            }
        }
        switch (bytesPerPixel2) {
            case 3: {
                if (Arch.isBigEndian()) {
                    this.rm2 = 255 << (3 - this.rm2) * 8;
                    this.gm2 = 255 << (3 - this.gm2) * 8;
                    this.bm2 = 255 << (3 - this.bm2) * 8;
                    break;
                }
                this.rm2 = 255 << this.rm2 * 8;
                this.gm2 = 255 << this.gm2 * 8;
                this.bm2 = 255 << this.bm2 * 8;
                break;
            }
            case 4: {
                if (packed2) break;
                if (Arch.isBigEndian()) {
                    this.rm2 = 255 << (4 - this.rm2) * 8;
                    this.gm2 = 255 << (4 - this.gm2) * 8;
                    this.bm2 = 255 << (4 - this.bm2) * 8;
                    break;
                }
                this.rm2 = 255 << (this.rm1 - 1) * 8;
                this.gm2 = 255 << (this.gm1 - 1) * 8;
                this.bm2 = 255 << (this.bm1 - 1) * 8;
            }
        }
        this.initConverter(this.rm1, this.gm1, this.bm1, bytesPerPixel1, this.rm2, this.gm2, this.bm2, bytesPerPixel2);
    }

    public int process(Buffer inBuffer, Buffer outBuffer) {
        if (!loaded) {
            return 1;
        }
        if (this.isEOM(inBuffer)) {
            this.propagateEOM(outBuffer);
            return 0;
        }
        if (this.conversionFun == 0) {
            this.initialize();
        }
        if (this.conversionFun == 0) {
            return 1;
        }
        RGBFormat inFormat = (RGBFormat)inBuffer.getFormat();
        RGBFormat outFormat = (RGBFormat)outBuffer.getFormat();
        if (outFormat == null) {
            outFormat = (RGBFormat)this.outputFormat;
            outBuffer.setFormat(outFormat);
        }
        int aes1 = this.getArrayElementSize(inFormat.getDataType());
        int aes2 = this.getArrayElementSize(outFormat.getDataType());
        Object inData = inBuffer.getData();
        Object outData = outBuffer.getData();
        if (outData == null) {
            int maxDataLength = outFormat.getMaxDataLength();
            switch (aes2) {
                case 2: {
                    outData = new short[maxDataLength];
                    break;
                }
                case 4: {
                    outData = new int[maxDataLength];
                    break;
                }
                case 1: {
                    outData = new byte[maxDataLength];
                    break;
                }
                default: {
                    return 1;
                }
            }
            outBuffer.setData(outData);
        }
        Dimension size = inFormat.getSize();
        this.convert(inData, aes1, inFormat.getLineStride() / inFormat.getPixelStride(), outData, aes2, outFormat.getLineStride() / outFormat.getPixelStride(), size.width, size.height);
        outBuffer.setLength(outFormat.getLineStride() * size.height);
        return 0;
    }

    private native void initConverter(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8);

    private native boolean convert(Object var1, int var2, int var3, Object var4, int var5, int var6, int var7, int var8);
}

