/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.status;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.MessageFactory;
import org.apache.logging.log4j.message.ParameterizedNoReferenceMessageFactory;
import org.apache.logging.log4j.spi.AbstractLogger;
import org.apache.logging.log4j.status.StatusConsoleListener;
import org.apache.logging.log4j.status.StatusData;
import org.apache.logging.log4j.status.StatusListener;

public class StatusLogger
extends AbstractLogger {
    private static final long serialVersionUID = 2L;
    private static final String DEBUG_PROPERTY_NAME = "log4j2.debug";
    public static final String MAX_STATUS_ENTRIES = "log4j2.status.entries";
    public static final String DEFAULT_STATUS_LISTENER_LEVEL = "log4j2.StatusLogger.level";
    public static final String STATUS_DATE_FORMAT = "log4j2.StatusLogger.DateFormat";
    public static final String PROPERTIES_FILE_NAME = "log4j2.StatusLogger.properties";
    private final Config config;
    private final StatusConsoleListener fallbackListener;
    private final List<StatusListener> listeners;
    private final transient ReadWriteLock listenerLock = new ReentrantReadWriteLock();
    private final transient Lock listenerReadLock = this.listenerLock.readLock();
    private final transient Lock listenerWriteLock = this.listenerLock.writeLock();
    private final Queue<StatusData> buffer = new ConcurrentLinkedQueue<StatusData>();

    private StatusLogger() {
        this(StatusLogger.class.getSimpleName(), ParameterizedNoReferenceMessageFactory.INSTANCE, Config.getInstance(), new StatusConsoleListener(Config.getInstance().fallbackListenerLevel));
    }

    public StatusLogger(String name, MessageFactory messageFactory, Config config, StatusConsoleListener fallbackListener) {
        super(Objects.requireNonNull(name, "name"), Objects.requireNonNull(messageFactory, "messageFactory"));
        this.config = Objects.requireNonNull(config, "config");
        this.fallbackListener = Objects.requireNonNull(fallbackListener, "fallbackListener");
        this.listeners = new ArrayList<StatusListener>();
    }

    public static StatusLogger getLogger() {
        return InstanceHolder.INSTANCE;
    }

    public static void setLogger(StatusLogger logger) {
        InstanceHolder.INSTANCE = Objects.requireNonNull(logger, "logger");
    }

    public StatusConsoleListener getFallbackListener() {
        return this.fallbackListener;
    }

    @Deprecated
    public void setLevel(Level level) {
        Objects.requireNonNull(level, "level");
        this.fallbackListener.setLevel(level);
    }

    public void registerListener(StatusListener listener) {
        Objects.requireNonNull(listener, "listener");
        this.listenerWriteLock.lock();
        try {
            this.listeners.add(listener);
        }
        finally {
            this.listenerWriteLock.unlock();
        }
    }

    public void removeListener(StatusListener listener) {
        Objects.requireNonNull(listener, "listener");
        this.listenerWriteLock.lock();
        try {
            this.listeners.remove(listener);
            StatusLogger.closeListenerSafely(listener);
        }
        finally {
            this.listenerWriteLock.unlock();
        }
    }

    @Deprecated
    public void updateListenerLevel(Level level) {
        Objects.requireNonNull(level, "level");
        this.fallbackListener.setLevel(level);
    }

    public Iterable<StatusListener> getListeners() {
        this.listenerReadLock.lock();
        try {
            Collection<StatusListener> collection = Collections.unmodifiableCollection(this.listeners);
            return collection;
        }
        finally {
            this.listenerReadLock.unlock();
        }
    }

    public void reset() {
        this.listenerWriteLock.lock();
        try {
            Iterator<StatusListener> listenerIterator = this.listeners.iterator();
            while (listenerIterator.hasNext()) {
                StatusListener listener = listenerIterator.next();
                StatusLogger.closeListenerSafely(listener);
                listenerIterator.remove();
            }
        }
        finally {
            this.listenerWriteLock.unlock();
        }
        this.fallbackListener.close();
        this.buffer.clear();
    }

    private static void closeListenerSafely(StatusListener listener) {
        try {
            listener.close();
        }
        catch (IOException error) {
            String message = String.format("failed closing listener: %s", listener);
            new RuntimeException(message, error).printStackTrace(System.err);
        }
    }

    @Deprecated
    public List<StatusData> getStatusData() {
        return Collections.unmodifiableList(new ArrayList<StatusData>(this.buffer));
    }

    @Deprecated
    public void clear() {
        this.buffer.clear();
    }

    @Override
    public Level getLevel() {
        Level leastSpecificLevel = this.fallbackListener.getStatusLevel();
        int listenerIndex = 0;
        while (listenerIndex < this.listeners.size()) {
            StatusListener listener = this.listeners.get(listenerIndex);
            Level listenerLevel = listener.getStatusLevel();
            if (listenerLevel.isLessSpecificThan(leastSpecificLevel)) {
                leastSpecificLevel = listenerLevel;
            }
            ++listenerIndex;
        }
        return leastSpecificLevel;
    }

    @Override
    public void logMessage(String fqcn, Level level, Marker marker, Message message, Throwable throwable) {
        StatusData statusData = this.createStatusData(fqcn, level, message, throwable);
        this.buffer(statusData);
        this.notifyListeners(statusData);
    }

    private void buffer(StatusData statusData) {
        if (this.config.bufferCapacity == 0) {
            return;
        }
        this.buffer.add(statusData);
        while (this.buffer.size() >= this.config.bufferCapacity) {
            this.buffer.remove();
        }
    }

    private void notifyListeners(StatusData statusData) {
        boolean foundListeners;
        this.listenerReadLock.lock();
        try {
            foundListeners = !this.listeners.isEmpty();
            this.listeners.forEach(listener -> this.notifyListener((StatusListener)listener, statusData));
        }
        finally {
            this.listenerReadLock.unlock();
        }
        if (!foundListeners) {
            this.notifyListener(this.fallbackListener, statusData);
        }
    }

    private void notifyListener(StatusListener listener, StatusData statusData) {
        if (this.config.debugEnabled || listener.getStatusLevel().isLessSpecificThan(statusData.getLevel())) {
            listener.log(statusData);
        }
    }

    private StatusData createStatusData(@Nullable String fqcn, Level level, Message message, @Nullable Throwable throwable) {
        StackTraceElement caller = StatusLogger.getStackTraceElement(fqcn);
        return new StatusData(caller, level, message, throwable, null, this.config.instantFormatter);
    }

    @Nullable
    private static StackTraceElement getStackTraceElement(@Nullable String fqcn) {
        StackTraceElement[] stackTrace;
        if (fqcn == null) {
            return null;
        }
        boolean next = false;
        StackTraceElement[] stackTraceElementArray = stackTrace = Thread.currentThread().getStackTrace();
        int n = stackTrace.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement element = stackTraceElementArray[n2];
            String className = element.getClassName();
            if (next && !fqcn.equals(className)) {
                return element;
            }
            if (fqcn.equals(className)) {
                next = true;
            } else if ("?".equals(className)) break;
            ++n2;
        }
        return null;
    }

    @Override
    public boolean isEnabled(Level level, Marker marker, String message, Throwable throwable) {
        return this.isEnabled(level, marker);
    }

    @Override
    public boolean isEnabled(Level level, Marker marker, String message) {
        return this.isEnabled(level, marker);
    }

    @Override
    public boolean isEnabled(Level level, Marker marker, String message, Object ... params) {
        return this.isEnabled(level, marker);
    }

    @Override
    public boolean isEnabled(Level level, Marker marker, String message, Object p0) {
        return this.isEnabled(level, marker);
    }

    @Override
    public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1) {
        return this.isEnabled(level, marker);
    }

    @Override
    public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1, Object p2) {
        return this.isEnabled(level, marker);
    }

    @Override
    public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3) {
        return this.isEnabled(level, marker);
    }

    @Override
    public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4) {
        return this.isEnabled(level, marker);
    }

    @Override
    public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5) {
        return this.isEnabled(level, marker);
    }

    @Override
    public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6) {
        return this.isEnabled(level, marker);
    }

    @Override
    public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7) {
        return this.isEnabled(level, marker);
    }

    @Override
    public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8) {
        return this.isEnabled(level, marker);
    }

    @Override
    public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8, Object p9) {
        return this.isEnabled(level, marker);
    }

    @Override
    public boolean isEnabled(Level level, Marker marker, CharSequence message, Throwable throwable) {
        return this.isEnabled(level, marker);
    }

    @Override
    public boolean isEnabled(Level level, Marker marker, Object message, Throwable throwable) {
        return this.isEnabled(level, marker);
    }

    @Override
    public boolean isEnabled(Level level, Marker marker, Message message, Throwable throwable) {
        return this.isEnabled(level, marker);
    }

    @Override
    public boolean isEnabled(Level level, Marker marker) {
        Objects.requireNonNull(level, "level");
        return this.getLevel().isLessSpecificThan(level);
    }

    /* synthetic */ StatusLogger(StatusLogger statusLogger) {
        this();
    }

    public static final class Config {
        private static final Config INSTANCE = new Config();
        private final boolean debugEnabled;
        private final int bufferCapacity;
        @Nullable
        private final Level fallbackListenerLevel;
        @Nullable
        private final DateTimeFormatter instantFormatter;

        public Config(boolean debugEnabled, int bufferCapacity, @Nullable DateTimeFormatter instantFormatter) {
            this.debugEnabled = debugEnabled;
            if (bufferCapacity < 0) {
                throw new IllegalArgumentException("was expecting a positive `bufferCapacity`, found: " + bufferCapacity);
            }
            this.bufferCapacity = bufferCapacity;
            this.fallbackListenerLevel = null;
            this.instantFormatter = instantFormatter;
        }

        private Config() {
            Properties fileProvidedProperties = Config.readPropertiesFile();
            this.debugEnabled = Config.readDebugEnabled(fileProvidedProperties);
            this.bufferCapacity = Config.readBufferCapacity(fileProvidedProperties);
            this.fallbackListenerLevel = Config.readFallbackListenerLevel(fileProvidedProperties);
            this.instantFormatter = Config.readInstantFormatter(fileProvidedProperties);
        }

        public static Config getInstance() {
            return INSTANCE;
        }

        private static boolean readDebugEnabled(Properties fileProvidedProperties) {
            String debug = Config.readProperty(fileProvidedProperties, StatusLogger.DEBUG_PROPERTY_NAME);
            return debug != null;
        }

        private static int readBufferCapacity(Properties fileProvidedProperties) {
            String capacityString = Config.readProperty(fileProvidedProperties, StatusLogger.MAX_STATUS_ENTRIES);
            return capacityString != null ? Integer.parseInt(capacityString) : 0;
        }

        private static Level readFallbackListenerLevel(Properties fileProvidedProperties) {
            String level = Config.readProperty(fileProvidedProperties, StatusLogger.DEFAULT_STATUS_LISTENER_LEVEL);
            return level != null ? Level.valueOf(level) : Level.ERROR;
        }

        private static DateTimeFormatter readInstantFormatter(Properties fileProvidedProperties) {
            String format = Config.readProperty(fileProvidedProperties, StatusLogger.STATUS_DATE_FORMAT);
            return format != null ? DateTimeFormatter.ofPattern(format) : null;
        }

        private static String readProperty(Properties fileProvidedProperties, String propertyName) {
            String systemProvidedValue = System.getProperty(propertyName);
            return systemProvidedValue != null ? systemProvidedValue : (String)fileProvidedProperties.get(propertyName);
        }

        private static Properties readPropertiesFile() {
            Properties properties = new Properties();
            URL url = StatusLogger.class.getResource(StatusLogger.PROPERTIES_FILE_NAME);
            if (url == null) {
                return properties;
            }
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (InputStream stream = url.openStream();){
                    properties.load(stream);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException error) {
                error.printStackTrace(System.err);
            }
            return properties;
        }
    }

    private static final class InstanceHolder {
        private static volatile StatusLogger INSTANCE = new StatusLogger(null);

        private InstanceHolder() {
        }
    }
}

