/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.util.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.ConfigurationException;
import org.apache.logging.log4j.core.net.UrlConnectionFactory;
import org.apache.logging.log4j.core.net.ssl.SslConfigurationFactory;
import org.apache.logging.log4j.core.util.AuthorizationProvider;
import org.apache.logging.log4j.core.util.internal.LastModifiedSource;
import org.apache.logging.log4j.core.util.internal.Status;
import org.apache.logging.log4j.status.StatusLogger;

public final class HttpInputStreamUtil {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private static final int NOT_MODIFIED = 304;
    private static final int NOT_AUTHORIZED = 401;
    private static final int NOT_FOUND = 404;
    private static final int OK = 200;
    private static final int BUF_SIZE = 1024;

    /*
     * Unable to fully structure code
     * Enabled aggressive exception aggregation
     */
    public static Result getInputStream(LastModifiedSource source, AuthorizationProvider authorizationProvider) {
        result = new Result();
        try {
            lastModified = source.getLastModified();
            connection = (HttpURLConnection)UrlConnectionFactory.createConnection(source.getURI().toURL(), lastModified, SslConfigurationFactory.getSslConfiguration(), authorizationProvider);
            connection.connect();
            try {
                code = connection.getResponseCode();
                switch (code) {
                    case 304: {
                        HttpInputStreamUtil.LOGGER.debug("Configuration not modified");
                        Result.access$0(result, Status.NOT_MODIFIED);
                        var12_7 = result;
                        return var12_7;
                    }
                    case 404: {
                        HttpInputStreamUtil.LOGGER.debug("Unable to access {}: Not Found", (Object)source.toString());
                        Result.access$0(result, Status.NOT_FOUND);
                        var12_8 = result;
                        return var12_8;
                    }
                    case 200: {
                        var7_10 = null;
                        var8_13 = null;
                        is = connection.getInputStream();
                        try {
                            source.setLastModified(connection.getLastModified());
                            HttpInputStreamUtil.LOGGER.debug("Content was modified for {}. previous lastModified: {}, new lastModified: {}", (Object)source.toString(), (Object)lastModified, (Object)connection.getLastModified());
                            Result.access$0(result, Status.SUCCESS);
                            Result.access$1(result, new ByteArrayInputStream(HttpInputStreamUtil.readStream(is)));
                            var12_9 = result;
                            if (is == null) ** GOTO lbl68
                        }
                        catch (Throwable var7_11) {
                            try {
                                try {
                                    if (is != null) {
                                        is.close();
                                    }
                                    throw var7_11;
                                }
                                catch (Throwable var8_14) {
                                    if (var7_10 == null) {
                                        var7_10 = var8_14;
                                    } else if (var7_10 != var8_14) {
                                        var7_10.addSuppressed(var8_14);
                                    }
                                    throw var7_10;
                                }
                            }
                            catch (IOException e) {
                                try {
                                    var8_13 = null;
                                    var9_17 = null;
                                    try {
                                        es = connection.getErrorStream();
                                        try {
                                            HttpInputStreamUtil.LOGGER.info("Error accessing configuration at {}: {}", (Object)source.toString(), (Object)HttpInputStreamUtil.readStream(es));
                                        }
                                        finally {
                                            if (es != null) {
                                                es.close();
                                            }
                                        }
                                    }
                                    catch (Throwable var9_18) {
                                        if (var8_13 == null) {
                                            var8_13 = var9_18;
                                        } else if (var8_13 != var9_18) {
                                            var8_13.addSuppressed(var9_18);
                                        }
                                        throw var8_13;
                                    }
                                }
                                catch (IOException ioe) {
                                    HttpInputStreamUtil.LOGGER.error("Error accessing configuration at {}: {}", (Object)source.toString(), (Object)e.getMessage());
                                }
                                throw new ConfigurationException("Unable to access " + source.toString(), e);
                            }
                        }
                        is.close();
lbl68:
                        // 2 sources

                        return var12_9;
                    }
                    case 401: {
                        throw new ConfigurationException("Authorization failed");
                    }
                }
                if (code < 0) {
                    HttpInputStreamUtil.LOGGER.info("Invalid response code returned");
                } else {
                    HttpInputStreamUtil.LOGGER.info("Unexpected response code returned {}", (Object)code);
                }
                throw new ConfigurationException("Unable to access " + source.toString());
            }
            finally {
                connection.disconnect();
            }
        }
        catch (IOException e) {
            HttpInputStreamUtil.LOGGER.warn("Error accessing {}: {}", (Object)source.toString(), (Object)e.getMessage());
            throw new ConfigurationException("Unable to access " + source.toString(), e);
        }
    }

    public static byte[] readStream(InputStream is) throws IOException {
        int length;
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((length = is.read(buffer)) != -1) {
            result.write(buffer, 0, length);
        }
        return result.toByteArray();
    }

    public static class Result {
        private InputStream inputStream;
        private Status status;

        public Result() {
        }

        public Result(Status status) {
            this.status = status;
        }

        public InputStream getInputStream() {
            return this.inputStream;
        }

        public Status getStatus() {
            return this.status;
        }

        static /* synthetic */ void access$0(Result result, Status status) {
            result.status = status;
        }

        static /* synthetic */ void access$1(Result result, InputStream inputStream) {
            result.inputStream = inputStream;
        }
    }
}

