/*
 * Decompiled with CFR 0.152.
 */
package nlc.lib.barcode;

import ext.base.core.BcDouble;
import ext.base.core.BcStringUtil;
import ext.lib.doc.util.DcfDocumentUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import nlc.lib.barcode.DcfAbstractBarcodeContext;
import nlc.lib.barcode.DcfBarcodeRenderer;
import nlc.lib.barcode.DcfBarcodeUtil;
import nlc.lib.doc.shape.DcfRectangleShape;
import nlc.lib.doc.shape.DcfShapeGroup;

public class DcfCode128
extends DcfAbstractBarcodeContext
implements DcfBarcodeRenderer {
    public static final int START_A = 103;
    public static final int START_B = 104;
    public static final int START_C = 105;
    public static final int CODE_A = 903;
    public static final int CODE_B = 904;
    public static final int CODE_C = 905;
    public static final int FNC1 = 911;
    public static final int FNC2 = 912;
    public static final int FNC4 = 913;
    public static final int FNC5 = 914;
    public static final int STOP = 999;
    public static final double NAROW_BAR_WIDTH = 0.25;
    public static final double NAROW_BAR_HEIGHT = 8.0;

    protected static String getPattern(int num) throws Exception {
        String resStr = null;
        switch (num) {
            case 0: {
                resStr = "212222";
                break;
            }
            case 1: {
                resStr = "222122";
                break;
            }
            case 2: {
                resStr = "222221";
                break;
            }
            case 3: {
                resStr = "121223";
                break;
            }
            case 4: {
                resStr = "121322";
                break;
            }
            case 5: {
                resStr = "131222";
                break;
            }
            case 6: {
                resStr = "122213";
                break;
            }
            case 7: {
                resStr = "122312";
                break;
            }
            case 8: {
                resStr = "132212";
                break;
            }
            case 9: {
                resStr = "221213";
                break;
            }
            case 10: {
                resStr = "221312";
                break;
            }
            case 11: {
                resStr = "231212";
                break;
            }
            case 12: {
                resStr = "112232";
                break;
            }
            case 13: {
                resStr = "122132";
                break;
            }
            case 14: {
                resStr = "122231";
                break;
            }
            case 15: {
                resStr = "113222";
                break;
            }
            case 16: {
                resStr = "123122";
                break;
            }
            case 17: {
                resStr = "123221";
                break;
            }
            case 18: {
                resStr = "223211";
                break;
            }
            case 19: {
                resStr = "221132";
                break;
            }
            case 20: {
                resStr = "221231";
                break;
            }
            case 21: {
                resStr = "213212";
                break;
            }
            case 22: {
                resStr = "223112";
                break;
            }
            case 23: {
                resStr = "312131";
                break;
            }
            case 24: {
                resStr = "311222";
                break;
            }
            case 25: {
                resStr = "321122";
                break;
            }
            case 26: {
                resStr = "321221";
                break;
            }
            case 27: {
                resStr = "312212";
                break;
            }
            case 28: {
                resStr = "322112";
                break;
            }
            case 29: {
                resStr = "322211";
                break;
            }
            case 30: {
                resStr = "212123";
                break;
            }
            case 31: {
                resStr = "212321";
                break;
            }
            case 32: {
                resStr = "232121";
                break;
            }
            case 33: {
                resStr = "111323";
                break;
            }
            case 34: {
                resStr = "131123";
                break;
            }
            case 35: {
                resStr = "131321";
                break;
            }
            case 36: {
                resStr = "112313";
                break;
            }
            case 37: {
                resStr = "132113";
                break;
            }
            case 38: {
                resStr = "132311";
                break;
            }
            case 39: {
                resStr = "211313";
                break;
            }
            case 40: {
                resStr = "231113";
                break;
            }
            case 41: {
                resStr = "231311";
                break;
            }
            case 42: {
                resStr = "112133";
                break;
            }
            case 43: {
                resStr = "112331";
                break;
            }
            case 44: {
                resStr = "132131";
                break;
            }
            case 45: {
                resStr = "113123";
                break;
            }
            case 46: {
                resStr = "113321";
                break;
            }
            case 47: {
                resStr = "133121";
                break;
            }
            case 48: {
                resStr = "313121";
                break;
            }
            case 49: {
                resStr = "211331";
                break;
            }
            case 50: {
                resStr = "231131";
                break;
            }
            case 51: {
                resStr = "213113";
                break;
            }
            case 52: {
                resStr = "213311";
                break;
            }
            case 53: {
                resStr = "213131";
                break;
            }
            case 54: {
                resStr = "311123";
                break;
            }
            case 55: {
                resStr = "311321";
                break;
            }
            case 56: {
                resStr = "331121";
                break;
            }
            case 57: {
                resStr = "312113";
                break;
            }
            case 58: {
                resStr = "312311";
                break;
            }
            case 59: {
                resStr = "332111";
                break;
            }
            case 60: {
                resStr = "314111";
                break;
            }
            case 61: {
                resStr = "221411";
                break;
            }
            case 62: {
                resStr = "431111";
                break;
            }
            case 63: {
                resStr = "111224";
                break;
            }
            case 64: {
                resStr = "111422";
                break;
            }
            case 65: {
                resStr = "121124";
                break;
            }
            case 66: {
                resStr = "121421";
                break;
            }
            case 67: {
                resStr = "141122";
                break;
            }
            case 68: {
                resStr = "141221";
                break;
            }
            case 69: {
                resStr = "112214";
                break;
            }
            case 70: {
                resStr = "112412";
                break;
            }
            case 71: {
                resStr = "122114";
                break;
            }
            case 72: {
                resStr = "122411";
                break;
            }
            case 73: {
                resStr = "142112";
                break;
            }
            case 74: {
                resStr = "142211";
                break;
            }
            case 75: {
                resStr = "241211";
                break;
            }
            case 76: {
                resStr = "221114";
                break;
            }
            case 77: {
                resStr = "413111";
                break;
            }
            case 78: {
                resStr = "241112";
                break;
            }
            case 79: {
                resStr = "134111";
                break;
            }
            case 80: {
                resStr = "111242";
                break;
            }
            case 81: {
                resStr = "121142";
                break;
            }
            case 82: {
                resStr = "121241";
                break;
            }
            case 83: {
                resStr = "114212";
                break;
            }
            case 84: {
                resStr = "124112";
                break;
            }
            case 85: {
                resStr = "124211";
                break;
            }
            case 86: {
                resStr = "411212";
                break;
            }
            case 87: {
                resStr = "421112";
                break;
            }
            case 88: {
                resStr = "421211";
                break;
            }
            case 89: {
                resStr = "212141";
                break;
            }
            case 90: {
                resStr = "214121";
                break;
            }
            case 91: {
                resStr = "412121";
                break;
            }
            case 92: {
                resStr = "111143";
                break;
            }
            case 93: {
                resStr = "111341";
                break;
            }
            case 94: {
                resStr = "131141";
                break;
            }
            case 95: {
                resStr = "114113";
                break;
            }
            case 96: {
                resStr = "114311";
                break;
            }
            case 97: {
                resStr = "411113";
                break;
            }
            case 98: {
                resStr = "411311";
                break;
            }
            case 99: {
                resStr = "113141";
                break;
            }
            case 100: {
                resStr = "114131";
                break;
            }
            case 101: {
                resStr = "311141";
                break;
            }
            case 102: {
                resStr = "411131";
                break;
            }
            case 103: {
                resStr = "211412";
                break;
            }
            case 104: {
                resStr = "211214";
                break;
            }
            case 105: {
                resStr = "211232";
                break;
            }
            case 999: {
                resStr = "2331112";
            }
        }
        return resStr;
    }

    protected static int getNum(int mode, char char_) {
        int num = -1;
        block0 : switch (mode) {
            case 903: {
                switch (char_) {
                    case ' ': {
                        num = 0;
                        break block0;
                    }
                    case '!': {
                        num = 1;
                        break block0;
                    }
                    case '\"': {
                        num = 2;
                        break block0;
                    }
                    case '#': {
                        num = 3;
                        break block0;
                    }
                    case '$': {
                        num = 4;
                        break block0;
                    }
                    case '%': {
                        num = 5;
                        break block0;
                    }
                    case '&': {
                        num = 6;
                        break block0;
                    }
                    case '\'': {
                        num = 7;
                        break block0;
                    }
                    case '(': {
                        num = 8;
                        break block0;
                    }
                    case ')': {
                        num = 9;
                        break block0;
                    }
                    case '*': {
                        num = 10;
                        break block0;
                    }
                    case '+': {
                        num = 11;
                        break block0;
                    }
                    case ',': {
                        num = 12;
                        break block0;
                    }
                    case '-': {
                        num = 13;
                        break block0;
                    }
                    case '.': {
                        num = 14;
                        break block0;
                    }
                    case '/': {
                        num = 15;
                        break block0;
                    }
                    case ':': {
                        num = 26;
                        break block0;
                    }
                    case ';': {
                        num = 27;
                        break block0;
                    }
                    case '<': {
                        num = 28;
                        break block0;
                    }
                    case '=': {
                        num = 29;
                        break block0;
                    }
                    case '>': {
                        num = 30;
                        break block0;
                    }
                    case '?': {
                        num = 31;
                        break block0;
                    }
                    case '@': {
                        num = 32;
                        break block0;
                    }
                    case '[': {
                        num = 59;
                        break block0;
                    }
                    case '\\': {
                        num = 60;
                        break block0;
                    }
                    case ']': {
                        num = 61;
                        break block0;
                    }
                    case '^': {
                        num = 62;
                        break block0;
                    }
                    case '_': {
                        num = 63;
                        break block0;
                    }
                }
                if (char_ >= '0' && char_ <= '9') {
                    num = 16 + (char_ - 48);
                    break;
                }
                if (char_ >= 'A' && char_ <= 'Z') {
                    num = 33 + (char_ - 65);
                    break;
                }
                if (char_ < '\u0000' || char_ > '\u001f') break;
                num = 64 + (char_ - '\u0000');
                break;
            }
            case 904: {
                switch (char_) {
                    case ' ': {
                        num = 0;
                        break block0;
                    }
                    case '!': {
                        num = 1;
                        break block0;
                    }
                    case '\"': {
                        num = 2;
                        break block0;
                    }
                    case '#': {
                        num = 3;
                        break block0;
                    }
                    case '$': {
                        num = 4;
                        break block0;
                    }
                    case '%': {
                        num = 5;
                        break block0;
                    }
                    case '&': {
                        num = 6;
                        break block0;
                    }
                    case '\'': {
                        num = 7;
                        break block0;
                    }
                    case '(': {
                        num = 8;
                        break block0;
                    }
                    case ')': {
                        num = 9;
                        break block0;
                    }
                    case '*': {
                        num = 10;
                        break block0;
                    }
                    case '+': {
                        num = 11;
                        break block0;
                    }
                    case ',': {
                        num = 12;
                        break block0;
                    }
                    case '-': {
                        num = 13;
                        break block0;
                    }
                    case '.': {
                        num = 14;
                        break block0;
                    }
                    case '/': {
                        num = 15;
                        break block0;
                    }
                    case ':': {
                        num = 26;
                        break block0;
                    }
                    case ';': {
                        num = 27;
                        break block0;
                    }
                    case '<': {
                        num = 28;
                        break block0;
                    }
                    case '=': {
                        num = 29;
                        break block0;
                    }
                    case '>': {
                        num = 30;
                        break block0;
                    }
                    case '?': {
                        num = 31;
                        break block0;
                    }
                    case '@': {
                        num = 32;
                        break block0;
                    }
                    case '[': {
                        num = 59;
                        break block0;
                    }
                    case '\\': {
                        num = 60;
                        break block0;
                    }
                    case ']': {
                        num = 61;
                        break block0;
                    }
                    case '^': {
                        num = 62;
                        break block0;
                    }
                    case '_': {
                        num = 63;
                        break block0;
                    }
                    case '`': {
                        num = 64;
                        break block0;
                    }
                    case '{': {
                        num = 91;
                        break block0;
                    }
                    case '|': {
                        num = 92;
                        break block0;
                    }
                    case '}': {
                        num = 93;
                        break block0;
                    }
                    case '~': {
                        num = 94;
                        break block0;
                    }
                    case '\u007f': {
                        num = 95;
                        break block0;
                    }
                }
                if (char_ >= '0' && char_ <= '9') {
                    num = 16 + (char_ - 48);
                    break;
                }
                if (char_ >= 'A' && char_ <= 'Z') {
                    num = 33 + (char_ - 65);
                    break;
                }
                if (char_ < 'a' || char_ > 'z') break;
                num = 65 + (char_ - 97);
                break;
            }
            case 905: {
                if (char_ < '\u0000' || char_ > 'c') break;
                num = char_;
            }
        }
        return num;
    }

    protected void drawPattern(DcfShapeGroup shapeGroup, BcDouble bx, double by, double ratio, double narowBarWidth, double narowBarHeight, String pattern) throws Exception {
        double tmpX = 0.0;
        int tmpW = 0;
        boolean isBlack = false;
        int j = 0;
        while (j < pattern.length()) {
            isBlack = !isBlack;
            tmpW = Integer.parseInt(pattern.substring(j, j + 1));
            if (isBlack) {
                DcfRectangleShape rectangleShape = new DcfRectangleShape();
                rectangleShape.setX(bx.value + tmpX);
                rectangleShape.setY(by);
                rectangleShape.getRectangle().width = narowBarWidth * (double)tmpW;
                rectangleShape.getRectangle().height = narowBarHeight;
                rectangleShape.lineColor = Color.black;
                rectangleShape.isFill = true;
                shapeGroup.addShape(rectangleShape);
            }
            bx.value += narowBarWidth * (double)tmpW;
            ++j;
        }
    }

    @Override
    public double[] getSize(String value) throws Exception {
        return null;
    }

    @Override
    public void drawBarcode(Graphics2D g2d, double bx, double by, String value) throws Exception {
        if (BcStringUtil.isEmpty(value)) {
            return;
        }
        ArrayList<int[]> intArrayList = new ArrayList<int[]>();
        int[] startCodeArray = new int[1];
        int cfr_ignored_0 = value.length() % 2;
        startCodeArray[0] = 103;
        intArrayList.add(startCodeArray);
        int[] intArray = new int[value.length()];
        int i = 0;
        while (i < intArray.length) {
            intArray[i] = DcfCode128.getNum(903, value.charAt(i));
            ++i;
        }
        intArrayList.add(intArray);
        double narowBarWidth = DcfDocumentUtil.mmToPixel_deprecated1(0.25);
        double narowBarHeight = DcfDocumentUtil.mmToPixel_deprecated1(8.0);
        double tmpX = bx;
        String pattern = null;
        int i2 = 0;
        while (i2 < intArrayList.size()) {
            int[] intArray2 = (int[])intArrayList.get(i2);
            int j = 0;
            while (j < intArray2.length) {
                pattern = DcfCode128.getPattern(intArray2[j]);
                tmpX += this.drawPattern(g2d, tmpX, by, narowBarWidth, narowBarHeight, pattern);
                ++j;
            }
            ++i2;
        }
        int checkDegit = DcfBarcodeUtil.calcMod103(intArrayList);
        pattern = DcfCode128.getPattern(checkDegit);
        tmpX += this.drawPattern(g2d, tmpX, by, narowBarWidth, narowBarHeight, pattern);
        pattern = DcfCode128.getPattern(999);
        tmpX += this.drawPattern(g2d, tmpX, by, narowBarWidth, narowBarHeight, pattern);
        g2d.setColor(Color.black);
        Font font = new Font("Dialog", 0, 32);
        g2d.setFont(font);
        double strGap1 = 32.0;
        g2d.drawString(value, (float)bx, (float)(by + narowBarHeight + strGap1));
    }

    protected double drawPattern(Graphics2D g, double bx, double by, double narowBarWidth, double narowBarHeight, String pattern) throws Exception {
        double tmpX = 0.0;
        int tmpW = 0;
        boolean isBlack = false;
        g.setColor(Color.black);
        int j = 0;
        while (j < pattern.length()) {
            isBlack = !isBlack;
            tmpW = Integer.parseInt(pattern.substring(j, j + 1));
            if (isBlack) {
                Rectangle2D.Double rectangle = new Rectangle2D.Double(bx + tmpX, by, narowBarWidth * (double)tmpW, narowBarHeight);
                g.fill(rectangle);
            }
            tmpX += narowBarWidth * (double)tmpW;
            ++j;
        }
        return tmpX;
    }
}

