/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xdts.fx;

import ext.base.core.BcLangUtil;
import ext.base.event.BcEventHandler;
import ext.base.event.BcProgressEvent;
import ext.base.util.BcWords;
import ext.lib.fx.layout.FxBorderPane;
import ext.lib.fx.util.FxImageHelper;
import ext.lib.fx.util.FxOptionPane;
import ext.lib.fx.util.FxUtil;
import ext.module.xdts.common.XdtsWords;
import ext.module.xdts.fx.XdtsMenuIF;
import ext.module.xdts.fx.XdtsTimerTablePane;
import ext.module.xdts.fx.XdtsTimerTaskPane;
import ext.module.xdts.model.XdtsTimer;
import javafx.event.ActionEvent;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.MenuBar;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;

public class XdtsTaskMenuPane
extends FxBorderPane
implements BcEventHandler<BcProgressEvent>,
XdtsMenuIF {
    FxBorderPane borderPane1 = new FxBorderPane();
    FxBorderPane borderPane2 = new FxBorderPane();
    XdtsTimerTablePane timerTablePane;
    XdtsTimer timer;
    HBox hBox1 = new HBox(8.0);
    Button addTimerButton;
    Button editTimerButton;
    Button deleteTimerButton;

    public XdtsTaskMenuPane() throws Exception {
        this.addTimerButton = new Button(XdtsWords.getInstance().addTimer);
        this.editTimerButton = new Button(XdtsWords.getInstance().editTimer);
        this.deleteTimerButton = new Button(XdtsWords.getInstance().deleteTimer);
        this.timerTablePane = new XdtsTimerTablePane(this);
        this.setComponant();
        this.setTimer(null);
    }

    protected void setComponant() throws Exception {
        this.borderPane1.setTop((Node)this.borderPane2);
        this.addTimerButton.setOnAction(this.actionEventHandler);
        this.addTimerButton.setGraphic((Node)FxImageHelper.createImageView_icon("db_add_64x64.png"));
        this.hBox1.getChildren().add((Object)this.addTimerButton);
        this.editTimerButton.setOnAction(this.actionEventHandler);
        this.editTimerButton.setGraphic((Node)FxImageHelper.createImageView_icon("db_gear_64x64.png"));
        this.hBox1.getChildren().add((Object)this.editTimerButton);
        this.deleteTimerButton.setOnAction(this.actionEventHandler);
        this.deleteTimerButton.setGraphic((Node)FxImageHelper.createImageView_icon("cancel_64x64.png"));
        this.hBox1.getChildren().add((Object)this.deleteTimerButton);
        this.hBox1.setAlignment(Pos.CENTER);
        this.borderPane2.setBottom((Node)this.hBox1);
        this.setRight((Node)this.borderPane1);
        this.setCenter((Node)this.timerTablePane);
        FxUtil.defaultInitialize((Node)this);
    }

    public void setTimer(XdtsTimer timer) throws Exception {
        this.timer = timer;
        boolean disable = false;
        if (timer == null) {
            disable = true;
        }
        this.editTimerButton.setDisable(disable);
        this.deleteTimerButton.setDisable(disable);
    }

    @Override
    public void actionPerformed(ActionEvent ev) throws Exception {
        super.actionPerformed(ev);
        if (ev.getSource().hashCode() == this.addTimerButton.hashCode()) {
            XdtsTimerTaskPane.show2(-1, this);
        } else if (ev.getSource().hashCode() == this.editTimerButton.hashCode()) {
            XdtsTimerTaskPane.show2(this.timer.getDataId(), this);
        } else if (ev.getSource().hashCode() == this.deleteTimerButton.hashCode()) {
            String msg = String.valueOf(XdtsWords.getInstance().timer) + "'" + this.timer.name + "' \u3092\u524a\u9664\u3057\u307e\u3059\u304b\uff1f";
            if (FxOptionPane.showConfirmDialog(this.getScene().getWindow(), (Object)msg, BcWords.getInstance().confirm, 3) == 0) {
                XdtsTimerTaskPane.delete(this.getScene().getWindow(), this.timer);
                this.timerTablePane.doLoad();
            }
        }
    }

    @Override
    public void handle(BcProgressEvent updateEvent) throws Exception {
        if (BcLangUtil.isAssignableFrom(XdtsTimer.class, updateEvent.getSource())) {
            this.timerTablePane.doLoad();
        }
    }

    @Override
    public String getTitle() throws Exception {
        return XdtsWords.getInstance().task;
    }

    @Override
    public void setMenu(MenuBar menuBar) throws Exception {
    }

    @Override
    public ImageView getImageView() throws Exception {
        return FxImageHelper.createImageView_icon("schedule_64x64.png");
    }
}

