/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.poi.word;

import ext.base.core.BcStringUtil;
import ext.base.io.BcFileUtil;
import ext.base.log.BcLogUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.hwpf.HWPFDocument;
import org.apache.poi.hwpf.usermodel.CharacterRun;
import org.apache.poi.hwpf.usermodel.Paragraph;
import org.apache.poi.hwpf.usermodel.Range;
import org.apache.poi.hwpf.usermodel.Section;
import org.apache.poi.xwpf.usermodel.PositionInParagraph;
import org.apache.poi.xwpf.usermodel.TextSegment;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;

public class PoiWordUtil {
    public static final String EXTENTION_doc = "doc";
    public static final String EXTENTION_docx = "docx";

    private PoiWordUtil() {
    }

    public static Object createDocument(File file) throws Exception {
        BcLogUtil.info("createDocument:file=" + file.getPath());
        String extention = BcFileUtil.getExtention(file);
        BcLogUtil.debug("extention=" + extention);
        XWPFDocument document = null;
        if (BcStringUtil.equalsIgnoreCase(EXTENTION_docx, extention)) {
            XWPFDocument xwpfDocument;
            FileInputStream fileInputStream = new FileInputStream(file);
            document = xwpfDocument = new XWPFDocument((InputStream)fileInputStream);
        } else if (BcStringUtil.equalsIgnoreCase(EXTENTION_docx, extention)) {
            FileInputStream fileInputStream = new FileInputStream(file);
            HWPFDocument hwpfDocument = new HWPFDocument((InputStream)fileInputStream);
            document = hwpfDocument;
        }
        return document;
    }

    public static void write(XWPFDocument xwpfDocument, File file) throws Exception {
        BcLogUtil.info("write=" + file.getPath());
        BcFileUtil.makeParent(file);
        xwpfDocument.write((OutputStream)new FileOutputStream(file));
    }

    public static void replaceText(XWPFDocument xwpfDocument, Map<String, String> replaceMap) throws Exception {
        PoiWordUtil.replaceText(xwpfDocument.getParagraphs(), replaceMap);
        PoiWordUtil.replaceText_tableList(xwpfDocument.getTables(), replaceMap);
    }

    public static void replaceText(XWPFDocument xwpfDocument, CharSequence strFrom, CharSequence strTo) throws Exception {
        HashMap<String, String> replaceMap = new HashMap<String, String>();
        replaceMap.put(strFrom.toString(), BcStringUtil.toNotNull(strTo));
        PoiWordUtil.replaceText(xwpfDocument, replaceMap);
    }

    public static long replaceText(List<XWPFParagraph> xwpfParagraphs, Map<String, String> replaceMap) throws Exception {
        long count = 0L;
        for (XWPFParagraph paragraph : xwpfParagraphs) {
            List xwpfRunList = paragraph.getRuns();
            for (Map.Entry<String, String> replPair : replaceMap.entrySet()) {
                String replaced;
                String find = replPair.getKey();
                String repl = replPair.getValue();
                TextSegment textSegment = paragraph.searchText(find, new PositionInParagraph());
                if (textSegment == null) continue;
                ++count;
                if (textSegment.getBeginRun() == textSegment.getEndRun()) {
                    XWPFRun xwpfRun = (XWPFRun)xwpfRunList.get(textSegment.getBeginRun());
                    String runText = xwpfRun.getText(xwpfRun.getTextPosition());
                    replaced = runText.replace(find, repl);
                    xwpfRun.setText(replaced, 0);
                    continue;
                }
                StringBuilder sb = new StringBuilder();
                int runPos = textSegment.getBeginRun();
                while (runPos <= textSegment.getEndRun()) {
                    XWPFRun xwpfRun = (XWPFRun)xwpfRunList.get(runPos);
                    sb.append(xwpfRun.getText(xwpfRun.getTextPosition()));
                    ++runPos;
                }
                String connectedRuns = sb.toString();
                replaced = connectedRuns.replace(find, repl);
                XWPFRun partOne = (XWPFRun)xwpfRunList.get(textSegment.getBeginRun());
                partOne.setText(replaced, 0);
                int runPos2 = textSegment.getBeginRun() + 1;
                while (runPos2 <= textSegment.getEndRun()) {
                    XWPFRun partNext = (XWPFRun)xwpfRunList.get(runPos2);
                    partNext.setText("", 0);
                    ++runPos2;
                }
            }
        }
        return count;
    }

    public static void replaceText_tableList(List<XWPFTable> xwpfTableList, Map<String, String> replaceMap) throws Exception {
        int i = 0;
        while (i < xwpfTableList.size()) {
            XWPFTable xwpfTable = xwpfTableList.get(i);
            PoiWordUtil.replaceText(xwpfTable, replaceMap);
            ++i;
        }
    }

    public static void replaceText(XWPFTable xwpfTable, Map<String, String> replaceMap) throws Exception {
        int i = 0;
        while (i < xwpfTable.getNumberOfRows()) {
            XWPFTableRow xwpfTableRow = xwpfTable.getRow(i);
            PoiWordUtil.replaceText(xwpfTableRow, replaceMap);
            ++i;
        }
    }

    public static void replaceText(XWPFTableRow xwpfTableRow, Map<String, String> replaceMap) throws Exception {
        List xwpfTableCellList = xwpfTableRow.getTableCells();
        int i = 0;
        while (i < xwpfTableCellList.size()) {
            XWPFTableCell xwpfTableCell = (XWPFTableCell)xwpfTableCellList.get(i);
            PoiWordUtil.replaceText(xwpfTableCell, replaceMap);
            ++i;
        }
    }

    public static void replaceText(XWPFTableCell xwpfTableCell, Map<String, String> replaceMap) throws Exception {
        PoiWordUtil.replaceText(xwpfTableCell.getParagraphs(), replaceMap);
    }

    public static void testForHWPFDocument(HWPFDocument hwpfDocument) throws Exception {
        Range range = hwpfDocument.getRange();
        int i = 0;
        while (i < range.numSections()) {
            Section section = range.getSection(i);
            System.out.println("Section : " + i);
            int j = 0;
            while (j < section.numParagraphs()) {
                Paragraph paragraph = section.getParagraph(j);
                System.out.println("Paragraph : " + j);
                int n = 0;
                while (n < paragraph.numCharacterRuns()) {
                    CharacterRun cRun = paragraph.getCharacterRun(n);
                    System.out.print("ChatactorRun : " + n + " ");
                    String line = cRun.text();
                    System.out.println(line);
                    ++n;
                }
                ++j;
            }
            ++i;
        }
    }
}

