/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.fx.tree;

import ext.base.util.BcCompareUtil;
import ext.lib.fx.tree.FxTreeItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javafx.collections.ObservableList;
import javafx.scene.control.MultipleSelectionModel;
import javafx.scene.control.TreeItem;

public final class FxTreeUtil {
    private FxTreeUtil() {
    }

    public static <T> List<TreeItem<T>> createListToRoot(TreeItem<T> treeItem) throws Exception {
        ArrayList<TreeItem<T>> treeItemList = new ArrayList<TreeItem<T>>();
        TreeItem treeItemWk = treeItem;
        while (true) {
            treeItemList.add(treeItemWk);
            TreeItem parentTreeItem = treeItemWk.getParent();
            if (parentTreeItem == null) break;
            treeItemWk = parentTreeItem;
        }
        return treeItemList;
    }

    public static <T> List<TreeItem<T>> createDescendantList(TreeItem<T> treeItem, boolean includeSelf) throws Exception {
        ArrayList<TreeItem<T>> treeItemList = new ArrayList<TreeItem<T>>();
        if (includeSelf) {
            treeItemList.add(treeItem);
        }
        FxTreeUtil.createDescendantList(treeItem, treeItemList);
        return treeItemList;
    }

    public static <T> void createDescendantList(TreeItem<T> treeItem, List<TreeItem<T>> treeItemList) throws Exception {
        int i = 0;
        while (i < treeItem.getChildren().size()) {
            TreeItem childTreeItem = (TreeItem)treeItem.getChildren().get(i);
            treeItemList.add(childTreeItem);
            FxTreeUtil.createDescendantList(childTreeItem, treeItemList);
            ++i;
        }
    }

    public static void setExpandedToRootFx(TreeItem treeItem, boolean isExpanded) throws Exception {
        List treeItemList = FxTreeUtil.createListToRoot(treeItem);
        int i = 0;
        while (i < treeItemList.size()) {
            TreeItem wkTreeItem = treeItemList.get(treeItemList.size() - i - 1);
            if (wkTreeItem.isExpanded() != isExpanded) {
                wkTreeItem.setExpanded(isExpanded);
            }
            ++i;
        }
    }

    public static boolean isAncestor(TreeItem ancestorTreeItem, TreeItem treeItem) throws Exception {
        TreeItem parentTreeItem;
        TreeItem treeItemWk = treeItem;
        while ((parentTreeItem = treeItemWk.getParent()) != null) {
            if (parentTreeItem == ancestorTreeItem) {
                return true;
            }
            treeItemWk = parentTreeItem;
        }
        return false;
    }

    public static <T> List<TreeItem<T>> findByValue(List<? extends TreeItem> treeItemList, List valueList, Comparator comparator) throws Exception {
        ArrayList<TreeItem<T>> selectedTreeItemList = new ArrayList<TreeItem<T>>();
        FxTreeUtil.findByValue(treeItemList, valueList, comparator, selectedTreeItemList);
        return selectedTreeItemList;
    }

    public static <T> void findByValue(List<? extends TreeItem> treeItemList, List valueList, Comparator comparator, List<TreeItem<T>> selectedTreeItemList) throws Exception {
        for (TreeItem treeItem : treeItemList) {
            int j = 0;
            while (j < valueList.size()) {
                Object value = valueList.get(j);
                if (comparator.compare(treeItem.getValue(), value) == BcCompareUtil.Comparison.equals.value && !selectedTreeItemList.contains(treeItem)) {
                    selectedTreeItemList.add(treeItem);
                }
                ++j;
            }
            FxTreeUtil.findByValue((List<? extends TreeItem>)treeItem.getChildren(), valueList, comparator, selectedTreeItemList);
        }
    }

    public static <T> void selectTreeItems(List<? extends TreeItem> treeItemList, List valueList, Comparator comparator, MultipleSelectionModel<TreeItem<T>> selectionModel) throws Exception {
        List<TreeItem<T>> findTreeItemList = FxTreeUtil.findByValue(treeItemList, valueList, comparator);
        int i = 0;
        while (i < findTreeItemList.size()) {
            TreeItem<T> treeItem = findTreeItemList.get(i);
            selectionModel.select(treeItem);
            FxTreeUtil.setExpandedToRootFx(treeItem, true);
            ++i;
        }
    }

    public static boolean isSameParent(List<? extends TreeItem> treeItemList) throws Exception {
        TreeItem[] treeItems = treeItemList.toArray(new TreeItem[0]);
        TreeItem parentTreeItem = null;
        int i = 0;
        while (i < treeItems.length) {
            TreeItem treeItem = treeItems[i];
            if (parentTreeItem == null) {
                parentTreeItem = treeItem.getParent();
            } else if (parentTreeItem != treeItem.getParent()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static TreeItem findByValue_2(TreeItem parentTreeItem, Object value, Comparator comparator) throws Exception {
        ObservableList treeItemList = parentTreeItem.getChildren();
        int i = 0;
        while (i < treeItemList.size()) {
            TreeItem treeItem = (TreeItem)treeItemList.get(i);
            if (comparator.compare(treeItem, value) == BcCompareUtil.Comparison.equals.value) {
                return treeItem;
            }
            ++i;
        }
        return null;
    }

    public static TreeItem findByValue_3(TreeItem treeItem, List valueList, Comparator comparator) throws Exception {
        TreeItem treeItem1 = treeItem;
        int i = 0;
        while (i < valueList.size()) {
            Object value = valueList.get(i);
            TreeItem treeItem2 = FxTreeUtil.findByValue_2(treeItem1, value, comparator);
            if (treeItem2 == null) {
                treeItem1 = null;
                break;
            }
            treeItem1 = treeItem2;
            ++i;
        }
        return treeItem1;
    }

    public static <T> void getTreeItemListByHashCode(TreeItem<T> treeItem, int hashCode, List<TreeItem<T>> treeItemList) throws Exception {
        if (treeItem.hashCode() == hashCode) {
            treeItemList.add(treeItem);
        }
        int i = 0;
        while (i < treeItem.getChildren().size()) {
            TreeItem childTreeItem = (TreeItem)treeItem.getChildren().get(i);
            FxTreeUtil.getTreeItemListByHashCode(childTreeItem, hashCode, treeItemList);
            ++i;
        }
    }

    public static <T> List<TreeItem<T>> getTreeItemListByHashCode(TreeItem<T> treeItem, int hashCode) throws Exception {
        ArrayList<TreeItem<T>> treeItemList = new ArrayList<TreeItem<T>>();
        FxTreeUtil.getTreeItemListByHashCode(treeItem, hashCode, treeItemList);
        return treeItemList;
    }

    public static FxTreeItem cloneSimple(FxTreeItem treeItem1, FxTreeItem parentTreeItem) throws Exception {
        FxTreeItem newTreeItem = new FxTreeItem();
        newTreeItem.setValue(treeItem1.getValue());
        if (parentTreeItem != null) {
            parentTreeItem.getChildren().add(newTreeItem);
        }
        int i = 0;
        while (i < treeItem1.getChildren().size()) {
            FxTreeItem childTreeItem = (FxTreeItem)((Object)treeItem1.getChildren().get(i));
            FxTreeUtil.cloneSimple(childTreeItem, newTreeItem);
            ++i;
        }
        return newTreeItem;
    }

    public static <T> List<TreeItem<T>> extractParent(Collection<TreeItem<T>> treeItemCollection, TreeItem<T> treeItemTop) throws Exception {
        ArrayList<TreeItem<T>> treeItemList = new ArrayList<TreeItem<T>>();
        for (TreeItem<T> treeItem : treeItemCollection) {
            if (treeItemTop != null && treeItem.hashCode() == treeItemTop.hashCode()) {
                treeItemList.addAll((Collection<TreeItem<T>>)treeItemTop.getChildren());
                continue;
            }
            if (FxTreeUtil.existsParent(treeItemCollection, treeItem, treeItemTop) || treeItemList.contains(treeItem)) continue;
            treeItemList.add(treeItem);
        }
        return treeItemList;
    }

    public static <T> boolean existsParent(Collection<TreeItem<T>> treeItemCollection, TreeItem<T> treeItem1, TreeItem<T> treeItemTop) throws Exception {
        TreeItem parentTtreeItem = treeItem1.getParent();
        if (parentTtreeItem == null) {
            return false;
        }
        if (treeItemTop != null && parentTtreeItem.hashCode() == treeItemTop.hashCode()) {
            return false;
        }
        for (TreeItem<T> treeItem2 : treeItemCollection) {
            if (treeItem2.hashCode() != parentTtreeItem.hashCode()) continue;
            return true;
        }
        return FxTreeUtil.existsParent(treeItemCollection, parentTtreeItem, treeItemTop);
    }

    public static <T> List<Object> getValueList(Collection<TreeItem<T>> treeItemCollection) throws Exception {
        ArrayList<Object> valueList = new ArrayList<Object>();
        for (TreeItem<T> treeItem : treeItemCollection) {
            valueList.add(treeItem.getValue());
        }
        return valueList;
    }
}

