/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.fx.chart;

import ext.lib.fx.chart.FxChartContext;
import ext.lib.fx.chart.FxChartUnit;
import javafx.collections.ObservableList;
import javafx.scene.chart.XYChart;
import javafx.scene.paint.Color;

public class FxChartUtil {
    static Color color1 = Color.web((String)"#cc99ff", (double)1.0);
    static Color color2 = Color.web((String)"#99cccc", (double)1.0);
    static Color[] colors = new Color[]{color1, color2};

    private FxChartUtil() throws Exception {
    }

    public static double getMaxValue(XYChart.Series<String, Number> series) throws Exception {
        double maxValue = 0.0;
        int i = 0;
        while (i < series.getData().size()) {
            XYChart.Data chartData = (XYChart.Data)series.getData().get(i);
            maxValue = Math.max(maxValue, ((Number)chartData.getYValue()).doubleValue());
            ++i;
        }
        return maxValue;
    }

    public static double getMaxValue(ObservableList<XYChart.Series<String, Number>> seriesList) throws Exception {
        double maxValue = 0.0;
        int i = 0;
        while (i < seriesList.size()) {
            XYChart.Series series = (XYChart.Series)seriesList.get(i);
            maxValue = Math.max(maxValue, FxChartUtil.getMaxValue((XYChart.Series<String, Number>)series));
            ++i;
        }
        return maxValue;
    }

    public static FxChartContext cretaeDefaultChartContext() throws Exception {
        FxChartContext chartContext = new FxChartContext();
        chartContext.xAxisType = 11;
        chartContext.yAxisType = 21;
        return chartContext;
    }

    public static void calcUnit(double maxValue, double barLengthMax, FxChartUnit chartUnit) throws Exception {
        chartUnit.pix = 2.0;
        chartUnit.tickCount = (int)Math.floor(barLengthMax / chartUnit.pix);
        if ((double)chartUnit.tickCount > maxValue) {
            chartUnit.pix = barLengthMax / maxValue;
            chartUnit.tickCount = (int)Math.floor(barLengthMax / chartUnit.pix);
        } else {
            int cfr_ignored_0 = chartUnit.tickCount;
        }
        chartUnit.barLength = chartUnit.pix * (double)chartUnit.tickCount;
        chartUnit.tickUnit = maxValue / (double)chartUnit.tickCount;
        chartUnit.tickUnit = Math.ceil(chartUnit.tickUnit);
        chartUnit.tmpMax = chartUnit.tickUnit * (double)chartUnit.tickCount;
    }

    public static FxChartUnit getUnit(double maxValue, double barSize) throws Exception {
        FxChartUnit chartUnit = new FxChartUnit();
        FxChartUtil.calcUnit(maxValue, barSize, chartUnit);
        return chartUnit;
    }

    public static double toZ(FxChartUnit chartUnit, int tickNo) throws Exception {
        double res = chartUnit.barLength / (double)chartUnit.tickCount * (double)tickNo;
        return res;
    }

    public static Color getBarColor(int idx) throws Exception {
        return colors[idx];
    }
}

