/*
 * Decompiled with CFR 0.152.
 */
package ext.base.event;

import ext.base.event.BcEventHandlerList;
import ext.base.log.BcLogUtil;
import ext.base.log.BcLoggableObject;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Semaphore;

public class BcEventManager
extends BcLoggableObject {
    private Semaphore semaphore = new Semaphore(1);
    private Map<Object, BcEventHandlerList> listMap = new HashMap<Object, BcEventHandlerList>();

    public static BcEventManager getInstance() {
        return SingletonHolder.instance;
    }

    public BcEventHandlerList getEventHandlerList(Object eventType, boolean doCleate) throws Exception {
        this.semaphore.acquire();
        BcEventHandlerList eventHandlerList = null;
        try {
            try {
                eventHandlerList = this.listMap.get(eventType);
                if (eventHandlerList == null && doCleate) {
                    eventHandlerList = new BcEventHandlerList();
                    this.listMap.put(eventType, eventHandlerList);
                }
            }
            catch (Exception ex) {
                BcLogUtil.error(ex);
                this.semaphore.release();
            }
        }
        finally {
            this.semaphore.release();
        }
        return eventHandlerList;
    }

    public BcEventHandlerList getEventHandlerList(Object eventType) throws Exception {
        return this.getEventHandlerList(eventType, true);
    }

    public BcEventHandlerList removeEventHandlerList(Object eventType) throws Exception {
        return this.listMap.remove(eventType);
    }

    private static final class SingletonHolder {
        private static final BcEventManager instance = new BcEventManager();

        private SingletonHolder() {
        }
    }
}

