/*
 * Decompiled with CFR 0.152.
 */
package ext.appfw.common;

import ext.appfw.common.AfbApplication;
import ext.appfw.common.AfbShutdownTask;
import ext.base.log.BcLogUtil;
import java.util.ArrayList;
import java.util.List;

public class AfbShutdownManager
extends Thread {
    private List<AfbShutdownTask> shutdownTaskList = new ArrayList<AfbShutdownTask>();
    private int shutdownNoMax;
    private boolean isShutdown;

    private AfbShutdownManager() {
        Runtime.getRuntime().addShutdownHook(this);
    }

    public static AfbShutdownManager getInstance() {
        return SingletonHolder.instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addShutdownTask(AfbShutdownTask shutdownTask) {
        List<AfbShutdownTask> list = this.shutdownTaskList;
        synchronized (list) {
            BcLogUtil.info("addShutdownTask:" + shutdownTask.getClass().getName());
            if (shutdownTask.getPriorityNo() > this.shutdownNoMax) {
                this.shutdownNoMax = shutdownTask.getPriorityNo();
            }
            this.shutdownTaskList.add(shutdownTask);
        }
    }

    @Override
    public void run() {
        BcLogUtil.info("Shutdown started. thread=" + Thread.currentThread().getName());
        try {
            this.shutdown();
        }
        catch (Exception ex) {
            BcLogUtil.error(ex);
        }
    }

    public void shutdown() throws Exception {
        if (this.isShutdown) {
            return;
        }
        this.isShutdown = true;
        int i = 0;
        while (i <= this.shutdownNoMax) {
            int j = 0;
            while (j < this.shutdownTaskList.size()) {
                AfbShutdownTask shutdownTask = this.shutdownTaskList.get(j);
                if (shutdownTask.getPriorityNo() == i) {
                    BcLogUtil.info(BcLogUtil.createLabel("shutdown[" + i + "]:" + shutdownTask.getClass().getName(), "=", 8, 80));
                    try {
                        shutdownTask.shutdown(AfbApplication.getInstance());
                    }
                    catch (Exception ex) {
                        BcLogUtil.error(ex);
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    /* synthetic */ AfbShutdownManager(AfbShutdownManager afbShutdownManager) {
        this();
    }

    private static final class SingletonHolder {
        private static final AfbShutdownManager instance = new AfbShutdownManager(null);

        private SingletonHolder() {
        }
    }
}

