/*
 * Decompiled with CFR 0.152.
 */
package jmapps.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Panel;

public class JMPanel
extends Panel {
    private static final int TYPE_EMPTY = 1;
    private static final int TYPE_ETCHED = 2;
    private static final int TYPE_RAISED = 3;
    private static final int TYPE_LOWERED = 4;
    private Insets insetsBorder = new Insets(0, 0, 0, 0);
    private int nType = 1;

    public JMPanel() {
    }

    public JMPanel(LayoutManager managerLayout) {
        super(managerLayout);
    }

    public Insets getInsets() {
        return this.insetsBorder;
    }

    public void doLayout() {
        super.doLayout();
        int nCount = this.getComponentCount();
        int i2 = 0;
        while (i2 < nCount) {
            Component component = this.getComponent(i2);
            if (component != null && component instanceof Container) {
                ((Container)component).doLayout();
            }
            ++i2;
        }
    }

    public void setEmptyBorder(int nLeft, int nTop, int nRight, int nBottom) {
        this.insetsBorder.left = nLeft;
        this.insetsBorder.top = nTop;
        this.insetsBorder.right = nRight;
        this.insetsBorder.bottom = nBottom;
        this.nType = 1;
    }

    public void setEtchedBorder() {
        this.insetsBorder.left = 8;
        this.insetsBorder.top = 8;
        this.insetsBorder.right = 8;
        this.insetsBorder.bottom = 8;
        this.nType = 2;
    }

    public void setRaisedBorder() {
        this.insetsBorder.left = 2;
        this.insetsBorder.top = 2;
        this.insetsBorder.right = 2;
        this.insetsBorder.bottom = 2;
        this.nType = 3;
    }

    public void setLoweredBorder() {
        this.insetsBorder.left = 1;
        this.insetsBorder.top = 1;
        this.insetsBorder.right = 1;
        this.insetsBorder.bottom = 1;
        this.nType = 4;
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        Color colorBg = this.getBackground();
        Color colorTs = colorBg.brighter();
        Color colorBs = colorBg.darker();
        Dimension dim = this.getSize();
        if (this.nType == 2) {
            graphics.setColor(colorBs);
            graphics.drawRect(0, 0, dim.width - 2, dim.height - 2);
            graphics.setColor(colorTs);
            graphics.drawRect(1, 1, dim.width - 2, dim.height - 2);
        } else if (this.nType == 3) {
            graphics.setColor(colorTs);
            graphics.drawLine(0, 0, dim.width - 1, 0);
            graphics.drawLine(1, 1, dim.width - 2, 1);
            graphics.drawLine(0, 0, 0, dim.height - 1);
            graphics.drawLine(1, 1, 1, dim.height - 2);
            graphics.setColor(colorBs);
            graphics.drawLine(2, dim.height - 2, dim.width - 1, dim.height - 2);
            graphics.drawLine(1, dim.height - 1, dim.width - 2, dim.height - 1);
            graphics.drawLine(dim.width - 2, 2, dim.width - 2, dim.height - 2);
            graphics.drawLine(dim.width - 1, 1, dim.width - 1, dim.height - 1);
        } else if (this.nType == 4) {
            graphics.setColor(colorBs);
            graphics.drawLine(0, 0, dim.width - 1, 0);
            graphics.drawLine(0, 0, 0, dim.height - 1);
            graphics.setColor(colorTs);
            graphics.drawLine(1, dim.height - 1, dim.width - 2, dim.height - 1);
            graphics.drawLine(dim.width - 1, 1, dim.width - 1, dim.height - 1);
        }
    }

    protected Frame getFrame() {
        Frame frame = null;
        Container comp = this;
        while (comp != null) {
            if (comp instanceof Frame) {
                frame = (Frame)comp;
                break;
            }
            comp = comp.getParent();
        }
        return frame;
    }
}

