/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.model.dynabeans;

import java.util.Locale;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.jxpath.ri.QName;
import org.apache.commons.jxpath.ri.model.NodePointer;
import org.apache.commons.jxpath.ri.model.beans.PropertyOwnerPointer;
import org.apache.commons.jxpath.ri.model.beans.PropertyPointer;
import org.apache.commons.jxpath.ri.model.dynabeans.DynaBeanPropertyPointer;

public class DynaBeanPointer
extends PropertyOwnerPointer {
    private static final long serialVersionUID = -9135052498044877965L;
    private QName name;
    private DynaBean dynaBean;

    public DynaBeanPointer(QName name, DynaBean dynaBean, Locale locale) {
        super(null, locale);
        this.name = name;
        this.dynaBean = dynaBean;
    }

    public DynaBeanPointer(NodePointer parent, QName name, DynaBean dynaBean) {
        super(parent);
        this.name = name;
        this.dynaBean = dynaBean;
    }

    @Override
    public PropertyPointer getPropertyPointer() {
        return new DynaBeanPropertyPointer((NodePointer)this, this.dynaBean);
    }

    @Override
    public QName getName() {
        return this.name;
    }

    @Override
    public Object getBaseValue() {
        return this.dynaBean;
    }

    @Override
    public Object getImmediateNode() {
        return this.dynaBean;
    }

    @Override
    public boolean isCollection() {
        return false;
    }

    @Override
    public int getLength() {
        return 1;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    public int hashCode() {
        return this.name == null ? 0 : this.name.hashCode();
    }

    public boolean equals(Object object) {
        int iOther;
        if (object == this) {
            return true;
        }
        if (!(object instanceof DynaBeanPointer)) {
            return false;
        }
        DynaBeanPointer other = (DynaBeanPointer)object;
        if (!DynaBeanPointer.equalObjects(this.parent, other.parent) || !DynaBeanPointer.equalObjects(this.name, other.name)) {
            return false;
        }
        int iThis = this.index == Integer.MIN_VALUE ? 0 : this.index;
        int n = iOther = other.index == Integer.MIN_VALUE ? 0 : other.index;
        return iThis == iOther && this.dynaBean == other.dynaBean;
    }

    @Override
    public String asPath() {
        return this.parent == null ? "/" : super.asPath();
    }

    private static boolean equalObjects(Object o1, Object o2) {
        return o1 == o2 || o1 != null && o1.equals(o2);
    }
}

