/*
 * Decompiled with CFR 0.152.
 */
package ext.scf6.swg;

import ext.appfw.common.AfbApplication;
import ext.appfw.common.AfbApplicationContext;
import ext.base.log.BcLogUtil;
import ext.base.thread.BcMonitor;
import ext.base.util.BcWords;
import ext.lib.awt.AwtImageHelper;
import ext.lib.fx.FxPlatform;
import ext.lib.swg.SwgBorderPanel;
import ext.lib.swg.SwgFrame;
import ext.lib.swg.SwgUtil;
import ext.libx.swg.SwgxDesktopBase;
import java.awt.Component;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public abstract class JswgAbstractDesktopPanel
extends SwgBorderPanel {
    private static final long serialVersionUID = 6783894068142516513L;
    protected TrayIcon trayIcon;
    protected PopupMenu popupMenu;
    protected MenuItem showMenuItem;
    protected MenuItem exitMenuItem;
    protected JFrame frame;

    protected JswgAbstractDesktopPanel() {
    }

    public JFrame getMainFrame() {
        return this.frame;
    }

    public void initComponent() throws Exception {
        this.setBorderSize(0, 0, 0, 0);
        Component component = this.createBasePanel();
        this.add(component, "Center");
        this.setTrayIcon();
    }

    protected void setTrayIcon() throws Exception {
        this.trayIcon = new TrayIcon(AwtImageHelper.getWindowIconImage());
        this.trayIcon.setImageAutoSize(true);
        this.trayIcon.setToolTip(this.getTitle());
        this.trayIcon.addActionListener(this.actionListener);
        this.popupMenu = new PopupMenu();
        this.trayIcon.setPopupMenu(this.popupMenu);
        this.showMenuItem = new MenuItem(BcWords.getInstance().display);
        this.showMenuItem.addActionListener(this.actionListener);
        this.popupMenu.add(this.showMenuItem);
        this.exitMenuItem = new MenuItem(BcWords.getInstance().end);
        this.exitMenuItem.addActionListener(this.actionListener);
        this.popupMenu.add(this.exitMenuItem);
    }

    @Override
    protected void actionPerformed2(ActionEvent ev) throws Exception {
        if (ev.getSource() == this.trayIcon || ev.getSource() == this.showMenuItem) {
            SystemTray.getSystemTray().remove(this.trayIcon);
            this.frame.setVisible(true);
            this.frame.setExtendedState(0);
            this.frame.toFront();
        } else if (ev.getSource() == this.exitMenuItem) {
            this.confirmExit();
        }
    }

    public void confirmExit() {
        String msg = String.valueOf(AfbApplication.getInstance().getApplicationContext().appName) + "\u3092\u7d42\u4e86\u3057\u307e\u3059\u304b\uff1f";
        if (JOptionPane.showConfirmDialog(this, msg, BcWords.getInstance().confirm, 0) == 0) {
            AfbApplication.getInstance().exit();
        }
    }

    public JFrame createMainFrame() throws Exception {
        SwgFrame frame = SwgxDesktopBase.getInstance().getMainFrame();
        frame.getContentPane().add((Component)this, "Center");
        frame.setDefaultCloseOperation(0);
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent ev) {
                JswgAbstractDesktopPanel.this.windowOpened(ev);
            }

            @Override
            public void windowClosing(WindowEvent ev) {
                JswgAbstractDesktopPanel.this.windowClosing(ev);
            }

            @Override
            public void windowIconified(WindowEvent ev) {
                JswgAbstractDesktopPanel.this.windowIconified(ev);
            }
        });
        frame.setTitle(this.getTitle());
        frame.setIconImage(AwtImageHelper.getWindowIconImage());
        SwgUtil.setCenter(frame, 1.0);
        return frame;
    }

    public void open(BcMonitor monitor) throws Exception {
        monitor.lock();
        if (this.frame != null) {
            if (!this.frame.isVisible()) {
                this.frame.setVisible(true);
            }
            this.frame.toFront();
            return;
        }
        this.frame = this.createMainFrame();
        this.initComponent();
        this.frame.setVisible(true);
    }

    public void windowOpened(WindowEvent ev) {
        FxPlatform.runLater(new Runnable(){

            @Override
            public void run() {
            }
        });
    }

    public void windowClosing(WindowEvent ev) {
        this.confirmExit();
    }

    public void windowIconified(WindowEvent ev) {
        try {
            this.frame.setVisible(false);
            SystemTray.getSystemTray().add(this.trayIcon);
        }
        catch (Exception ex) {
            BcLogUtil.error(ex);
        }
    }

    public String getTitle() throws Exception {
        AfbApplicationContext applicationContext = AfbApplication.getInstance().getApplicationContext();
        String title = String.valueOf(applicationContext.appName) + " " + applicationContext.version;
        return title;
    }

    public abstract Component createBasePanel() throws Exception;
}

