/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xdts.server;

import ext.base.core.BcConstants;
import ext.base.core.BcStringUtil;
import ext.base.io.BcFileUtil;
import ext.base.log.BcLogUtil;
import ext.base.log.BcLoggableObject;
import ext.base.log.BcLogger;
import ext.base.mmd.MmdField;
import ext.base.mmd.MmdIndex;
import ext.base.mmd.MmdIndexElement;
import ext.base.mmd.MmdModel;
import ext.base.table.BcTableColumnModel;
import ext.base.table.BcTableModel;
import ext.lib.datasource.DtsSession;
import ext.lib.datasource.util.DtsWordManager;
import ext.lib.datasource.util.DtsWordManagerImpl;
import ext.lib.datasource.util.ScfMmdServerUtil;
import ext.lib.sql.SqlConnection;
import ext.lib.sql.SqlDefinitionCondition;
import ext.lib.sql.SqlResultSet;
import ext.lib.sql.SqlStatement;
import ext.lib.sql.SqlUtil;
import ext.lib.sql.context.SqlContext;
import ext.module.xdts.common.XdtsConstants;
import ext.module.xdts.common.XdtsUtil;
import ext.module.xdts.model.XdtsProcessCondition;
import ext.module.xdts.model.XdtsSchemaObject;
import ext.module.xdts.server.XsysCreateInsertSqlTask;
import ext.module.xdts.server.XsysResultSetCopyTask;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;

public class XdtsServerUtil
extends BcLoggableObject {
    private XdtsServerUtil() {
    }

    public static XdtsServerUtil getInstance() {
        return SingletonHolder.instance;
    }

    public void copyRecords(SqlConnection sqlConn1, SqlConnection sqlConn2, Collection<XdtsSchemaObject> schemaObjectCollection, XdtsProcessCondition processCondition, BcLogger logger) throws Exception {
        logger.debug("commitMode=" + (Object)((Object)processCondition.commitMode));
        File errorFile = new File(processCondition.errorFilePath);
        logger.info("errorFile=" + errorFile.getPath());
        BcFileUtil.makeParent(errorFile);
        OutputStreamWriter errorWriter = null;
        errorWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(errorFile, false), BcConstants.charset.name());
        if (processCondition.commitMode == XdtsConstants.CommitMode.AUTO) {
            sqlConn2.setAutoCommit(true);
        }
        this.copyRecords_L2(sqlConn1, sqlConn2, schemaObjectCollection, processCondition, errorWriter, logger);
        if (processCondition.commitMode == XdtsConstants.CommitMode.FINAL) {
            sqlConn2.commit();
        }
        sqlConn2.setAutoCommit(false);
    }

    public void copyRecords_L2(SqlConnection sqlConn1, SqlConnection sqlConn2, Collection<XdtsSchemaObject> schemaObjectCollection, XdtsProcessCondition processCondition, Writer errorWriter, BcLogger logger) throws Exception {
        for (XdtsSchemaObject schemaObject : schemaObjectCollection) {
            this.copyRecords_L3(processCondition, sqlConn1, sqlConn2, schemaObject, errorWriter, logger);
            if (processCondition.commitMode != XdtsConstants.CommitMode.TABLE) continue;
            sqlConn2.commit();
        }
    }

    public void copyRecords_L3(XdtsProcessCondition processCondition, SqlConnection sqlConn1, SqlConnection sqlConn2, XdtsSchemaObject schemaObject, Writer errorWriter, BcLogger logger) throws Exception {
        SqlContext sqlContext1 = sqlConn1.getSqlContext();
        MmdModel mmdModel1 = sqlContext1.createModelMetaData(sqlConn1, schemaObject.name1);
        StringBuilder query = new StringBuilder();
        query.append(sqlContext1.createSelectQuery(mmdModel1));
        if (!BcStringUtil.isEmpty(processCondition.query)) {
            query.append(" WHERE ");
            query.append(processCondition.query);
        }
        SqlStatement stmt = sqlConn1.createStatement();
        SqlResultSet rs = stmt.executeQuery(query.toString());
        this.copyRecords_L4(rs, processCondition, sqlConn2, mmdModel1, errorWriter, logger);
    }

    public void copyRecords_L4(SqlResultSet rs, XdtsProcessCondition processCondition, SqlConnection sqlConn2, MmdModel mmdModel1, Writer errorWriter, BcLogger logger) throws Exception {
        SqlContext sqlContext1 = rs.getStatement().getSqlContext();
        SqlContext sqlContext2 = sqlConn2.getSqlContext();
        MmdModel mmdModel2 = this.createTablePre(sqlContext1, mmdModel1, sqlContext2, processCondition.definitionCondition);
        boolean existTable = this.dropTable(sqlConn2, mmdModel2.tableName, processCondition.recreateTable, processCondition.truncateTable, processCondition.deleteRecord);
        if (!existTable) {
            this.createTable(processCondition, mmdModel2, sqlConn2, errorWriter);
        }
        this.copyRecords_L5(rs, sqlConn2, mmdModel2, processCondition.ignoreException, errorWriter, logger);
        if (processCondition.recreateTable) {
            this.createIndex(sqlConn2, mmdModel2, processCondition, errorWriter);
        }
    }

    public int copyRecords_L5(SqlResultSet rs, SqlConnection sqlConn2, MmdModel mmdModel2, boolean ignoreException, Writer errorWriter, BcLogger logger) throws Exception {
        XsysResultSetCopyTask resultSetCopyTask = new XsysResultSetCopyTask();
        resultSetCopyTask.setLogger(logger);
        resultSetCopyTask.setResultSet(rs);
        resultSetCopyTask.setCondition(sqlConn2, mmdModel2, ignoreException, errorWriter);
        resultSetCopyTask.taskProcess();
        return resultSetCopyTask.updateCount;
    }

    public MmdModel createTablePre(SqlContext sqlContext1, MmdModel mmdModel1, SqlContext sqlContext2, SqlDefinitionCondition definitionCondition) throws Exception {
        MmdModel mmdModel2 = sqlContext1.convertModelMetaData(mmdModel1, sqlContext2);
        this.removeField(sqlContext2, mmdModel2, definitionCondition, true, this.getLogger());
        return mmdModel2;
    }

    public boolean dropTable(SqlConnection sqlConn2, String tableName, boolean recreateTable, boolean truncateTable, boolean deleteRecord) throws Exception {
        SqlContext sqlContext2 = sqlConn2.getSqlContext();
        boolean existTable = sqlContext2.existTable(sqlConn2, tableName);
        this.getLogger().info("existTable=" + existTable);
        boolean doCreateTable = false;
        if (!existTable) {
            return existTable;
        }
        if (recreateTable) {
            this.getLogger().info("\u65e2\u5b58\u30c6\u30fc\u30d6\u30eb\u3092\u524a\u9664\u4e2d... \u30c6\u30fc\u30d6\u30eb\u540d=" + tableName);
            int cnt = sqlContext2.dropTable(sqlConn2, tableName);
            return false;
        }
        if (truncateTable) {
            this.getLogger().info(String.format("\u8907\u5199\u5148\u30c6\u30fc\u30d6\u30eb '%s' \u306eTRUNCATE\u4e2d...", tableName));
            int cnt = sqlContext2.truncateTable(sqlConn2, tableName);
            this.getLogger().info("\u4ef6\u6570=" + cnt);
        } else if (deleteRecord) {
            this.getLogger().info(String.format("\u8907\u5199\u5148\u30c6\u30fc\u30d6\u30eb '%s' \u306e\u30ec\u30b3\u30fc\u30c9\u3092\u524a\u9664\u4e2d...", tableName));
            int cnt = sqlContext2.deleteAllRow(sqlConn2, tableName);
            this.getLogger().info("\u4ef6\u6570=" + cnt);
        }
        return existTable;
    }

    public void createTable(XdtsProcessCondition processCondition, MmdModel mmdModel2, SqlConnection sqlConn2, Writer errorWriter) throws Exception {
        SqlContext sqlContext2 = sqlConn2.getSqlContext();
        this.getLogger().info("\u30c6\u30fc\u30d6\u30eb\u3092\u4f5c\u6210\u4e2d... \u30c6\u30fc\u30d6\u30eb\u540d=" + mmdModel2.tableName);
        String query = sqlContext2.createCreateTableQuery(mmdModel2, false, processCondition.definitionCondition);
        this.getLogger().info("query=" + query);
        int cnt = SqlUtil.executeUpdate(sqlConn2, query);
    }

    public void createIndex(SqlConnection sqlConn, MmdModel mmdModel, XdtsProcessCondition processCondition, Writer errorWriter) throws Exception {
        block2: {
            this.getLogger().info("\u30a4\u30f3\u30c7\u30c3\u30af\u30b9\u3092\u4f5c\u6210\u4e2d... \u30c6\u30fc\u30d6\u30eb\u540d=" + mmdModel.tableName);
            SqlContext sqlContext = sqlConn.getSqlContext();
            try {
                int n = sqlContext.createIndex(sqlConn, mmdModel, this.getLogger());
            }
            catch (Exception ex) {
                String stackTrace = BcLogUtil.getStackTrace(ex);
                errorWriter.append(stackTrace);
                if (processCondition.ignoreException) break block2;
                throw ex;
            }
        }
    }

    public void removeField(SqlContext sqlContext, MmdModel mmdModel, SqlDefinitionCondition definitionCondition, boolean renumber, BcLogger logger) throws Exception {
        Object mmdField;
        ArrayList<Object> removeFieldList = new ArrayList<Object>();
        int fieldCount = mmdModel.getFieldCount();
        int i = 0;
        while (i < fieldCount) {
            int index = fieldCount - i - 1;
            mmdField = mmdModel.getField(index);
            String definition = sqlContext.createColumnTypeDefinition((MmdField)mmdField, definitionCondition);
            if (BcStringUtil.isEmpty(definition)) {
                removeFieldList.add(mmdField);
            }
            ++i;
        }
        ArrayList<MmdIndex> removeIndexList = new ArrayList<MmdIndex>();
        for (MmdIndex mmdIndex : mmdModel.indexMap.values()) {
            int i2 = 0;
            while (i2 < mmdIndex.indexElementList.size()) {
                MmdIndexElement indexElement = mmdIndex.indexElementList.get(i2);
                int j = 0;
                while (j < removeFieldList.size()) {
                    MmdField mmdField2 = (MmdField)removeFieldList.get(j);
                    if (indexElement.columnName.equalsIgnoreCase(mmdField2.columnName)) {
                        removeIndexList.add(mmdIndex);
                        break;
                    }
                    ++j;
                }
                ++i2;
            }
        }
        int i3 = 0;
        while (i3 < removeIndexList.size()) {
            MmdIndex mmdIndex1 = (MmdIndex)removeIndexList.get(i3);
            MmdIndex mmdIndex2 = mmdModel.indexMap.remove(mmdIndex1.name);
            if (mmdIndex2 == null) {
                throw new Exception("mmdIndex2=" + mmdIndex2);
            }
            if (mmdIndex1.name.equalsIgnoreCase(mmdModel.primaryIndexName)) {
                mmdModel.primaryIndexName = null;
            }
            ++i3;
        }
        i3 = 0;
        while (i3 < removeFieldList.size()) {
            mmdField = (MmdField)removeFieldList.get(i3);
            mmdModel.removeField(((MmdField)mmdField).ordinalPosition - 1);
            ++i3;
        }
        if (renumber) {
            i3 = 0;
            while (i3 < mmdModel.getFieldCount()) {
                mmdField = mmdModel.getField(i3);
                ((MmdField)mmdField).ordinalPosition = i3 + 1;
                ++i3;
            }
        }
    }

    public void removeField_xxxxx(SqlContext sqlContext, MmdModel mmdModel, SqlDefinitionCondition definitionCondition, BcLogger logger) throws Exception {
        Object mmdField;
        ArrayList<MmdField> removeFieldList = new ArrayList<MmdField>();
        int fieldCount = mmdModel.getFieldCount();
        int i = 0;
        while (i < fieldCount) {
            int index = fieldCount - i - 1;
            mmdField = mmdModel.getField(index);
            String definition = sqlContext.createColumnTypeDefinition((MmdField)mmdField, definitionCondition);
            if (BcStringUtil.isEmpty(definition)) {
                removeFieldList.add((MmdField)mmdField);
            }
            ++i;
        }
        logger.info("mmdModel2.getFieldCount()=" + mmdModel.getFieldCount());
        logger.info("removeFieldList=" + removeFieldList.size());
        ArrayList<MmdIndex> removeIndexList = new ArrayList<MmdIndex>();
        for (MmdIndex mmdIndex : mmdModel.indexMap.values()) {
            int i2 = 0;
            while (i2 < mmdIndex.indexElementList.size()) {
                MmdIndexElement indexElement = mmdIndex.indexElementList.get(i2);
                int j = 0;
                while (j < removeFieldList.size()) {
                    MmdField mmdField2 = (MmdField)removeFieldList.get(j);
                    if (indexElement.columnName.equalsIgnoreCase(mmdField2.columnName)) {
                        removeIndexList.add(mmdIndex);
                        break;
                    }
                    ++j;
                }
                ++i2;
            }
        }
        int i3 = 0;
        while (i3 < removeIndexList.size()) {
            MmdIndex mmdIndex1 = (MmdIndex)removeIndexList.get(i3);
            MmdIndex mmdIndex2 = mmdModel.indexMap.remove(mmdIndex1.name);
            if (mmdIndex2 == null) {
                throw new Exception("mmdIndex2=" + mmdIndex2);
            }
            if (mmdIndex1.name.equalsIgnoreCase(mmdModel.primaryIndexName)) {
                mmdModel.primaryIndexName = null;
            }
            ++i3;
        }
        i3 = 0;
        while (i3 < removeFieldList.size()) {
            mmdField = (MmdField)removeFieldList.get(i3);
            mmdModel.removeField(((MmdField)mmdField).ordinalPosition - 1);
            ++i3;
        }
    }

    public MmdModel createMmdModelForSelect(ResultSetMetaData rsmd, String newTableName) throws Exception {
        List<String> columnNameList = null;
        Map<String, MmdField> mmdFieldMap = null;
        DtsWordManager wordManager = null;
        Locale locale = null;
        List<MmdField> mmdFieldList = ScfMmdServerUtil.createMmdFieldList(rsmd, columnNameList, mmdFieldMap, wordManager, locale);
        MmdModel mmdModel2 = new MmdModel();
        mmdModel2.tableName = newTableName;
        int i = 0;
        while (i < mmdFieldList.size()) {
            MmdField mmdField = mmdFieldList.get(i);
            mmdModel2.addField(mmdField);
            ++i;
        }
        return mmdModel2;
    }

    public void createInsertQuery_L2(DtsSession dtsSession1, Collection<XdtsSchemaObject> schemaObjectCollection, SqlContext sqlContext2, XdtsProcessCondition processCondition, BcLogger logger) throws Exception {
        SqlContext sqlContextWk1 = dtsSession1.getSqlContext();
        for (XdtsSchemaObject schemaObject : schemaObjectCollection) {
            this.createInsertQuery_L3(dtsSession1, schemaObject, sqlContext2, processCondition, logger);
        }
    }

    public void createInsertQuery_L3(DtsSession dtsSession1, XdtsSchemaObject schemaObject, SqlContext sqlContext2, XdtsProcessCondition processCondition, BcLogger logger) throws Exception {
        SqlContext sqlContext1 = dtsSession1.getSqlContext();
        File destFile = new File(processCondition.destDirPath, String.valueOf(schemaObject.name1) + ".sql");
        logger.info("destFile=" + destFile.getPath());
        BcFileUtil.makeParent(destFile);
        FileOutputStream os = new FileOutputStream(destFile, processCondition.append);
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)os, BcConstants.charset.name());){
            String query = "SELECT * FROM " + schemaObject.name1;
            logger.info("query=" + query);
            SqlStatement stmt = dtsSession1.getConnection().createStatement();
            SqlResultSet rs = stmt.executeQuery(query);
            MmdModel mmdModel2 = XdtsServerUtil.getInstance().createMmdModelForSelect(rs.getMetaData(), schemaObject.name1);
            SqlDefinitionCondition definitionCondition = SqlDefinitionCondition.createDefault();
            this.removeField(sqlContext2, mmdModel2, definitionCondition, false, logger);
            String insertBaseQuery = sqlContext2.createInsertQueryForPrepareStatement(mmdModel2, BcStringUtil.lineSeparator, true);
            logger.debug("insertBaseQuery=" + insertBaseQuery);
            XsysCreateInsertSqlTask createInsertQueryTask = new XsysCreateInsertSqlTask();
            createInsertQueryTask.setResultSet(rs);
            createInsertQueryTask.setCondition(sqlContext2, insertBaseQuery, mmdModel2, processCondition, writer);
            createInsertQueryTask.taskProcess();
        }
    }

    public BcTableModel toTableModel(DtsWordManagerImpl wordManager) throws Exception {
        BcTableColumnModel tableColumnModel = XdtsUtil.createWordTableColumnModel();
        BcTableModel tableModel = new BcTableModel(tableColumnModel);
        Iterator<Map.Entry<String, Map<String, String>>> iterator1 = wordManager.wordMap.entrySet().iterator();
        int cnt = 0;
        for (Map.Entry<String, Map<String, String>> mapEntry1 : wordManager.wordMap.entrySet()) {
            if (++cnt % 100 == 0) {
                BcLogUtil.info("cnt=" + cnt);
            }
            String wordCode = mapEntry1.getKey();
            Map<String, String> langMap = mapEntry1.getValue();
            for (Map.Entry<String, String> mapEntry2 : langMap.entrySet()) {
                String wordValue = mapEntry2.getValue();
                ArrayList<String> row = new ArrayList<String>();
                row.add(wordCode);
                row.add(mapEntry2.getKey());
                row.add(mapEntry2.getValue());
                row.add("\u5099\u8003");
                tableModel.addRow(row);
            }
        }
        return tableModel;
    }

    public Map<String, MmdModel> createMmdModelMap(DtsSession dtsSession, Collection<String> tableNameCollection) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        TreeMap<String, MmdModel> mmdMap = new TreeMap<String, MmdModel>();
        for (String tableName : tableNameCollection) {
            MmdModel mmdModel = sqlContext.createModelMetaData(dtsSession.getConnection(), tableName, true);
            mmdMap.put(tableName, mmdModel);
        }
        return mmdMap;
    }

    /* synthetic */ XdtsServerUtil(XdtsServerUtil xdtsServerUtil) {
        this();
    }

    private static final class SingletonHolder {
        private static final XdtsServerUtil instance = new XdtsServerUtil(null);

        private SingletonHolder() {
        }
    }
}

