/*
 * Decompiled with CFR 0.152.
 */
package ext.module.impt.server;

import ext.appfw.common.AfbApplication;
import ext.base.core.BcConstants;
import ext.base.core.BcStringUtil;
import ext.base.core.BcTimeUtil;
import ext.base.log.BcLogConstants;
import ext.base.log.BcLogUtil;
import ext.base.log.BcLogger;
import ext.base.util.BcParseEventHandler;
import ext.lib.datasource.DtsSession;
import ext.lib.rmi.agent.RmiAgent;
import ext.module.impt.common.ImptAbstractRecordParser;
import ext.module.impt.common.ImptImportDataParser;
import ext.module.impt.common.ImptImportUtil;
import ext.module.impt.common.ImptWorkbookParser;
import ext.module.impt.dao.ImptImportContextDAO;
import ext.module.impt.model.ImptImportCondition;
import ext.module.impt.model.ImptImportContext;
import ext.module.impt.model.ImptImportDefine;
import ext.module.impt.server.ImptAbstractImportModule;
import ext.module.impt.server.ImptImportEventHandler;
import ext.module.impt.server.ImptServerModule;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

public class ImptImportMainProcess
implements BcParseEventHandler {
    String loggerName = "import";
    BcLogger logger;
    File logFile;
    StringBuilder logStrBuf = new StringBuilder(512);
    String errMsg;
    public ImptImportCondition importCondition;
    public ImptImportDefine importDefine;
    File sourceFile;
    ImptImportContext importContext;
    File preservBaseDir;
    File preserveDir;
    int curRecCount;
    DtsSession dtsSession;
    ImptAbstractRecordParser recordParser;
    public static List<ImptAbstractImportModule> importModuleList = new ArrayList<ImptAbstractImportModule>();
    RmiAgent rmixAgent;

    public void setup(BcLogger logger, DtsSession dtsSession) throws Exception {
        this.logger = logger;
        this.dtsSession = dtsSession;
        int i = 0;
        while (i < importModuleList.size()) {
            ImptAbstractImportModule importModule = importModuleList.get(i);
            importModule.setLogger(logger);
            importModule.setDtsSession(dtsSession);
            ++i;
        }
        this.preservBaseDir = new File(AfbApplication.getInstance().toReal("${APP}data/import/"));
    }

    public void addImportModeule(ImptAbstractImportModule importModule) throws Exception {
        importModuleList.add(importModule);
    }

    public void startImport() throws Exception {
        this.startImportL2();
        this.dtsSession.getConnection().commit();
        if (this.errMsg != null) {
            BcLogUtil.debug("errMsg=" + this.errMsg);
            throw new Exception(this.errMsg);
        }
    }

    protected void startImportL2() throws Exception {
        int i = 0;
        while (i < this.importCondition.importContextdList.size()) {
            if (this.errMsg != null) break;
            int importContextId = this.importCondition.importContextdList.get(i);
            this.importContext = ImptImportContextDAO.getInstance().getImportContext(this.dtsSession, importContextId);
            if (this.importContext == null) {
                throw new Exception("not found importContextId=" + importContextId);
            }
            this.preserveDir = new File(this.preservBaseDir, BcStringUtil.fillPrefix(importContextId, 8, '0'));
            File tempFile = this.importCondition.souceFileList.get(i);
            this.sourceFile = new File(this.preserveDir, tempFile.getName());
            this.importContext.sourceUrl = this.importCondition.sourceUrl;
            this.importContext.sourcePreserveUrl = "//" + InetAddress.getLocalHost().getHostName() + "/" + this.sourceFile.getPath();
            this.importContext.fileLastModified = BcTimeUtil.toCalendar(this.sourceFile.lastModified());
            this.importContext.fileSize = this.sourceFile.length();
            this.importContext.startTime = BcTimeUtil.createCalendar();
            this.importContext.processModeId = this.importCondition.processId;
            this.importContext.startDataNo = this.importCondition.startDataNo;
            this.importContext.endDataNo = this.importCondition.endDataNo;
            ImptImportContextDAO.getInstance().putImportContext(this.dtsSession, this.importContext);
            this.logFile = new File(this.preserveDir, "import_log.txt");
            BcLogger logger = BcLogUtil.createLogger(this.loggerName, false, BcLogConstants.LogLevel.DEBUG, true, this.logFile);
            this.transL2();
            ++i;
        }
    }

    protected void transL2() throws Exception {
        int cfr_ignored_0 = this.importContext.processModeId;
        ImptImportUtil.getInstance().nonLineNumberLog("==============================================================================");
        ImptImportUtil.getInstance().nonLineNumberLog("                               << import >>");
        if (this.importCondition.resumeImportId > 0) {
            ImptImportUtil.getInstance().nonLineNumberLog("                             **** resume ****");
        }
        ImptImportUtil.getInstance().nonLineNumberLog("");
        ImptImportUtil.getInstance().nonLineNumberLog("  system version : " + BcConstants.LIB_VERSION_CODE);
        ImptImportUtil.getInstance().nonLineNumberLog("      impoort id : " + this.importContext.getDataId());
        ImptImportUtil.getInstance().nonLineNumberLog("      source URL : " + this.importContext.sourceUrl);
        ImptImportUtil.getInstance().nonLineNumberLog("    preserve URL : " + this.importContext.sourcePreserveUrl);
        ImptImportUtil.getInstance().nonLineNumberLog("        dataSize : " + this.importContext.fileSize);
        ImptImportUtil.getInstance().nonLineNumberLog("   last modified : " + BcTimeUtil.toString(this.importContext.fileLastModified));
        ImptImportUtil.getInstance().nonLineNumberLog("   format define : " + this.importContext.defineFileName);
        ImptImportUtil.getInstance().nonLineNumberLog("      start time : " + BcTimeUtil.toString(this.importContext.startTime));
        ImptImportUtil.getInstance().nonLineNumberLog(" process mode id : " + this.importContext.processModeId);
        ImptImportUtil.getInstance().nonLineNumberLog("   rec seq start : " + this.importContext.startDataNo);
        ImptImportUtil.getInstance().nonLineNumberLog("     rec seq end : " + this.importContext.endDataNo);
        ImptImportUtil.getInstance().nonLineNumberLog("==============================================================================");
        if (this.importDefine.datasourceType == 11 || this.importDefine.datasourceType == 21) {
            this.recordParser = new ImptImportDataParser();
            this.recordParser.addEventHandler(this);
        } else if (this.importDefine.datasourceType == 31) {
            this.recordParser = new ImptWorkbookParser();
            this.recordParser.addEventHandler(this);
        } else {
            throw new Exception("importDefine.formatType=" + this.importDefine.datasourceType);
        }
        int i = 0;
        while (i < importModuleList.size()) {
            ImptAbstractImportModule importModule = importModuleList.get(i);
            importModule.setImportContext(this.importContext);
            ++i;
        }
        if (this.sourceFile.exists()) {
            FileInputStream fileInputStream = new FileInputStream(this.sourceFile);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
            this.recordParser.doParse(this.importDefine, bufferedInputStream);
        } else {
            ImptImportUtil.getInstance().nonLineNumberLog("\u30bd\u30fc\u30b9\u30d5\u30a1\u30a4\u30eb\u304c\u3042\u308a\u307e\u305b\u3093\u3002 " + this.sourceFile.getPath());
        }
        ImptImportEventHandler[] importEventHandlers = ImptServerModule.getInstance().importEventHandlerList.toArray(new ImptImportEventHandler[0]);
        int i2 = 0;
        while (i2 < importEventHandlers.length) {
            importEventHandlers[i2].importupFinisfed(this.dtsSession);
            ++i2;
        }
        Calendar endTimestamp = BcTimeUtil.createCalendar();
        if (this.errMsg == null) {
            this.importContext.endTime = endTimestamp;
        }
        ImptImportContextDAO.getInstance().putImportContext(this.dtsSession, this.importContext);
        String lapTime = BcTimeUtil.toDurationString(BcTimeUtil.periodMilliSecounds(this.importContext.startTime, endTimestamp));
        ImptImportUtil.getInstance().nonLineNumberLog("==============================================================================");
        ImptImportUtil.getInstance().nonLineNumberLog("                               << import >>");
        ImptImportUtil.getInstance().nonLineNumberLog("");
        ImptImportUtil.getInstance().nonLineNumberLog("      impoort id : " + this.importContext.getDataId());
        ImptImportUtil.getInstance().nonLineNumberLog("        end time : " + BcTimeUtil.toString(this.importContext.endTime));
        ImptImportUtil.getInstance().nonLineNumberLog("    laps of time : " + lapTime);
        ImptImportUtil.getInstance().nonLineNumberLog("          remark : " + this.importContext.note);
        ImptImportUtil.getInstance().nonLineNumberLog("==============================================================================");
        ImptImportUtil.getInstance().nonLineNumberLog("");
    }

    @Override
    public void parseStarted() throws Exception {
    }

    @Override
    public void parseFinished() throws Exception {
    }

    @Override
    public void parsedRow(int page, int row, int totalCnt, List<String> valueList) throws Exception {
        try {
            this.parsedRow2(page, row, totalCnt, valueList);
        }
        catch (Exception ex) {
            if (this.importCondition.skipOnException) {
                ImptImportUtil.getInstance().nonLineNumberLog("");
                ImptImportUtil.getInstance().nonLineNumberLog("\u30d5\u30a1\u30a4\u30eb " + this.sourceFile.getName() + " \u306e " + totalCnt + " \u884c\uff08\u4ef6\u76ee\uff09\u306e\u51e6\u7406\u306b\u304a\u3044\u3066\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002");
                ImptImportUtil.getInstance().nonLineNumberLog("");
            }
            this.recordParser.stop();
            this.errMsg = "\u30d5\u30a1\u30a4\u30eb " + this.sourceFile.getName() + " \u306e " + totalCnt + " \u884c\uff08\u4ef6\u76ee\uff09\u306e\u51e6\u7406\u306b\u304a\u3044\u3066\u4f8b\u5916\u304c\u767a\u751f\u3057\u305f\u305f\u3081\u4e2d\u65ad\u3057\u307e\u3057\u305f\u3002" + "\n" + "\n" + ex + "\n" + "\n\u8a73\u3057\u304f\u306f\u30ed\u30b0\u3092\u3054\u89a7\u4e0b\u3055\u3044\u3002" + "\n\u30ed\u30b0\u30d5\u30a1\u30a4\u30eb\uff1a" + this.logFile.getPath() + "\n";
            this.importContext.note = "\u884c " + totalCnt + " \u306b\u3066\u4f8b\u5916\u304c\u767a\u751f\u3057\u305f\u305f\u3081\u51e6\u7406\u3092\u4e2d\u65ad";
            ImptImportUtil.getInstance().nonLineNumberLog("");
            ImptImportUtil.getInstance().nonLineNumberLog("**** " + this.importContext.note + " ****");
            throw ex;
        }
    }

    protected void parsedRow2(int page, int rowNo, int totalCnt, List valueList) throws Exception {
        ImptAbstractImportModule importModule;
        int i;
        this.curRecCount = totalCnt;
        if (this.importDefine.headerRow > 0) {
            if (rowNo < this.importDefine.headerRow) {
                return;
            }
            if (rowNo == this.importDefine.headerRow) {
                this.importDefine.setIndexRow(valueList);
                int i2 = 0;
                while (i2 < importModuleList.size()) {
                    ImptAbstractImportModule importModule2 = importModuleList.get(i2);
                    importModule2.setImportDefine(this.importDefine);
                    ++i2;
                }
                return;
            }
        } else if (rowNo == 1) {
            this.importDefine.setOrdinalPosition();
            i = 0;
            while (i < importModuleList.size()) {
                importModule = importModuleList.get(i);
                importModule.setImportDefine(this.importDefine);
                ++i;
            }
        }
        if (this.importCondition.startDataNo > 0 && totalCnt < this.importCondition.startDataNo) {
            return;
        }
        if (this.importCondition.endDataNo > 0 && totalCnt > this.importCondition.endDataNo) {
            return;
        }
        try {
            this.logStrBuf.delete(0, this.logStrBuf.length());
            i = 0;
            while (i < importModuleList.size()) {
                importModule = importModuleList.get(i);
                importModule.parsedRow(totalCnt, valueList);
                ++i;
            }
            this.importContext.completeRow = totalCnt;
            ImptImportContextDAO.getInstance().putImportContext(this.dtsSession, this.importContext);
            this.dtsSession.commit();
            if (BcStringUtil.isEmpty(this.logStrBuf)) {
                this.log("<complete>");
            }
        }
        catch (Exception ex) {
            this.dtsSession.rollback();
            throw ex;
        }
    }

    @Override
    public void characterDecodingException(int page, int row, int totalCnt, int columnIndex, byte[] bytes, Throwable throwable) throws Exception {
        this.log(throwable.toString());
    }

    public void log(String argMsg) throws Exception {
        if (BcStringUtil.isEmpty(this.logStrBuf)) {
            this.logStrBuf.append(String.valueOf(BcStringUtil.fillPrefix(this.curRecCount, 8, '0')) + ":" + argMsg);
        } else {
            this.logStrBuf.append("\r\n        :" + argMsg);
        }
    }

    public String getNewDataRemark() {
        StringBuilder sb = new StringBuilder();
        sb.append("importId=" + this.importContext.getDataId() + ":" + this.curRecCount);
        sb.append("  ");
        sb.append(this.sourceFile.getName());
        sb.append(" ");
        sb.append(BcTimeUtil.toString(BcTimeUtil.createCalendar(), "yyyy/MM/dd HH:mm:ss"));
        return sb.toString();
    }

    public File getPreservBaseDir() {
        return this.preservBaseDir;
    }

    public void setPreservBaseDir(File preservBaseDir) {
        this.preservBaseDir = preservBaseDir;
    }

    public int getCurRecCount() {
        return this.curRecCount;
    }
}

