/*
 * Decompiled with CFR 0.152.
 */
package ext.libx.business.address;

import ext.base.core.BcStringUtil;

public final class BsnPostalUtil {
    public static final int POST_OFFICE_NUMBER_LENGTH = 3;
    public static final int DISTRICTNUMBER_LENGTH = 4;
    public static final String DELIMITER = BcStringUtil.HYPHEN_STR;
    public static final String POSTAL_CODE_FORMAT = "000-0000";
    public static final String POSTAL_CODE_REGEX = "^\\d{3}-\\d{4}$";

    private BsnPostalUtil() {
    }

    public static String toPostOfficeNumber(Object src) {
        short shortValue = Short.parseShort(src.toString());
        return BcStringUtil.fillPrefix(shortValue, 3, '0');
    }

    public static String toDistrictNumber(Object src) {
        short shortValue = Short.parseShort(src.toString());
        return BcStringUtil.fillPrefix(shortValue, 4, '0');
    }

    public static String toPostalCodeHyphen(Object postOfficeNumber, Object districtNumber) {
        return String.valueOf(BsnPostalUtil.toPostOfficeNumber(postOfficeNumber)) + DELIMITER + BsnPostalUtil.toDistrictNumber(districtNumber);
    }

    public static String toPostalCodeHyphen(int postalCodeNum) {
        String str1 = BcStringUtil.fillPrefix(postalCodeNum, 7, '0');
        String postOfficeNumber = str1.substring(0, 3);
        String districtNumber = str1.substring(3);
        return BsnPostalUtil.toPostalCodeHyphen(postOfficeNumber, districtNumber);
    }

    public static String toPostalCodeHyphen(String str) {
        int postalCodeNum = BsnPostalUtil.toPostalCodeNum(str);
        return BsnPostalUtil.toPostalCodeHyphen(postalCodeNum);
    }

    public static String toPostalCode(String src) {
        short[] shorts = BsnPostalUtil.separatePostalCode(src);
        String str1 = String.valueOf(BsnPostalUtil.toPostOfficeNumber(shorts[0])) + BsnPostalUtil.toDistrictNumber(shorts[1]);
        return str1;
    }

    public static int toPostalCodeNum(String src) {
        return Integer.parseInt(BsnPostalUtil.toPostalCode(src));
    }

    public static short[] separatePostalCode(String src) {
        short[] shorts = new short[2];
        if (BcStringUtil.isEmpty(src)) {
            return shorts;
        }
        int idx1 = src.indexOf(DELIMITER);
        int idx2 = 0;
        String srcWk = null;
        if (idx1 >= 0) {
            srcWk = src;
            idx2 = idx1 + 1;
        } else {
            srcWk = BcStringUtil.fillPrefix(src, 7, '0');
            idx1 = 3;
            idx2 = 3;
        }
        String postOfficeNumber = srcWk.substring(0, idx1);
        String districtNumber = srcWk.substring(idx2);
        shorts[0] = Short.parseShort(postOfficeNumber);
        shorts[1] = Short.parseShort(districtNumber);
        return shorts;
    }
}

