/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.swg;

import ext.base.core.BcStringUtil;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.io.Serializable;
import java.util.HashMap;
import javax.swing.Icon;
import javax.swing.JLabel;

public class SwgLabel
extends JLabel
implements Serializable {
    private static final long serialVersionUID = 7768814811084297631L;
    protected boolean antialias = false;

    public SwgLabel(String text, Icon icon, int horizontalAlignment) {
        super(text, icon, horizontalAlignment);
    }

    public SwgLabel(String text, int horizontalAlignment) {
        this(text, null, horizontalAlignment);
    }

    public SwgLabel(String text) {
        this(text, null, 10);
    }

    public SwgLabel(Icon image, int horizontalAlignment) {
        this(null, image, horizontalAlignment);
    }

    public SwgLabel(Icon image) {
        this(null, image, 0);
    }

    public SwgLabel() {
        this("", null, 10);
    }

    @Override
    public void setText(String text) {
        if (BcStringUtil.isEmpty(text)) {
            super.setText("");
        } else {
            super.setText(text);
        }
    }

    public boolean getAntialias() {
        return this.antialias;
    }

    public void setAntialias(boolean flag) {
        this.antialias = flag;
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        if (this.antialias) {
            HashMap<RenderingHints.Key, Object> newHint = new HashMap<RenderingHints.Key, Object>();
            newHint.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            newHint.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            RenderingHints oldHint = g2.getRenderingHints();
            g2.setRenderingHints(newHint);
            super.paint(g2);
            g2.setRenderingHints(oldHint);
        } else {
            super.paint(g2);
        }
    }
}

