/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.jline;

import ext.base.log.BcLoggableObject;
import ext.base.util.BcConsoleHelper;
import org.jline.reader.Completer;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.Parser;
import org.jline.reader.impl.DefaultParser;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;
import org.jline.utils.Display;

public class JLineHelper
extends BcLoggableObject {
    public Terminal terminal;
    public Parser parser;
    public LineReader lineReader;
    public Display display;
    public Completer completer;
    public String prompt = ">";
    BcConsoleHelper consoleHelper = new BcConsoleHelper();

    public void build() throws Exception {
        this.createLineReader();
    }

    protected Terminal createTerminal() throws Exception {
        Terminal terminal = TerminalBuilder.builder().system(true).build();
        return terminal;
    }

    protected Parser createParser() throws Exception {
        DefaultParser parser = new DefaultParser();
        return parser;
    }

    protected LineReader createLineReader() throws Exception {
        this.terminal = this.createTerminal();
        this.display = new Display(this.terminal, true);
        this.parser = this.createParser();
        this.completer = this.createCompleter();
        LineReaderBuilder lineReaderBuilder = LineReaderBuilder.builder();
        lineReaderBuilder.terminal(this.terminal);
        lineReaderBuilder.parser(this.parser);
        if (this.completer != null) {
            lineReaderBuilder.completer(this.completer);
        }
        this.lineReader = lineReaderBuilder.build();
        return this.lineReader;
    }

    protected Completer createCompleter() throws Exception {
        return null;
    }

    public String input(String str) throws Exception {
        if (str == null) {
            str = "";
        }
        return this.lineReader.readLine(String.valueOf(str) + this.prompt);
    }

    public void clear() throws Exception {
        this.consoleHelper.screenClear();
    }
}

