/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.html.ruby;

import ext.base.core.BcStringUtil;
import ext.base.util.BcKanaUtil;
import ext.lib.html.common.HtmlTextElement;
import java.util.List;

public final class HtmlRubyUtil {
    private HtmlRubyUtil() {
    }

    public static StringBuilder toHtml(List<Object> textElementList) throws Exception {
        StringBuilder sb = new StringBuilder(256);
        int i = 0;
        while (i < textElementList.size()) {
            Object element = textElementList.get(i);
            if (CharSequence.class.isAssignableFrom(element.getClass())) {
                sb.append((CharSequence)element);
            } else if (HtmlTextElement.class.isAssignableFrom(element.getClass())) {
                HtmlTextElement textElement = (HtmlTextElement)textElementList.get(i);
                if (BcStringUtil.isEmpty(textElement.ruby)) {
                    sb.append(textElement.text);
                } else {
                    sb.append("<ruby>");
                    sb.append("<rb>");
                    sb.append(textElement.text);
                    sb.append("</rb>");
                    sb.append("<rp>");
                    sb.append("\uff08");
                    sb.append("</rp>");
                    sb.append("<rt>");
                    sb.append(textElement.ruby);
                    sb.append("</rt>");
                    sb.append("<rp>");
                    sb.append("\uff09");
                    sb.append("</rp>");
                    sb.append("</ruby>");
                }
            } else {
                throw new Exception("unknown type " + element.getClass().getName());
            }
            ++i;
        }
        return sb;
    }

    public static StringBuilder toPlainText(List<HtmlTextElement> textElementList) throws Exception {
        StringBuilder sb = new StringBuilder(256);
        int i = 0;
        while (i < textElementList.size()) {
            HtmlTextElement element = textElementList.get(i);
            if (HtmlTextElement.class.isAssignableFrom(element.getClass())) {
                HtmlTextElement textElement = element;
                if (!BcStringUtil.isEmpty(textElement.text)) {
                    sb.append(textElement.text);
                }
            } else {
                sb.append(element.toString());
            }
            ++i;
        }
        return sb;
    }

    public static StringBuilder toHiragana(List<HtmlTextElement> textElementList) throws Exception {
        StringBuilder sb = new StringBuilder(256);
        int i = 0;
        while (i < textElementList.size()) {
            HtmlTextElement element = textElementList.get(i);
            if (HtmlTextElement.class.isAssignableFrom(element.getClass())) {
                HtmlTextElement textElement = element;
                if (BcStringUtil.isEmpty(textElement.ruby)) {
                    sb.append(BcKanaUtil.zenKanaToHiragana(textElement.text, 2));
                } else {
                    sb.append(BcKanaUtil.zenKanaToHiragana(textElement.ruby, 2));
                }
            } else {
                sb.append(element.toString());
            }
            ++i;
        }
        return sb;
    }
}

