/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.awt;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

public class AwtTextField
extends TextField {
    private static final long serialVersionUID = -625304416128928234L;
    protected final PopupMenu popupMenu = new PopupMenu();
    protected final MenuItem cutMenu = new MenuItem("\u5207\u308a\u53d6\u308a");
    protected final MenuItem copyMenu = new MenuItem("\u30b3\u30d4\u30fc");
    protected final MenuItem copyAllMenu = new MenuItem("\u5168\u3066\u30b3\u30d4\u30fc");
    protected final MenuItem pastMenu = new MenuItem("\u8cbc\u308a\u4ed8\u3051");
    protected final MenuItem deleteMenu = new MenuItem("\u524a\u9664");
    protected Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
    protected Transferable content;
    int tmpSeq = 0;

    public AwtTextField() {
        this.init();
    }

    public AwtTextField(String str) {
        super(str);
        this.init();
    }

    protected void init() {
        this.content = this.clipboard.getContents(this);
        super.setBackground(Color.white);
        this.setPopupMenu();
        super.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent ev) {
                AwtTextField.this.keyPressedEvent(ev);
            }
        });
        super.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent ev) {
                AwtTextField.this.mouseEvent(ev);
            }

            @Override
            public void mousePressed(MouseEvent ev) {
                AwtTextField.this.mouseEvent(ev);
            }

            @Override
            public void mouseReleased(MouseEvent ev) {
                AwtTextField.this.mouseEvent(ev);
            }

            @Override
            public void mouseClicked(MouseEvent ev) {
                AwtTextField.this.mouseEvent(ev);
            }
        });
    }

    @Override
    public void setEditable(boolean bool) {
        super.setBackground(Color.lightGray);
        super.setEditable(bool);
    }

    void keyPressedEvent(KeyEvent ev) {
        switch (ev.getKeyCode()) {
            case 10: {
                this.nextFocus();
            }
        }
    }

    @Override
    public void nextFocus() {
        Container container = super.getParent();
        Component[] compo = container.getComponents();
        int i = 0;
        block0: while (i < compo.length) {
            if (compo[i].equals(this)) {
                int j = 0;
                while (j < compo.length) {
                    this.tmpSeq = i + 1 + j;
                    if (this.tmpSeq >= compo.length) {
                        this.tmpSeq -= compo.length;
                    }
                    if (this.setFocus(compo[this.tmpSeq])) break block0;
                    ++j;
                }
                break;
            }
            ++i;
        }
    }

    boolean setFocus(Component compo) {
        try {
            TextField textField = (TextField)compo;
            if (textField.isEditable() && textField.isEnabled()) {
                textField.requestFocus();
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    protected void mouseEvent(MouseEvent ev) {
        switch (ev.getID()) {
            case 504: {
                break;
            }
            case 505: {
                break;
            }
            case 503: {
                break;
            }
            case 501: {
                if (ev.getModifiers() != 4) break;
                this.popupMenu();
                this.popupMenu.show(this, ev.getX(), ev.getY());
                break;
            }
            case 506: {
                break;
            }
            case 502: {
                break;
            }
        }
    }

    public void popupMenu() {
        String clipText = null;
        if (this.content != null) {
            try {
                clipText = (String)this.content.getTransferData(DataFlavor.stringFlavor);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.cutMenu.setEnabled(super.isEnabled() && super.isEditable() && super.getSelectionEnd() - super.getSelectionStart() > 0);
        this.copyMenu.setEnabled(super.getSelectionEnd() - super.getSelectionStart() > 0);
        this.copyAllMenu.setEnabled(super.getText().length() > 0);
        this.pastMenu.setEnabled(super.isEnabled() && super.isEditable() && clipText != null);
        this.deleteMenu.setEnabled(super.isEnabled() && super.isEditable() && super.getSelectionEnd() - super.getSelectionStart() > 0);
    }

    public PopupMenu getPopupMenu() {
        return this.popupMenu;
    }

    protected void setPopupMenu() {
        super.add(this.popupMenu);
        this.getPopupMenu().add(this.cutMenu);
        this.cutMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
            }
        });
        this.getPopupMenu().add(this.copyMenu);
        this.copyMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
            }
        });
        this.copyAllMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
            }
        });
        this.getPopupMenu().add(this.pastMenu);
        this.pastMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
            }
        });
        this.getPopupMenu().add(this.deleteMenu);
        this.deleteMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
            }
        });
    }
}

