/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.awt;

import ext.base.core.BcStringUtil;
import ext.base.runtime.BcRuntimeUtil;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public class AwtFontUtil {
    public static final String DIALOG = "Dialog";
    public static final String DIALOG_INPUT = "DialogInput";
    public static final String MONOSPACED = "Monospaced";
    public static final String SERIF = "Serif";
    public static final String SANS_SERIF = "SansSerif";
    public static final String SYMBOL = "Symbol";
    public static final String \uff2d\uff33_\u30b4\u30b7\u30c3\u30af = "\uff2d\uff33 \u30b4\u30b7\u30c3\u30af";
    public static final String \uff2d\uff33_\uff30\u30b4\u30b7\u30c3\u30af = "\uff2d\uff33 \uff30\u30b4\u30b7\u30c3\u30af";
    public static final String \uff2d\uff33_\u660e\u671d = "\uff2d\uff33 \u660e\u671d";
    public static final String \uff2d\uff33_\uff30\u660e\u671d = "\uff2d\uff33 \uff30\u660e\u671d";
    public static final String MS_UI_Gothic = "MS UI Gothic";
    public static final String \u30e1\u30a4\u30ea\u30aa = "\u30e1\u30a4\u30ea\u30aa";
    public static final String Meiryo_UI = "Meiryo UI";
    public static final String \u6e38\u30b4\u30b7\u30c3\u30af = "\u6e38\u30b4\u30b7\u30c3\u30af";
    public static final String \u6e38\u660e\u671d = "\u6e38\u660e\u671d";
    public static char sampleHankaku = (char)77;
    public static String sampleHankakut = Character.toString(sampleHankaku);
    public static String sampleZenkaku = "\uff2d";

    private AwtFontUtil() {
    }

    public static Dimension getTextSize(Font font, String text) {
        if (BcStringUtil.isEmpty(text)) {
            text = sampleHankakut;
        }
        Dimension dim1 = null;
        Dimension dim2 = null;
        AffineTransform affineTransform = new AffineTransform();
        FontRenderContext fontRenderContext = new FontRenderContext(affineTransform, false, false);
        TextLayout textLayout = new TextLayout(sampleHankakut, font, fontRenderContext);
        dim2 = new Dimension((int)textLayout.getBounds().getWidth(), (int)(textLayout.getAscent() + textLayout.getDescent()));
        int charWidth = -1;
        int charHeght = -1;
        switch (font.getSize()) {
            case 10: {
                charWidth = 6;
                charHeght = 8;
                break;
            }
            case 11: {
                charWidth = 7;
                charHeght = 9;
                break;
            }
            case 12: {
                charWidth = 7;
                charHeght = 12;
                break;
            }
            case 13: {
                charWidth = 8;
                charHeght = 12;
                break;
            }
            case 14: {
                charWidth = 9;
                charHeght = 13;
            }
        }
        int width = 0;
        int i = 0;
        while (i < text.length()) {
            width = BcStringUtil.isHanLatinCharacter(text.charAt(i)) ? (width += charWidth) : (width += charWidth * 2);
            ++i;
        }
        dim1 = new Dimension(width, charHeght);
        return dim1;
    }

    public static Dimension getTextSize(Font font, int textLength) {
        String text = BcStringUtil.fill(sampleHankakut, textLength);
        return AwtFontUtil.getTextSize(font, text);
    }

    public static Dimension getTextSize(Font font) {
        return AwtFontUtil.getTextSize(font, 1);
    }

    public static Font createFont(File file) throws Exception {
        Font font = null;
        try (FileInputStream is = null;){
            try {
                is = new FileInputStream(file);
                font = Font.createFont(0, is);
            }
            catch (IOException ex) {
                throw ex;
            }
            catch (FontFormatException ex) {
                throw ex;
            }
        }
        return font;
    }

    public static File getFontFile(String physicalFontName) throws Exception {
        File fontFile = null;
        if (BcRuntimeUtil.getOsType() == BcRuntimeUtil.OsType.Windows) {
            File winDir = new File(System.getenv("SystemRoot"));
            File fontDir = new File(winDir, "Fonts");
            String fileName = null;
            if (\uff2d\uff33_\u30b4\u30b7\u30c3\u30af.equals(physicalFontName) || \uff2d\uff33_\uff30\u30b4\u30b7\u30c3\u30af.equals(physicalFontName) || MS_UI_Gothic.equals(physicalFontName)) {
                fileName = "msgothic.ttc";
            } else if (\uff2d\uff33_\u660e\u671d.equals(physicalFontName) || \uff2d\uff33_\uff30\u660e\u671d.equals(physicalFontName)) {
                fileName = "msmincho.ttc";
            } else if (\u30e1\u30a4\u30ea\u30aa.equals(physicalFontName) || Meiryo_UI.equals(physicalFontName)) {
                fileName = "meiryo.ttc";
            }
            if (fileName != null) {
                fontFile = new File(fontDir, fileName);
            }
        }
        return fontFile;
    }

    public static String toLogicalFontName(String physicalFontName) {
        String logicalFontName = null;
        if (BcStringUtil.equalsIgnoreCase(physicalFontName, \uff2d\uff33_\u30b4\u30b7\u30c3\u30af) || BcStringUtil.equalsIgnoreCase(physicalFontName, \uff2d\uff33_\uff30\u30b4\u30b7\u30c3\u30af) || BcStringUtil.equalsIgnoreCase(physicalFontName, MS_UI_Gothic) || BcStringUtil.equalsIgnoreCase(physicalFontName, SANS_SERIF) || BcStringUtil.equalsIgnoreCase(physicalFontName, "sanserif") || BcStringUtil.equalsIgnoreCase(physicalFontName, \u6e38\u30b4\u30b7\u30c3\u30af)) {
            logicalFontName = SANS_SERIF;
        } else if (BcStringUtil.equalsIgnoreCase(physicalFontName, \uff2d\uff33_\u660e\u671d) || BcStringUtil.equalsIgnoreCase(physicalFontName, \uff2d\uff33_\uff30\u660e\u671d) || BcStringUtil.equalsIgnoreCase(physicalFontName, SERIF) || BcStringUtil.equalsIgnoreCase(physicalFontName, \u6e38\u660e\u671d)) {
            logicalFontName = SERIF;
        }
        return logicalFontName;
    }
}

