/*
 * Decompiled with CFR 0.152.
 */
package com.nilo.plaf.nimrod;

import com.nilo.plaf.nimrod.NimRODBorders;
import com.nilo.plaf.nimrod.NimRODLookAndFeel;
import com.nilo.plaf.nimrod.NimRODUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTextFieldUI;
import javax.swing.text.JTextComponent;

public class NimRODTextFieldUI
extends BasicTextFieldUI {
    private boolean rollover = false;
    private boolean focus = false;
    private MiTextML miTextML;
    protected boolean oldOpaque;
    protected boolean canijo;

    NimRODTextFieldUI(JComponent c) {
    }

    public static ComponentUI createUI(JComponent c) {
        return new NimRODTextFieldUI(c);
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.oldOpaque = this.getComponent().isOpaque();
        this.getComponent().setOpaque(false);
    }

    @Override
    protected void uninstallDefaults() {
        super.uninstallDefaults();
        this.getComponent().setOpaque(this.oldOpaque);
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.miTextML = new MiTextML();
        this.getComponent().addMouseListener(this.miTextML);
        this.getComponent().addFocusListener(this.miTextML);
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.getComponent().removeMouseListener(this.miTextML);
        this.getComponent().removeFocusListener(this.miTextML);
    }

    public boolean isFocus() {
        return this.focus;
    }

    public boolean isRollover() {
        return this.rollover;
    }

    @Override
    protected void paintSafely(Graphics g) {
        this.paintFocus(g);
        JTextComponent jTextComponent = this.getComponent();
        if (jTextComponent.isEditable()) {
            jTextComponent.setBackground(Color.WHITE);
            jTextComponent.setForeground(Color.DARK_GRAY);
            jTextComponent.setCaretColor(Color.BLACK);
        }
        this.paintTodo(g);
        super.paintSafely(g);
    }

    protected void paintTodo(Graphics g) {
        JTextComponent c = this.getComponent();
        Border bb = c.getBorder();
        if (bb != null && bb instanceof NimRODBorders.NimRODGenBorder) {
            Insets ins = NimRODBorders.getTextFieldBorder().getBorderInsets(c);
            if (c.getSize().height + 2 < c.getFont().getSize() + ins.top + ins.bottom) {
                c.setBorder(NimRODBorders.getThinGenBorder());
                this.canijo = true;
            } else {
                c.setBorder(NimRODBorders.getTextFieldBorder());
                this.canijo = false;
            }
            if (!c.isEditable() || !c.isEnabled()) {
                g.setColor(UIManager.getColor("TextField.inactiveBackground"));
            } else {
                g.setColor(c.getBackground());
            }
            Graphics2D g2d = (Graphics2D)g;
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.fillRoundRect(2, 2, c.getWidth() - 4, c.getHeight() - 4, 7, 7);
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
        } else {
            super.paintBackground(g);
        }
    }

    @Override
    protected void paintBackground(Graphics g) {
        JTextComponent c = this.getComponent();
        g.setColor(c.getBackground());
        g.fillRect(0, 0, c.getWidth(), c.getHeight());
        System.out.println("toy");
    }

    protected void paintFocus(Graphics g) {
        JTextComponent c = this.getComponent();
        if (c.isEnabled() && c.isEditable() && !this.canijo) {
            if (this.focus) {
                NimRODUtils.paintFocus(g, 1, 1, c.getWidth() - 2, c.getHeight() - 2, 4, 4, 3.0f, NimRODLookAndFeel.getFocusColor());
            } else if (this.rollover) {
                NimRODUtils.paintFocus(g, 1, 1, c.getWidth() - 2, c.getHeight() - 2, 4, 4, 3.0f, NimRODUtils.getColorAlfa(NimRODLookAndFeel.getFocusColor(), 150));
            }
        }
    }

    class MiTextML
    extends MouseAdapter
    implements FocusListener {
        MiTextML() {
        }

        protected void refresh() {
            if (NimRODTextFieldUI.this.getComponent().getParent() != null) {
                JTextComponent papi = NimRODTextFieldUI.this.getComponent();
                papi.getParent().repaint(((Component)papi).getX() - 5, ((Component)papi).getY() - 5, ((Component)papi).getWidth() + 10, ((Component)papi).getHeight() + 10);
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            NimRODTextFieldUI.this.rollover = false;
            this.refresh();
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            NimRODTextFieldUI.this.rollover = true;
            this.refresh();
        }

        @Override
        public void focusGained(FocusEvent e) {
            NimRODTextFieldUI.this.focus = true;
            this.refresh();
        }

        @Override
        public void focusLost(FocusEvent e) {
            NimRODTextFieldUI.this.focus = false;
            this.refresh();
        }
    }
}

