/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.cosnaming;

import com.sun.jndi.cosnaming.CNCtx;
import com.sun.jndi.toolkit.url.Uri;
import com.sun.jndi.toolkit.url.UrlUtil;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.naming.Name;
import javax.naming.NamingException;

public final class IiopUrl {
    private static final String PARSE_MODE_PROP = "com.sun.jndi.corbaURLParsing";
    private static final Uri.ParseMode DEFAULT_PARSE_MODE = Uri.ParseMode.COMPAT;
    public static final Uri.ParseMode PARSE_MODE;
    private static final int DEFAULT_IIOPNAME_PORT = 9999;
    private static final int DEFAULT_IIOP_PORT = 900;
    private static final String DEFAULT_HOST = "localhost";
    private Vector<Address> addresses;
    private String stringName;

    public Vector<Address> getAddresses() {
        return this.addresses;
    }

    public String getStringName() {
        return this.stringName;
    }

    public Name getCosName() throws NamingException {
        return CNCtx.parser.parse(this.stringName);
    }

    public IiopUrl(String string) throws MalformedURLException {
        int n;
        int n2;
        int n3;
        int n4;
        boolean bl;
        if (string.startsWith("iiopname://")) {
            bl = false;
            n4 = 11;
        } else if (string.startsWith("iiop://")) {
            bl = true;
            n4 = 7;
        } else {
            throw new MalformedURLException("Invalid iiop/iiopname URL: " + string);
        }
        int n5 = n3 = string.indexOf(47, n4);
        int n6 = string.indexOf(63, n4);
        int n7 = string.indexOf(35, n4);
        if (n6 >= 0 && n5 > n6) {
            n5 = -1;
        }
        if (n7 >= 0 && n5 > n7) {
            n5 = -1;
        }
        if (n7 >= 0 && n6 > n7) {
            n6 = -1;
        }
        if ((n2 = (n = PARSE_MODE == Uri.ParseMode.LEGACY ? n3 : (n5 >= 0 ? n5 : (n6 >= 0 ? n6 : n7)))) < 0) {
            n2 = string.length();
            this.stringName = "";
        } else {
            this.stringName = n5 < 0 && PARSE_MODE != Uri.ParseMode.LEGACY ? "" : UrlUtil.decode(string.substring(n2 + 1));
        }
        if (!this.stringName.isEmpty() && PARSE_MODE == Uri.ParseMode.STRICT) {
            try {
                new URI("iiop:///" + this.stringName);
            }
            catch (URISyntaxException uRISyntaxException) {
                MalformedURLException malformedURLException = new MalformedURLException("Invalid iiop/iiopname URL: " + string);
                malformedURLException.initCause(uRISyntaxException);
                throw malformedURLException;
            }
            if (n5 < 0 && (n7 > -1 || n6 > -1)) {
                MalformedURLException malformedURLException = new MalformedURLException("Invalid iiop/iiopname URL: " + string);
                malformedURLException.initCause(new IllegalArgumentException("unexpected query or fragment"));
                throw malformedURLException;
            }
        }
        if (PARSE_MODE != Uri.ParseMode.LEGACY && n > -1 && n != n3) {
            MalformedURLException malformedURLException = new MalformedURLException("Invalid iiop/iiopname URL: " + string);
            malformedURLException.initCause(new IllegalArgumentException("unexpected query or fragment"));
            throw malformedURLException;
        }
        this.addresses = new Vector(3);
        try {
            if (bl) {
                this.addresses.addElement(new Address(string.substring(n4, n2), bl));
            } else {
                StringTokenizer stringTokenizer = new StringTokenizer(string.substring(n4, n2), ",");
                while (stringTokenizer.hasMoreTokens()) {
                    this.addresses.addElement(new Address(stringTokenizer.nextToken(), bl));
                }
                if (this.addresses.size() == 0) {
                    this.addresses.addElement(new Address("", bl));
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Throwable throwable = illegalArgumentException.getCause();
            if (throwable instanceof URISyntaxException) {
                MalformedURLException malformedURLException = new MalformedURLException(throwable.getMessage());
                malformedURLException.initCause(throwable);
                throw malformedURLException;
            }
            throw illegalArgumentException;
        }
    }

    static {
        PrivilegedAction<String> privilegedAction = () -> System.getProperty(PARSE_MODE_PROP, DEFAULT_PARSE_MODE.toString());
        Uri.ParseMode parseMode = DEFAULT_PARSE_MODE;
        try {
            String string = AccessController.doPrivileged(privilegedAction);
            parseMode = Uri.ParseMode.valueOf(string.toUpperCase(Locale.ROOT));
        }
        catch (Throwable throwable) {
            parseMode = DEFAULT_PARSE_MODE;
        }
        finally {
            PARSE_MODE = parseMode;
        }
    }

    public static class Address {
        public int port = -1;
        public int major;
        public int minor;
        public String host;

        public Address(String string, boolean bl) throws MalformedURLException {
            int n;
            int n2;
            if (bl || (n2 = string.indexOf(64)) < 0) {
                this.major = 1;
                this.minor = 0;
                n = 0;
            } else {
                int n3 = string.indexOf(46);
                if (n3 < 0) {
                    throw new MalformedURLException("invalid version: " + string);
                }
                try {
                    this.major = Integer.parseInt(string.substring(0, n3));
                    this.minor = Integer.parseInt(string.substring(n3 + 1, n2));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new MalformedURLException("Nonnumeric version: " + string);
                }
                n = n2 + 1;
            }
            n = this.parse(string, n);
            if ("".equals(this.host) || this.host == null) {
                this.host = IiopUrl.DEFAULT_HOST;
            }
            if (this.port == -1) {
                this.port = bl ? 900 : 9999;
            }
        }

        private int parseLegacy(String string, int n) {
            int n2 = string.indexOf(47, n);
            if (n2 < 0) {
                n2 = string.length();
            }
            if (string.startsWith("[", n)) {
                int n3 = string.indexOf(93, n + 1);
                if (n3 < 0 || n3 > n2) {
                    throw new IllegalArgumentException("IiopURL: name is an Invalid URL: " + string);
                }
                this.host = string.substring(n, n3 + 1);
                n = n3 + 1;
            } else {
                int n4;
                int n5 = string.indexOf(58, n);
                int n6 = n4 = n5 < 0 || n5 > n2 ? n2 : n5;
                if (n < n4) {
                    this.host = string.substring(n, n4);
                }
                n = n4;
            }
            if (n + 1 < n2) {
                if (string.startsWith(":", n)) {
                    this.port = Integer.parseInt(string.substring(++n, n2));
                } else {
                    throw new IllegalArgumentException("IiopURL: name is an Invalid URL: " + string);
                }
            }
            return n2;
        }

        private int parseCompat(String string, int n) {
            int n2;
            int n3 = string.indexOf(47, n);
            if (n3 < 0) {
                n3 = string.length();
            }
            if ((n2 = string.indexOf(58, n)) == n) {
                this.host = "";
                this.port = Integer.parseInt(string.substring(n + 1, n3));
            } else if (n == n3) {
                this.host = "";
                this.port = -1;
            } else {
                URI uRI = URI.create("iiop://" + string.substring(0, n3));
                this.host = uRI.getHost();
                this.port = uRI.getPort();
                if (this.host == null) {
                    throw new IllegalArgumentException("IiopURL: name is an Invalid URL: " + string);
                }
                String string2 = (this.host == null ? "" : this.host) + (this.port == -1 ? "" : ":" + this.port);
                if (!string.substring(n, n3).equals(string2)) {
                    throw new IllegalArgumentException("IiopURL: name is an Invalid URL: " + string);
                }
            }
            return n3;
        }

        private int parseStrict(String string, int n) {
            int n2;
            int n3 = string.indexOf(47, n);
            if (n3 < 0) {
                n3 = string.length();
            }
            if ((n2 = string.indexOf(58, n)) == n) {
                this.host = "";
                this.port = Integer.parseInt(string.substring(++n, n3));
                URI.create("iiop://localhost:" + this.port + string.substring(n3));
            } else if (n == n3) {
                URI uRI;
                this.host = "";
                this.port = -1;
                if (n3 < string.length() && ((uRI = URI.create("iiop://" + string.substring(n3))).getHost() != null || uRI.getPort() != -1)) {
                    throw new IllegalArgumentException("IiopURL: name is an Invalid URL: " + string);
                }
            } else {
                URI uRI = URI.create("iiop://" + string);
                this.host = uRI.getHost();
                this.port = uRI.getPort();
                if (this.host == null) {
                    throw new IllegalArgumentException("IiopURL: name is an Invalid URL: " + string);
                }
                String string2 = (this.host == null ? "" : this.host) + (this.port == -1 ? "" : ":" + this.port);
                if (!string.substring(n, n3).equals(string2)) {
                    throw new IllegalArgumentException("IiopURL: name is an Invalid URL: " + string);
                }
            }
            return n3;
        }

        private int parse(String string, int n) {
            switch (PARSE_MODE) {
                case LEGACY: {
                    return this.parseLegacy(string, n);
                }
                case STRICT: {
                    return this.parseStrict(string, n);
                }
            }
            return this.parseCompat(string, n);
        }
    }
}

