/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.Utility;
import org.apache.bcel.classfile.Visitor;

public final class NestMembers
extends Attribute {
    private int[] classes;

    public NestMembers(NestMembers c) {
        this(c.getNameIndex(), c.getLength(), c.getClasses(), c.getConstantPool());
    }

    public NestMembers(int name_index, int length, int[] classes, ConstantPool constant_pool) {
        super((byte)26, name_index, length, constant_pool);
        this.classes = classes != null ? classes : new int[]{};
    }

    NestMembers(int name_index, int length, DataInput input, ConstantPool constant_pool) throws IOException {
        this(name_index, length, (int[])null, constant_pool);
        int number_of_classes = input.readUnsignedShort();
        this.classes = new int[number_of_classes];
        int i = 0;
        while (i < number_of_classes) {
            this.classes[i] = input.readUnsignedShort();
            ++i;
        }
    }

    @Override
    public void accept(Visitor v) {
        v.visitNestMembers(this);
    }

    @Override
    public void dump(DataOutputStream file) throws IOException {
        super.dump(file);
        file.writeShort(this.classes.length);
        int[] nArray = this.classes;
        int n = this.classes.length;
        int n2 = 0;
        while (n2 < n) {
            int index = nArray[n2];
            file.writeShort(index);
            ++n2;
        }
    }

    public int[] getClasses() {
        return this.classes;
    }

    public int getNumberClasses() {
        return this.classes == null ? 0 : this.classes.length;
    }

    public String[] getClassNames() {
        String[] names = new String[this.classes.length];
        int i = 0;
        while (i < this.classes.length) {
            names[i] = super.getConstantPool().getConstantString(this.classes[i], (byte)7).replace('/', '.');
            ++i;
        }
        return names;
    }

    public void setClasses(int[] classes) {
        this.classes = classes != null ? classes : new int[]{};
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("NestMembers(");
        buf.append(this.classes.length);
        buf.append("):\n");
        int[] nArray = this.classes;
        int n = this.classes.length;
        int n2 = 0;
        while (n2 < n) {
            int index = nArray[n2];
            String class_name = super.getConstantPool().getConstantString(index, (byte)7);
            buf.append("  ").append(Utility.compactClassName(class_name, false)).append("\n");
            ++n2;
        }
        return buf.substring(0, buf.length() - 1);
    }

    @Override
    public Attribute copy(ConstantPool _constant_pool) {
        NestMembers c = (NestMembers)this.clone();
        if (this.classes != null) {
            c.classes = new int[this.classes.length];
            System.arraycopy(this.classes, 0, c.classes, 0, this.classes.length);
        }
        c.setConstantPool(_constant_pool);
        return c;
    }
}

