/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xdts.fx;

import ext.base.core.BcStringUtil;
import ext.base.util.BcCollectionUtil;
import ext.base.util.BcMessageCreator;
import ext.base.util.BcResult;
import ext.base.util.BcWords;
import ext.lib.fx.util.FxOptionPane;
import ext.lib.sql.SqlWords;
import ext.module.xdts.common.XdtsWords;
import ext.module.xdts.fx.XdtsAbstractConditionPane;
import ext.module.xdts.fx.XdtsAbstractTransferPane;
import ext.module.xdts.fx.XdtsCopyRecordConditionPane;
import ext.module.xdts.fx.XdtsCreateCraeteTableQueryConditionPane;
import ext.module.xdts.fx.XdtsUpdateQueryConditionPane;
import ext.module.xdts.model.XdtsProcessCondition;
import ext.module.xdts.model.XdtsProfile;
import ext.module.xdts.stub.XdtsSchemaStub;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.scene.Node;
import javafx.stage.Window;

public class XdtsTransferPane
extends XdtsAbstractTransferPane {
    Mode mode;
    XdtsAbstractConditionPane conditionPane;

    public void setProfile(XdtsProfile profile1, Mode mode) throws Exception {
        this.setProfile(profile1);
        this.mode = mode;
        this.setComponentCommon1();
        this.setComponentCommon2();
        switch (mode) {
            case createCreateTableSql: {
                this.setComponent_createCreateTableSql();
                break;
            }
            case createInsertSql: {
                this.setComponent_createInsertSql();
                break;
            }
            case dropTable: 
            case truncateTable: 
            case tableManipulation: 
            case dropView: {
                this.setComponent_updateQuery();
                break;
            }
            case copyToOtherDb: {
                this.setComponent_copyToOther();
            }
        }
        this.title = mode.title;
    }

    protected void setComponent_updateQuery() throws Exception {
        this.conditionPane = new XdtsUpdateQueryConditionPane(this.stage, this.mode);
        this.titledPane2.setContentNode((Node)this.conditionPane);
    }

    protected void setComponent_createCreateTableSql() throws Exception {
        this.conditionPane = new XdtsCreateCraeteTableQueryConditionPane(this.stage, this.profile.productId);
        this.titledPane2.setContentNode((Node)this.conditionPane);
    }

    protected void setComponent_createInsertSql() throws Exception {
        this.conditionPane = new XdtsCopyRecordConditionPane(this.stage, this.mode, this.profile.productId);
        this.titledPane2.setContentNode((Node)this.conditionPane);
    }

    protected void setComponent_copyToOther() throws Exception {
        this.conditionPane = new XdtsCopyRecordConditionPane(this.stage, this.mode, -1);
        this.titledPane2.setContentNode((Node)this.conditionPane);
    }

    @Override
    public void actionPerformed(ActionEvent ev) throws Exception {
        super.actionPerformed(ev);
        if (ev.getSource().hashCode() == this.executeButton.hashCode()) {
            XdtsProcessCondition processCondition = new XdtsProcessCondition();
            processCondition.profileId = this.profile.getDataId();
            processCondition.schemaObjectList = this.schemaObjectSelectionPane.getSelecteSchemaObjectList();
            this.conditionPane.storeCondition(processCondition);
            BcResult result = new BcResult();
            if (BcCollectionUtil.isEmpty(processCondition.schemaObjectList)) {
                result.addError(XdtsWords.getInstance().\u5bfe\u8c61\u306e\u30b9\u30ad\u30fc\u30de\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u304c\u9078\u629e\u3055\u308c\u3066\u3044\u307e\u305b\u3093);
            }
            switch (this.mode) {
                case tableManipulation: {
                    if (!BcStringUtil.isEmpty(processCondition.query)) break;
                    result.addError(XdtsWords.getInstance().\u30b9\u30c6\u30fc\u30c8\u30e1\u30f3\u30c8\u304c\u691c\u51fa\u3067\u307e\u305b\u3093);
                }
            }
            if (result.hasError()) {
                String msg = BcMessageCreator.getInstance().createMessage(result.getErrorList());
                FxOptionPane.showMessageDialog((Window)this.stage, (Object)msg, BcWords.getInstance().warning, 2);
                return;
            }
            String msg = "\u672c\u5f53\u306b\u5b9f\u884c\u3057\u3066\u3088\u308d\u3057\u3044\u3067\u3059\u304b\uff1f";
            if (FxOptionPane.showConfirmDialog((Window)this.stage, (Object)msg, BcWords.getInstance().warning, 3) != 0) {
                return;
            }
            switch (this.mode) {
                case createCreateTableSql: {
                    XdtsSchemaStub.getInstance().createCrateTableSql(processCondition, this.title);
                    break;
                }
                case createInsertSql: {
                    XdtsSchemaStub.getInstance().createInsertSql(processCondition, this.title, (Window)this.stage);
                    break;
                }
                case dropTable: 
                case truncateTable: 
                case tableManipulation: 
                case dropView: {
                    XdtsSchemaStub.getInstance().updateQuery(processCondition, this.title, (Window)this.stage);
                    break;
                }
                case copyToOtherDb: {
                    XdtsSchemaStub.getInstance().copyToOther(processCondition, this.title, (Window)this.stage);
                }
            }
            if (this.eventHandler != null) {
                ActionEvent actionEvent = new ActionEvent();
                this.eventHandler.handle((Event)actionEvent);
            }
        }
    }

    @Override
    protected void windowShown() throws Exception {
        this.conditionPane.requestFocus();
    }

    public static enum Mode {
        createCreateTableSql(XdtsWords.getInstance().createCreateTableSql),
        createInsertSql(XdtsWords.getInstance().createInsertSql),
        dropTable(SqlWords.getInstance().sql_DROP_TABLE),
        truncateTable(SqlWords.getInstance().sql_TRUNCATE_TABLE),
        tableManipulation("????"),
        dropView(SqlWords.getInstance().sql_DROP_VIEW),
        copyToOtherDb(XdtsWords.getInstance().copyToOtherDb);

        public final String title;

        private Mode(String title) {
            this.title = title;
        }
    }
}

