/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.json;

import com.fasterxml.jackson.core.io.CharacterEscapes;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import ext.lib.json.JacksonCharacterEscapes;
import ext.lib.json.JsonNodeVisitorForString;

public class JacksonUtil {
    private static ObjectMapper objectMapper = new ObjectMapper();

    private JacksonUtil() {
        objectMapper.getFactory().setCharacterEscapes((CharacterEscapes)new JacksonCharacterEscapes());
    }

    public static ObjectMapper getObjectMapper() throws Exception {
        return objectMapper;
    }

    public static void put(JsonNode jsonNodeParent, String fieldName, String value) {
        ObjectNode objectNode = (ObjectNode)jsonNodeParent;
        objectNode.put(fieldName, value);
    }

    public static String toString(JsonNode jsonNode) throws Exception {
        JsonNodeVisitorForString jsonNodeVisitor = new JsonNodeVisitorForString();
        return jsonNodeVisitor.toStringBuilder(jsonNode).toString();
    }

    public static enum NodeName {
        root;

    }
}

