/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.expression;

import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.expression.RowConstructor;
import net.sf.jsqlparser.parser.ASTNodeAccessImpl;
import net.sf.jsqlparser.statement.create.table.ColDataType;

public class SafeCastExpression
extends ASTNodeAccessImpl
implements Expression {
    private Expression leftExpression;
    private ColDataType type;
    private RowConstructor rowConstructor;
    private boolean useCastKeyword = true;

    public RowConstructor getRowConstructor() {
        return this.rowConstructor;
    }

    public void setRowConstructor(RowConstructor rowConstructor) {
        this.rowConstructor = rowConstructor;
        this.type = null;
    }

    public SafeCastExpression withRowConstructor(RowConstructor rowConstructor) {
        this.setRowConstructor(rowConstructor);
        return this;
    }

    public ColDataType getType() {
        return this.type;
    }

    public void setType(ColDataType type) {
        this.type = type;
        this.rowConstructor = null;
    }

    public Expression getLeftExpression() {
        return this.leftExpression;
    }

    public void setLeftExpression(Expression expression) {
        this.leftExpression = expression;
    }

    @Override
    public void accept(ExpressionVisitor expressionVisitor) {
        expressionVisitor.visit(this);
    }

    public boolean isUseCastKeyword() {
        return this.useCastKeyword;
    }

    public void setUseCastKeyword(boolean useCastKeyword) {
        this.useCastKeyword = useCastKeyword;
    }

    public String toString() {
        if (this.useCastKeyword) {
            return this.rowConstructor != null ? "SAFE_CAST(" + this.leftExpression + " AS " + this.rowConstructor.toString() + ")" : "SAFE_CAST(" + this.leftExpression + " AS " + this.type.toString() + ")";
        }
        return this.leftExpression + "::" + this.type.toString();
    }

    public SafeCastExpression withType(ColDataType type) {
        this.setType(type);
        return this;
    }

    public SafeCastExpression withUseCastKeyword(boolean useCastKeyword) {
        this.setUseCastKeyword(useCastKeyword);
        return this;
    }

    public SafeCastExpression withLeftExpression(Expression leftExpression) {
        this.setLeftExpression(leftExpression);
        return this;
    }

    public <E extends Expression> E getLeftExpression(Class<E> type) {
        return (E)((Expression)type.cast(this.getLeftExpression()));
    }
}

