/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.model;

import java.util.HashSet;
import java.util.Locale;
import org.apache.commons.jxpath.AbstractFactory;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.JXPathException;
import org.apache.commons.jxpath.NodeSet;
import org.apache.commons.jxpath.Pointer;
import org.apache.commons.jxpath.ri.JXPathContextReferenceImpl;
import org.apache.commons.jxpath.ri.NamespaceResolver;
import org.apache.commons.jxpath.ri.QName;
import org.apache.commons.jxpath.ri.compiler.NodeNameTest;
import org.apache.commons.jxpath.ri.compiler.NodeTest;
import org.apache.commons.jxpath.ri.compiler.NodeTypeTest;
import org.apache.commons.jxpath.ri.model.NodeIterator;
import org.apache.commons.jxpath.ri.model.NodePointerFactory;
import org.apache.commons.jxpath.ri.model.beans.NullPointer;

public abstract class NodePointer
implements Pointer {
    public static final int WHOLE_COLLECTION = Integer.MIN_VALUE;
    public static final String UNKNOWN_NAMESPACE = "<<unknown namespace>>";
    protected int index = Integer.MIN_VALUE;
    private boolean attribute = false;
    private NamespaceResolver namespaceResolver;
    private transient Object rootNode;
    protected NodePointer parent;
    protected Locale locale;

    public static NodePointer newNodePointer(QName name, Object bean, Locale locale) {
        NodePointer pointer = null;
        if (bean == null) {
            pointer = new NullPointer(name, locale);
            return pointer;
        }
        NodePointerFactory[] factories = JXPathContextReferenceImpl.getNodePointerFactories();
        int i = 0;
        while (i < factories.length) {
            pointer = factories[i].createNodePointer(name, bean, locale);
            if (pointer != null) {
                return pointer;
            }
            ++i;
        }
        throw new JXPathException("Could not allocate a NodePointer for object of " + bean.getClass());
    }

    public static NodePointer newChildNodePointer(NodePointer parent, QName name, Object bean) {
        NodePointerFactory[] factories = JXPathContextReferenceImpl.getNodePointerFactories();
        int i = 0;
        while (i < factories.length) {
            NodePointer pointer = factories[i].createNodePointer(parent, name, bean);
            if (pointer != null) {
                return pointer;
            }
            ++i;
        }
        throw new JXPathException("Could not allocate a NodePointer for object of " + bean.getClass());
    }

    protected NodePointer(NodePointer parent) {
        this.parent = parent;
    }

    protected NodePointer(NodePointer parent, Locale locale) {
        this.parent = parent;
        this.locale = locale;
    }

    public NamespaceResolver getNamespaceResolver() {
        if (this.namespaceResolver == null && this.parent != null) {
            this.namespaceResolver = this.parent.getNamespaceResolver();
        }
        return this.namespaceResolver;
    }

    public void setNamespaceResolver(NamespaceResolver namespaceResolver) {
        this.namespaceResolver = namespaceResolver;
    }

    public NodePointer getParent() {
        NodePointer pointer = this.parent;
        while (pointer != null && pointer.isContainer()) {
            pointer = pointer.getImmediateParentPointer();
        }
        return pointer;
    }

    public NodePointer getImmediateParentPointer() {
        return this.parent;
    }

    public void setAttribute(boolean attribute) {
        this.attribute = attribute;
    }

    public boolean isAttribute() {
        return this.attribute;
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public abstract boolean isLeaf();

    public boolean isNode() {
        return !this.isContainer();
    }

    public boolean isContainer() {
        return false;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public abstract boolean isCollection();

    public abstract int getLength();

    @Override
    public Object getValue() {
        NodePointer valuePointer = this.getValuePointer();
        if (valuePointer != this) {
            return valuePointer.getValue();
        }
        return this.getNode();
    }

    public NodePointer getValuePointer() {
        NodePointer ivp = this.getImmediateValuePointer();
        return ivp == this ? this : ivp.getValuePointer();
    }

    public NodePointer getImmediateValuePointer() {
        return this;
    }

    public boolean isActual() {
        return this.index == Integer.MIN_VALUE || this.index >= 0 && this.index < this.getLength();
    }

    public abstract QName getName();

    public abstract Object getBaseValue();

    public Object getNodeValue() {
        return this.getNode();
    }

    @Override
    public Object getNode() {
        return this.getValuePointer().getImmediateNode();
    }

    @Override
    public synchronized Object getRootNode() {
        if (this.rootNode == null) {
            this.rootNode = this.parent == null ? this.getImmediateNode() : this.parent.getRootNode();
        }
        return this.rootNode;
    }

    public abstract Object getImmediateNode();

    @Override
    public abstract void setValue(Object var1);

    public abstract int compareChildNodePointers(NodePointer var1, NodePointer var2);

    public boolean testNode(NodeTest test) {
        if (test == null) {
            return true;
        }
        if (test instanceof NodeNameTest) {
            String nodeNS;
            String testNS;
            String nodePrefix;
            if (this.isContainer()) {
                return false;
            }
            NodeNameTest nodeNameTest = (NodeNameTest)test;
            QName testName = nodeNameTest.getNodeName();
            QName nodeName = this.getName();
            if (nodeName == null) {
                return false;
            }
            String testPrefix = testName.getPrefix();
            if (!NodePointer.equalStrings(testPrefix, nodePrefix = nodeName.getPrefix()) && !NodePointer.equalStrings(testNS = this.getNamespaceURI(testPrefix), nodeNS = this.getNamespaceURI(nodePrefix))) {
                return false;
            }
            if (nodeNameTest.isWildcard()) {
                return true;
            }
            return testName.getName().equals(nodeName.getName());
        }
        return test instanceof NodeTypeTest && ((NodeTypeTest)test).getNodeType() == 1 && this.isNode();
    }

    private static boolean equalStrings(String s1, String s2) {
        return s1 == s2 || s1 != null && s1.equals(s2);
    }

    public NodePointer createPath(JXPathContext context, Object value) {
        this.setValue(value);
        return this;
    }

    public void remove() {
    }

    public NodePointer createPath(JXPathContext context) {
        return this;
    }

    public NodePointer createChild(JXPathContext context, QName name, int index, Object value) {
        throw new JXPathException("Cannot create an object for path " + this.asPath() + "/" + name + "[" + (index + 1) + "]" + ", operation is not allowed for this type of node");
    }

    public NodePointer createChild(JXPathContext context, QName name, int index) {
        throw new JXPathException("Cannot create an object for path " + this.asPath() + "/" + name + "[" + (index + 1) + "]" + ", operation is not allowed for this type of node");
    }

    public NodePointer createAttribute(JXPathContext context, QName name) {
        throw new JXPathException("Cannot create an attribute for path " + this.asPath() + "/@" + name + ", operation is not allowed for this type of node");
    }

    public Locale getLocale() {
        if (this.locale == null && this.parent != null) {
            this.locale = this.parent.getLocale();
        }
        return this.locale;
    }

    public boolean isLanguage(String lang) {
        Locale loc = this.getLocale();
        String name = loc.toString().replace('_', '-');
        return name.toUpperCase(Locale.ENGLISH).startsWith(lang.toUpperCase(Locale.ENGLISH));
    }

    public NodeIterator childIterator(NodeTest test, boolean reverse, NodePointer startWith) {
        NodePointer valuePointer = this.getValuePointer();
        return valuePointer == null || valuePointer == this ? null : valuePointer.childIterator(test, reverse, startWith);
    }

    public NodeIterator attributeIterator(QName qname) {
        NodePointer valuePointer = this.getValuePointer();
        return valuePointer == null || valuePointer == this ? null : valuePointer.attributeIterator(qname);
    }

    public NodeIterator namespaceIterator() {
        return null;
    }

    public NodePointer namespacePointer(String namespace) {
        return null;
    }

    public String getNamespaceURI(String prefix) {
        return null;
    }

    public String getNamespaceURI() {
        return null;
    }

    protected boolean isDefaultNamespace(String prefix) {
        if (prefix == null) {
            return true;
        }
        String namespace = this.getNamespaceURI(prefix);
        return namespace != null && namespace.equals(this.getDefaultNamespaceURI());
    }

    protected String getDefaultNamespaceURI() {
        return null;
    }

    public Pointer getPointerByID(JXPathContext context, String id) {
        return context.getPointerByID(id);
    }

    public Pointer getPointerByKey(JXPathContext context, String key, String value) {
        return context.getPointerByKey(key, value);
    }

    public NodeSet getNodeSetByKey(JXPathContext context, String key, Object value) {
        return context.getNodeSetByKey(key, value);
    }

    @Override
    public String asPath() {
        if (this.parent != null && this.parent.isContainer()) {
            return this.parent.asPath();
        }
        StringBuffer buffer = new StringBuffer();
        if (this.parent != null) {
            buffer.append(this.parent.asPath());
        }
        if (buffer.length() == 0 || buffer.charAt(buffer.length() - 1) != '/') {
            buffer.append('/');
        }
        if (this.attribute) {
            buffer.append('@');
        }
        buffer.append(this.getName());
        if (this.index != Integer.MIN_VALUE && this.isCollection()) {
            buffer.append('[').append(this.index + 1).append(']');
        }
        return buffer.toString();
    }

    @Override
    public Object clone() {
        try {
            NodePointer ptr = (NodePointer)super.clone();
            if (this.parent != null) {
                ptr.parent = (NodePointer)this.parent.clone();
            }
            return ptr;
        }
        catch (CloneNotSupportedException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public String toString() {
        return this.asPath();
    }

    public int compareTo(Object object) {
        if (object == this) {
            return 0;
        }
        NodePointer pointer = (NodePointer)object;
        if (this.parent == pointer.parent) {
            return this.parent == null ? 0 : this.parent.compareChildNodePointers(this, pointer);
        }
        int depth1 = 0;
        NodePointer p1 = this;
        HashSet<NodePointer> parents1 = new HashSet<NodePointer>();
        while (p1 != null) {
            ++depth1;
            p1 = p1.parent;
            if (p1 == null) continue;
            parents1.add(p1);
        }
        boolean commonParentFound = false;
        int depth2 = 0;
        NodePointer p2 = pointer;
        while (p2 != null) {
            ++depth2;
            p2 = p2.parent;
            if (!parents1.contains(p2)) continue;
            commonParentFound = true;
        }
        return commonParentFound ? this.compareNodePointers(this, depth1, pointer, depth2) : 0;
    }

    private int compareNodePointers(NodePointer p1, int depth1, NodePointer p2, int depth2) {
        if (depth1 < depth2) {
            int r = this.compareNodePointers(p1, depth1, p2.parent, depth2 - 1);
            return r == 0 ? -1 : r;
        }
        if (depth1 > depth2) {
            int r = this.compareNodePointers(p1.parent, depth1 - 1, p2, depth2);
            return r == 0 ? 1 : r;
        }
        if (p1 == p2 || p1 != null && p1.equals(p2)) {
            return 0;
        }
        if (depth1 == 1) {
            throw new JXPathException("Cannot compare pointers that do not belong to the same tree: '" + p1 + "' and '" + p2 + "'");
        }
        int r = this.compareNodePointers(p1.parent, depth1 - 1, p2.parent, depth2 - 1);
        return r == 0 ? p1.parent.compareChildNodePointers(p1, p2) : r;
    }

    public void printPointerChain() {
        NodePointer.printDeep(this, "");
    }

    protected String escape(String string) {
        char[] c = new char[]{'\'', '\"'};
        String[] esc = new String[]{"&apos;", "&quot;"};
        StringBuffer sb = null;
        int i = 0;
        while (sb == null && i < c.length) {
            if (string.indexOf(c[i]) >= 0) {
                sb = new StringBuffer(string);
            }
            ++i;
        }
        if (sb == null) {
            return string;
        }
        i = 0;
        while (i < c.length) {
            if (string.indexOf(c[i]) >= 0) {
                int pos = 0;
                while (pos < sb.length()) {
                    if (sb.charAt(pos) == c[i]) {
                        sb.replace(pos, pos + 1, esc[i]);
                        pos += esc[i].length();
                        continue;
                    }
                    ++pos;
                }
            }
            ++i;
        }
        return sb.toString();
    }

    protected AbstractFactory getAbstractFactory(JXPathContext context) {
        AbstractFactory factory = context.getFactory();
        if (factory == null) {
            throw new JXPathException("Factory is not set on the JXPathContext - cannot create path: " + this.asPath());
        }
        return factory;
    }

    private static void printDeep(NodePointer pointer, String indent) {
        if (indent.length() == 0) {
            System.err.println("POINTER: " + pointer + "(" + pointer.getClass().getName() + ")");
        } else {
            System.err.println(String.valueOf(indent) + " of " + pointer + "(" + pointer.getClass().getName() + ")");
        }
        if (pointer.getImmediateParentPointer() != null) {
            NodePointer.printDeep(pointer.getImmediateParentPointer(), String.valueOf(indent) + "  ");
        }
    }
}

