/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.util.ClassPath;
import org.apache.bcel.util.Repository;

public class ClassLoaderRepository
implements Repository {
    private final ClassLoader loader;
    private final Map<String, JavaClass> loadedClasses = new HashMap<String, JavaClass>();

    public ClassLoaderRepository(ClassLoader loader) {
        this.loader = loader;
    }

    @Override
    public void storeClass(JavaClass clazz) {
        this.loadedClasses.put(clazz.getClassName(), clazz);
        clazz.setRepository(this);
    }

    @Override
    public void removeClass(JavaClass clazz) {
        this.loadedClasses.remove(clazz.getClassName());
    }

    @Override
    public JavaClass findClass(String className) {
        return this.loadedClasses.containsKey(className) ? this.loadedClasses.get(className) : null;
    }

    @Override
    public JavaClass loadClass(String className) throws ClassNotFoundException {
        String classFile = className.replace('.', '/');
        JavaClass RC = this.findClass(className);
        if (RC != null) {
            return RC;
        }
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (InputStream is = this.loader.getResourceAsStream(String.valueOf(classFile) + ".class");){
                if (is == null) {
                    throw new ClassNotFoundException(String.valueOf(className) + " not found.");
                }
                ClassParser parser = new ClassParser(is, className);
                RC = parser.parse();
                this.storeClass(RC);
                return RC;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new ClassNotFoundException(String.valueOf(className) + " not found: " + e, e);
        }
    }

    @Override
    public JavaClass loadClass(Class<?> clazz) throws ClassNotFoundException {
        return this.loadClass(clazz.getName());
    }

    @Override
    public void clear() {
        this.loadedClasses.clear();
    }

    @Override
    public ClassPath getClassPath() {
        return null;
    }
}

