/*
 * Decompiled with CFR 0.152.
 */
package nlc.lib.barcode;

import java.io.BufferedInputStream;
import java.io.InputStream;

public class DcfQrcode {
    static final String QRCODE_DATA_PATH = "qrcode_data";
    char qrcodeErrorCorrect = (char)77;
    char qrcodeEncodeMode = (char)66;
    int qrcodeVersion = 0;
    int qrcodeStructureappendN = 0;
    int qrcodeStructureappendM = 0;
    int qrcodeStructureappendParity = 0;
    String qrcodeStructureappendOriginaldata = "";

    public void setQrcodeErrorCorrect(char ecc) {
        this.qrcodeErrorCorrect = ecc;
    }

    public char getQrcodeErrorCorrect() {
        return this.qrcodeErrorCorrect;
    }

    public int getQrcodeVersion() {
        return this.qrcodeVersion;
    }

    public void setQrcodeVersion(int ver) {
        if (ver >= 0 && ver <= 40) {
            this.qrcodeVersion = ver;
        }
    }

    public void setQrcodeEncodeMode(char encMode) {
        this.qrcodeEncodeMode = encMode;
    }

    public char getQrcodeEncodeMode() {
        return this.qrcodeEncodeMode;
    }

    public void setStructureappend(int m, int n, int p) {
        if (n > 1 && n <= 16 && m > 0 && m <= 16 && p >= 0 && p <= 255) {
            this.qrcodeStructureappendM = m;
            this.qrcodeStructureappendN = n;
            this.qrcodeStructureappendParity = p;
        }
    }

    public int calStructureappendParity(byte[] originaldata) {
        int i = 0;
        int structureappendParity = 0;
        int originaldataLength = originaldata.length;
        if (originaldataLength > 1) {
            structureappendParity = 0;
            while (i < originaldataLength) {
                structureappendParity ^= originaldata[i] & 0xFF;
                ++i;
            }
        } else {
            structureappendParity = -1;
        }
        return structureappendParity;
    }

    public boolean[][] calQrcode(byte[] qrcodeData) {
        int ec;
        int codewordNumCounterValue;
        int[] codewordNumPlus;
        int dataCounter = 0;
        int dataLength = qrcodeData.length;
        int[] dataValue = new int[dataLength + 32];
        byte[] dataBits = new byte[dataLength + 32];
        if (dataLength <= 0) {
            boolean[][] ret = new boolean[][]{new boolean[1]};
            return ret;
        }
        if (this.qrcodeStructureappendN > 1) {
            dataValue[0] = 3;
            dataBits[0] = 4;
            dataValue[1] = this.qrcodeStructureappendM - 1;
            dataBits[1] = 4;
            dataValue[2] = this.qrcodeStructureappendN - 1;
            dataBits[2] = 4;
            dataValue[3] = this.qrcodeStructureappendParity;
            dataBits[3] = 8;
            dataCounter = 4;
        }
        dataBits[dataCounter] = 4;
        switch (this.qrcodeEncodeMode) {
            case 'A': {
                int[] nArray = new int[41];
                nArray[10] = 2;
                nArray[11] = 2;
                nArray[12] = 2;
                nArray[13] = 2;
                nArray[14] = 2;
                nArray[15] = 2;
                nArray[16] = 2;
                nArray[17] = 2;
                nArray[18] = 2;
                nArray[19] = 2;
                nArray[20] = 2;
                nArray[21] = 2;
                nArray[22] = 2;
                nArray[23] = 2;
                nArray[24] = 2;
                nArray[25] = 2;
                nArray[26] = 2;
                nArray[27] = 4;
                nArray[28] = 4;
                nArray[29] = 4;
                nArray[30] = 4;
                nArray[31] = 4;
                nArray[32] = 4;
                nArray[33] = 4;
                nArray[34] = 4;
                nArray[35] = 4;
                nArray[36] = 4;
                nArray[37] = 4;
                nArray[38] = 4;
                nArray[39] = 4;
                nArray[40] = 4;
                codewordNumPlus = nArray;
                dataValue[dataCounter] = 2;
                dataValue[++dataCounter] = dataLength;
                dataBits[dataCounter] = 9;
                codewordNumCounterValue = dataCounter++;
                int i = 0;
                while (i < dataLength) {
                    char chr = (char)qrcodeData[i];
                    byte chrValue = 0;
                    if (chr >= '0' && chr < ':') {
                        chrValue = (byte)(chr - 48);
                    } else if (chr >= 'A' && chr < '[') {
                        chrValue = (byte)(chr - 55);
                    } else {
                        if (chr == ' ') {
                            chrValue = (byte)36;
                        }
                        if (chr == '$') {
                            chrValue = (byte)37;
                        }
                        if (chr == '%') {
                            chrValue = (byte)38;
                        }
                        if (chr == '*') {
                            chrValue = (byte)39;
                        }
                        if (chr == '+') {
                            chrValue = (byte)40;
                        }
                        if (chr == '-') {
                            chrValue = (byte)41;
                        }
                        if (chr == '.') {
                            chrValue = (byte)42;
                        }
                        if (chr == '/') {
                            chrValue = (byte)43;
                        }
                        if (chr == ':') {
                            chrValue = (byte)44;
                        }
                    }
                    if (i % 2 == 0) {
                        dataValue[dataCounter] = chrValue;
                        dataBits[dataCounter] = 6;
                    } else {
                        dataValue[dataCounter] = dataValue[dataCounter] * 45 + chrValue;
                        dataBits[dataCounter] = 11;
                        if (i < dataLength - 1) {
                            ++dataCounter;
                        }
                    }
                    ++i;
                }
                ++dataCounter;
                break;
            }
            case 'N': {
                int[] nArray = new int[41];
                nArray[10] = 2;
                nArray[11] = 2;
                nArray[12] = 2;
                nArray[13] = 2;
                nArray[14] = 2;
                nArray[15] = 2;
                nArray[16] = 2;
                nArray[17] = 2;
                nArray[18] = 2;
                nArray[19] = 2;
                nArray[20] = 2;
                nArray[21] = 2;
                nArray[22] = 2;
                nArray[23] = 2;
                nArray[24] = 2;
                nArray[25] = 2;
                nArray[26] = 2;
                nArray[27] = 4;
                nArray[28] = 4;
                nArray[29] = 4;
                nArray[30] = 4;
                nArray[31] = 4;
                nArray[32] = 4;
                nArray[33] = 4;
                nArray[34] = 4;
                nArray[35] = 4;
                nArray[36] = 4;
                nArray[37] = 4;
                nArray[38] = 4;
                nArray[39] = 4;
                nArray[40] = 4;
                codewordNumPlus = nArray;
                dataValue[dataCounter] = 1;
                dataValue[++dataCounter] = dataLength;
                dataBits[dataCounter] = 10;
                codewordNumCounterValue = dataCounter++;
                int i = 0;
                while (i < dataLength) {
                    if (i % 3 == 0) {
                        dataValue[dataCounter] = qrcodeData[i] - 48;
                        dataBits[dataCounter] = 4;
                    } else {
                        dataValue[dataCounter] = dataValue[dataCounter] * 10 + (qrcodeData[i] - 48);
                        if (i % 3 == 1) {
                            dataBits[dataCounter] = 7;
                        } else {
                            dataBits[dataCounter] = 10;
                            if (i < dataLength - 1) {
                                ++dataCounter;
                            }
                        }
                    }
                    ++i;
                }
                ++dataCounter;
                break;
            }
            default: {
                int[] nArray = new int[41];
                nArray[10] = 8;
                nArray[11] = 8;
                nArray[12] = 8;
                nArray[13] = 8;
                nArray[14] = 8;
                nArray[15] = 8;
                nArray[16] = 8;
                nArray[17] = 8;
                nArray[18] = 8;
                nArray[19] = 8;
                nArray[20] = 8;
                nArray[21] = 8;
                nArray[22] = 8;
                nArray[23] = 8;
                nArray[24] = 8;
                nArray[25] = 8;
                nArray[26] = 8;
                nArray[27] = 8;
                nArray[28] = 8;
                nArray[29] = 8;
                nArray[30] = 8;
                nArray[31] = 8;
                nArray[32] = 8;
                nArray[33] = 8;
                nArray[34] = 8;
                nArray[35] = 8;
                nArray[36] = 8;
                nArray[37] = 8;
                nArray[38] = 8;
                nArray[39] = 8;
                nArray[40] = 8;
                codewordNumPlus = nArray;
                dataValue[dataCounter] = 4;
                dataValue[++dataCounter] = dataLength;
                dataBits[dataCounter] = 8;
                codewordNumCounterValue = dataCounter++;
                int i = 0;
                while (i < dataLength) {
                    dataValue[i + dataCounter] = qrcodeData[i] & 0xFF;
                    dataBits[i + dataCounter] = 8;
                    ++i;
                }
                dataCounter += dataLength;
            }
        }
        int totalDataBits = 0;
        int i = 0;
        while (i < dataCounter) {
            totalDataBits += dataBits[i];
            ++i;
        }
        switch (this.qrcodeErrorCorrect) {
            case 'L': {
                ec = 1;
                break;
            }
            case 'Q': {
                ec = 3;
                break;
            }
            case 'H': {
                ec = 2;
                break;
            }
            default: {
                ec = 0;
            }
        }
        int[][] nArrayArray = new int[4][];
        int[] nArray = new int[41];
        nArray[1] = 128;
        nArray[2] = 224;
        nArray[3] = 352;
        nArray[4] = 512;
        nArray[5] = 688;
        nArray[6] = 864;
        nArray[7] = 992;
        nArray[8] = 1232;
        nArray[9] = 1456;
        nArray[10] = 1728;
        nArray[11] = 2032;
        nArray[12] = 2320;
        nArray[13] = 2672;
        nArray[14] = 2920;
        nArray[15] = 3320;
        nArray[16] = 3624;
        nArray[17] = 4056;
        nArray[18] = 4504;
        nArray[19] = 5016;
        nArray[20] = 5352;
        nArray[21] = 5712;
        nArray[22] = 6256;
        nArray[23] = 6880;
        nArray[24] = 7312;
        nArray[25] = 8000;
        nArray[26] = 8496;
        nArray[27] = 9024;
        nArray[28] = 9544;
        nArray[29] = 10136;
        nArray[30] = 10984;
        nArray[31] = 11640;
        nArray[32] = 12328;
        nArray[33] = 13048;
        nArray[34] = 13800;
        nArray[35] = 14496;
        nArray[36] = 15312;
        nArray[37] = 15936;
        nArray[38] = 16816;
        nArray[39] = 17728;
        nArray[40] = 18672;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[41];
        nArray2[1] = 152;
        nArray2[2] = 272;
        nArray2[3] = 440;
        nArray2[4] = 640;
        nArray2[5] = 864;
        nArray2[6] = 1088;
        nArray2[7] = 1248;
        nArray2[8] = 1552;
        nArray2[9] = 1856;
        nArray2[10] = 2192;
        nArray2[11] = 2592;
        nArray2[12] = 2960;
        nArray2[13] = 3424;
        nArray2[14] = 3688;
        nArray2[15] = 4184;
        nArray2[16] = 4712;
        nArray2[17] = 5176;
        nArray2[18] = 5768;
        nArray2[19] = 6360;
        nArray2[20] = 6888;
        nArray2[21] = 7456;
        nArray2[22] = 8048;
        nArray2[23] = 8752;
        nArray2[24] = 9392;
        nArray2[25] = 10208;
        nArray2[26] = 10960;
        nArray2[27] = 11744;
        nArray2[28] = 12248;
        nArray2[29] = 13048;
        nArray2[30] = 13880;
        nArray2[31] = 14744;
        nArray2[32] = 15640;
        nArray2[33] = 16568;
        nArray2[34] = 17528;
        nArray2[35] = 18448;
        nArray2[36] = 19472;
        nArray2[37] = 20528;
        nArray2[38] = 21616;
        nArray2[39] = 22496;
        nArray2[40] = 23648;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[41];
        nArray3[1] = 72;
        nArray3[2] = 128;
        nArray3[3] = 208;
        nArray3[4] = 288;
        nArray3[5] = 368;
        nArray3[6] = 480;
        nArray3[7] = 528;
        nArray3[8] = 688;
        nArray3[9] = 800;
        nArray3[10] = 976;
        nArray3[11] = 1120;
        nArray3[12] = 1264;
        nArray3[13] = 1440;
        nArray3[14] = 1576;
        nArray3[15] = 1784;
        nArray3[16] = 2024;
        nArray3[17] = 2264;
        nArray3[18] = 2504;
        nArray3[19] = 2728;
        nArray3[20] = 3080;
        nArray3[21] = 3248;
        nArray3[22] = 3536;
        nArray3[23] = 3712;
        nArray3[24] = 4112;
        nArray3[25] = 4304;
        nArray3[26] = 4768;
        nArray3[27] = 5024;
        nArray3[28] = 5288;
        nArray3[29] = 5608;
        nArray3[30] = 5960;
        nArray3[31] = 6344;
        nArray3[32] = 6760;
        nArray3[33] = 7208;
        nArray3[34] = 7688;
        nArray3[35] = 7888;
        nArray3[36] = 8432;
        nArray3[37] = 8768;
        nArray3[38] = 9136;
        nArray3[39] = 9776;
        nArray3[40] = 10208;
        nArrayArray[2] = nArray3;
        int[] nArray4 = new int[41];
        nArray4[1] = 104;
        nArray4[2] = 176;
        nArray4[3] = 272;
        nArray4[4] = 384;
        nArray4[5] = 496;
        nArray4[6] = 608;
        nArray4[7] = 704;
        nArray4[8] = 880;
        nArray4[9] = 1056;
        nArray4[10] = 1232;
        nArray4[11] = 1440;
        nArray4[12] = 1648;
        nArray4[13] = 1952;
        nArray4[14] = 2088;
        nArray4[15] = 2360;
        nArray4[16] = 2600;
        nArray4[17] = 2936;
        nArray4[18] = 3176;
        nArray4[19] = 3560;
        nArray4[20] = 3880;
        nArray4[21] = 4096;
        nArray4[22] = 4544;
        nArray4[23] = 4912;
        nArray4[24] = 5312;
        nArray4[25] = 5744;
        nArray4[26] = 6032;
        nArray4[27] = 6464;
        nArray4[28] = 6968;
        nArray4[29] = 7288;
        nArray4[30] = 7880;
        nArray4[31] = 8264;
        nArray4[32] = 8920;
        nArray4[33] = 9368;
        nArray4[34] = 9848;
        nArray4[35] = 10288;
        nArray4[36] = 10832;
        nArray4[37] = 11408;
        nArray4[38] = 12016;
        nArray4[39] = 12656;
        nArray4[40] = 13328;
        nArrayArray[3] = nArray4;
        int[][] maxDataBitsArray = nArrayArray;
        int maxDataBits = 0;
        if (this.qrcodeVersion == 0) {
            this.qrcodeVersion = 1;
            int i2 = 1;
            while (i2 <= 40) {
                if (maxDataBitsArray[ec][i2] >= totalDataBits + codewordNumPlus[this.qrcodeVersion]) {
                    maxDataBits = maxDataBitsArray[ec][i2];
                    break;
                }
                ++this.qrcodeVersion;
                ++i2;
            }
        } else {
            maxDataBits = maxDataBitsArray[ec][this.qrcodeVersion];
        }
        totalDataBits += codewordNumPlus[this.qrcodeVersion];
        int n = codewordNumCounterValue;
        dataBits[n] = (byte)(dataBits[n] + codewordNumPlus[this.qrcodeVersion]);
        int[] nArray5 = new int[41];
        nArray5[1] = 26;
        nArray5[2] = 44;
        nArray5[3] = 70;
        nArray5[4] = 100;
        nArray5[5] = 134;
        nArray5[6] = 172;
        nArray5[7] = 196;
        nArray5[8] = 242;
        nArray5[9] = 292;
        nArray5[10] = 346;
        nArray5[11] = 404;
        nArray5[12] = 466;
        nArray5[13] = 532;
        nArray5[14] = 581;
        nArray5[15] = 655;
        nArray5[16] = 733;
        nArray5[17] = 815;
        nArray5[18] = 901;
        nArray5[19] = 991;
        nArray5[20] = 1085;
        nArray5[21] = 1156;
        nArray5[22] = 1258;
        nArray5[23] = 1364;
        nArray5[24] = 1474;
        nArray5[25] = 1588;
        nArray5[26] = 1706;
        nArray5[27] = 1828;
        nArray5[28] = 1921;
        nArray5[29] = 2051;
        nArray5[30] = 2185;
        nArray5[31] = 2323;
        nArray5[32] = 2465;
        nArray5[33] = 2611;
        nArray5[34] = 2761;
        nArray5[35] = 2876;
        nArray5[36] = 3034;
        nArray5[37] = 3196;
        nArray5[38] = 3362;
        nArray5[39] = 3532;
        nArray5[40] = 3706;
        int[] maxCodewordsArray = nArray5;
        int maxCodewords = maxCodewordsArray[this.qrcodeVersion];
        int maxModules1side = 17 + (this.qrcodeVersion << 2);
        int[] nArray6 = new int[41];
        nArray6[2] = 7;
        nArray6[3] = 7;
        nArray6[4] = 7;
        nArray6[5] = 7;
        nArray6[6] = 7;
        nArray6[14] = 3;
        nArray6[15] = 3;
        nArray6[16] = 3;
        nArray6[17] = 3;
        nArray6[18] = 3;
        nArray6[19] = 3;
        nArray6[20] = 3;
        nArray6[21] = 4;
        nArray6[22] = 4;
        nArray6[23] = 4;
        nArray6[24] = 4;
        nArray6[25] = 4;
        nArray6[26] = 4;
        nArray6[27] = 4;
        nArray6[28] = 3;
        nArray6[29] = 3;
        nArray6[30] = 3;
        nArray6[31] = 3;
        nArray6[32] = 3;
        nArray6[33] = 3;
        nArray6[34] = 3;
        int[] matrixRemainBit = nArray6;
        int byte_num = matrixRemainBit[this.qrcodeVersion] + (maxCodewords << 3);
        byte[] matrixX = new byte[byte_num];
        byte[] matrixY = new byte[byte_num];
        byte[] maskArray = new byte[byte_num];
        byte[] formatInformationX2 = new byte[15];
        byte[] formatInformationY2 = new byte[15];
        byte[] rsEccCodewords = new byte[1];
        byte[] rsBlockOrderTemp = new byte[128];
        try {
            String filename = "qrcode_data/qrv" + Integer.toString(this.qrcodeVersion) + "_" + Integer.toString(ec) + ".dat";
            InputStream fis = DcfQrcode.class.getResourceAsStream(filename);
            BufferedInputStream bis = new BufferedInputStream(fis);
            bis.read(matrixX);
            bis.read(matrixY);
            bis.read(maskArray);
            bis.read(formatInformationX2);
            bis.read(formatInformationY2);
            bis.read(rsEccCodewords);
            bis.read(rsBlockOrderTemp);
            bis.close();
            fis.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int rsBlockOrderLength = 1;
        int i3 = 1;
        while (i3 < 128) {
            if (rsBlockOrderTemp[i3] == 0) {
                rsBlockOrderLength = i3;
                break;
            }
            i3 = (byte)(i3 + 1);
        }
        byte[] rsBlockOrder = new byte[rsBlockOrderLength];
        System.arraycopy(rsBlockOrderTemp, 0, rsBlockOrder, 0, rsBlockOrderLength);
        byte[] byArray = new byte[15];
        byArray[1] = 1;
        byArray[2] = 2;
        byArray[3] = 3;
        byArray[4] = 4;
        byArray[5] = 5;
        byArray[6] = 7;
        byArray[7] = 8;
        byArray[8] = 8;
        byArray[9] = 8;
        byArray[10] = 8;
        byArray[11] = 8;
        byArray[12] = 8;
        byArray[13] = 8;
        byArray[14] = 8;
        byte[] formatInformationX1 = byArray;
        byte[] byArray2 = new byte[15];
        byArray2[0] = 8;
        byArray2[1] = 8;
        byArray2[2] = 8;
        byArray2[3] = 8;
        byArray2[4] = 8;
        byArray2[5] = 8;
        byArray2[6] = 8;
        byArray2[7] = 8;
        byArray2[8] = 7;
        byArray2[9] = 5;
        byArray2[10] = 4;
        byArray2[11] = 3;
        byArray2[12] = 2;
        byArray2[13] = 1;
        byte[] formatInformationY1 = byArray2;
        int maxDataCodewords = maxDataBits >> 3;
        int modules1Side = 4 * this.qrcodeVersion + 17;
        int matrixTotalBits = modules1Side * modules1Side;
        byte[] frameData = new byte[matrixTotalBits + modules1Side];
        try {
            String filename = "qrcode_data/qrvfr" + Integer.toString(this.qrcodeVersion) + ".dat";
            InputStream fis = DcfQrcode.class.getResourceAsStream(filename);
            BufferedInputStream bis = new BufferedInputStream(fis);
            bis.read(frameData);
            bis.close();
            fis.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (totalDataBits <= maxDataBits - 4) {
            dataValue[dataCounter] = 0;
            dataBits[dataCounter] = 4;
        } else if (totalDataBits < maxDataBits) {
            dataValue[dataCounter] = 0;
            dataBits[dataCounter] = (byte)(maxDataBits - totalDataBits);
        } else if (totalDataBits > maxDataBits) {
            System.out.println("overflow");
        }
        byte[] dataCodewords = DcfQrcode.divideDataBy8Bits(dataValue, dataBits, maxDataCodewords);
        byte[] codewords = DcfQrcode.calculateRSECC(dataCodewords, rsEccCodewords[0], rsBlockOrder, maxDataCodewords, maxCodewords);
        byte[][] matrixContent = new byte[modules1Side][modules1Side];
        int i4 = 0;
        while (i4 < modules1Side) {
            int j = 0;
            while (j < modules1Side) {
                matrixContent[j][i4] = 0;
                ++j;
            }
            ++i4;
        }
        i4 = 0;
        while (i4 < maxCodewords) {
            byte codeword_i = codewords[i4];
            int j = 7;
            while (j >= 0) {
                int codewordBitsNumber = i4 * 8 + j;
                matrixContent[matrixX[codewordBitsNumber] & 0xFF][matrixY[codewordBitsNumber] & 0xFF] = (byte)(255 * (codeword_i & 1) ^ maskArray[codewordBitsNumber]);
                codeword_i = (byte)((codeword_i & 0xFF) >>> 1);
                --j;
            }
            ++i4;
        }
        int matrixRemain = matrixRemainBit[this.qrcodeVersion];
        while (matrixRemain > 0) {
            int remainBitTemp = matrixRemain + maxCodewords * 8 - 1;
            matrixContent[matrixX[remainBitTemp] & 0xFF][matrixY[remainBitTemp] & 0xFF] = (byte)(0xFF ^ maskArray[remainBitTemp]);
            --matrixRemain;
        }
        byte maskNumber = DcfQrcode.selectMask(matrixContent, matrixRemainBit[this.qrcodeVersion] + maxCodewords * 8);
        byte maskContent = (byte)(1 << maskNumber);
        byte formatInformationValue = (byte)(ec << 3 | maskNumber);
        String[] formatInformationArray = new String[]{"101010000010010", "101000100100101", "101111001111100", "101101101001011", "100010111111001", "100000011001110", "100111110010111", "100101010100000", "111011111000100", "111001011110011", "111110110101010", "111100010011101", "110011000101111", "110001100011000", "110110001000001", "110100101110110", "001011010001001", "001001110111110", "001110011100111", "001100111010000", "000011101100010", "000001001010101", "000110100001100", "000100000111011", "011010101011111", "011000001101000", "011111100110001", "011101000000110", "010010010110100", "010000110000011", "010111011011010", "010101111101101"};
        int i5 = 0;
        while (i5 < 15) {
            byte content = Byte.parseByte(formatInformationArray[formatInformationValue].substring(i5, i5 + 1));
            matrixContent[formatInformationX1[i5] & 0xFF][formatInformationY1[i5] & 0xFF] = (byte)(content * 255);
            matrixContent[formatInformationX2[i5] & 0xFF][formatInformationY2[i5] & 0xFF] = (byte)(content * 255);
            ++i5;
        }
        boolean[][] out = new boolean[modules1Side][modules1Side];
        int c = 0;
        int i6 = 0;
        while (i6 < modules1Side) {
            int j = 0;
            while (j < modules1Side) {
                out[j][i6] = (matrixContent[j][i6] & maskContent) != 0 || frameData[c] == 49;
                ++c;
                ++j;
            }
            ++c;
            ++i6;
        }
        return out;
    }

    /*
     * Unable to fully structure code
     */
    protected static byte[] divideDataBy8Bits(int[] data, byte[] bits, int maxDataCodewords) {
        l1 = bits.length;
        codewordsCounter = 0;
        remainingBits = 8;
        max = 0;
        data.length;
        i = 0;
        while (i < l1) {
            max += bits[i];
            ++i;
        }
        l2 = (max - 1) / 8 + 1;
        codewords = new byte[maxDataCodewords];
        i = 0;
        while (i < l2) {
            codewords[i] = 0;
            ++i;
        }
        i = 0;
        while (i < l1) {
            buffer = data[i];
            bufferBits = bits[i];
            flag = true;
            if (bufferBits != 0) ** GOTO lbl39
            break;
lbl-1000:
            // 1 sources

            {
                if (remainingBits > bufferBits) {
                    codewords[codewordsCounter] = (byte)(codewords[codewordsCounter] << bufferBits | buffer);
                    remainingBits -= bufferBits;
                    flag = false;
                    continue;
                }
                codewords[codewordsCounter] = (byte)(codewords[codewordsCounter] << remainingBits | buffer >> (bufferBits -= remainingBits));
                if (bufferBits == 0) {
                    flag = false;
                } else {
                    buffer &= (1 << bufferBits) - 1;
                    flag = true;
                }
                ++codewordsCounter;
                remainingBits = 8;
lbl39:
                // 3 sources

                ** while (flag)
            }
lbl40:
            // 1 sources

            ++i;
        }
        if (remainingBits != 8) {
            codewords[codewordsCounter] = (byte)(codewords[codewordsCounter] << remainingBits);
        } else {
            --codewordsCounter;
        }
        if (codewordsCounter < maxDataCodewords - 1) {
            flag = true;
            while (codewordsCounter < maxDataCodewords - 1) {
                codewords[++codewordsCounter] = flag != false ? -20 : 17;
                v0 = flag = flag == false;
            }
        }
        return codewords;
    }

    protected static byte[] calculateRSECC(byte[] codewords, byte rsEccCodewords, byte[] rsBlockOrder, int maxDataCodewords, int maxCodewords) {
        byte[][] rsCalTableArray = new byte[256][rsEccCodewords];
        try {
            String filename = "qrcode_data/rsc" + Byte.toString(rsEccCodewords) + ".dat";
            InputStream fis = DcfQrcode.class.getResourceAsStream(filename);
            BufferedInputStream bis = new BufferedInputStream(fis);
            int i = 0;
            while (i < 256) {
                bis.read(rsCalTableArray[i]);
                ++i;
            }
            bis.close();
            fis.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int i = 0;
        int j = 0;
        int rsBlockNumber = 0;
        byte[][] rsTemp = new byte[rsBlockOrder.length][];
        byte[] res = new byte[maxCodewords];
        System.arraycopy(codewords, 0, res, 0, codewords.length);
        i = 0;
        while (i < rsBlockOrder.length) {
            rsTemp[i] = new byte[(rsBlockOrder[i] & 0xFF) - rsEccCodewords];
            ++i;
        }
        i = 0;
        while (i < maxDataCodewords) {
            rsTemp[rsBlockNumber][j] = codewords[i];
            if (++j >= (rsBlockOrder[rsBlockNumber] & 0xFF) - rsEccCodewords) {
                j = 0;
                ++rsBlockNumber;
            }
            ++i;
        }
        rsBlockNumber = 0;
        while (rsBlockNumber < rsBlockOrder.length) {
            int rsDataCodewords;
            byte[] rsTempData = (byte[])rsTemp[rsBlockNumber].clone();
            int rsCodewords = rsBlockOrder[rsBlockNumber] & 0xFF;
            j = rsDataCodewords = rsCodewords - rsEccCodewords;
            while (j > 0) {
                byte[] rsTempNew;
                byte first = rsTempData[0];
                if (first != 0) {
                    byte[] leftChr = new byte[rsTempData.length - 1];
                    System.arraycopy(rsTempData, 1, leftChr, 0, rsTempData.length - 1);
                    byte[] cal = rsCalTableArray[first & 0xFF];
                    rsTempData = DcfQrcode.calculateByteArrayBits(leftChr, cal, "xor");
                } else if (rsEccCodewords < rsTempData.length) {
                    rsTempNew = new byte[rsTempData.length - 1];
                    System.arraycopy(rsTempData, 1, rsTempNew, 0, rsTempData.length - 1);
                    rsTempData = (byte[])rsTempNew.clone();
                } else {
                    rsTempNew = new byte[rsEccCodewords];
                    System.arraycopy(rsTempData, 1, rsTempNew, 0, rsTempData.length - 1);
                    rsTempNew[rsEccCodewords - 1] = 0;
                    rsTempData = (byte[])rsTempNew.clone();
                }
                --j;
            }
            System.arraycopy(rsTempData, 0, res, codewords.length + rsBlockNumber * rsEccCodewords, rsEccCodewords);
            ++rsBlockNumber;
        }
        return res;
    }

    protected static byte[] calculateByteArrayBits(byte[] xa, byte[] xb, String ind) {
        byte[] xs;
        byte[] xl;
        if (xa.length > xb.length) {
            xl = (byte[])xa.clone();
            xs = (byte[])xb.clone();
        } else {
            xl = (byte[])xb.clone();
            xs = (byte[])xa.clone();
        }
        int ll = xl.length;
        int ls = xs.length;
        byte[] res = new byte[ll];
        int i = 0;
        while (i < ll) {
            res[i] = i < ls ? (ind == "xor" ? (byte)(xl[i] ^ xs[i]) : (byte)(xl[i] | xs[i])) : xl[i];
            ++i;
        }
        return res;
    }

    protected static byte selectMask(byte[][] matrixContent, int maxCodewordsBitWithRemain) {
        int l = matrixContent.length;
        int[] d1 = new int[8];
        int[] d2 = new int[8];
        int[] d3 = new int[8];
        int[] d4 = new int[8];
        int d2And = 0;
        int d2Or = 0;
        int[] d4Counter = new int[8];
        int y = 0;
        while (y < l) {
            int[] xData = new int[8];
            int[] yData = new int[8];
            boolean[] xD1Flag = new boolean[8];
            boolean[] yD1Flag = new boolean[8];
            int x = 0;
            while (x < l) {
                if (x > 0 && y > 0) {
                    d2And = matrixContent[x][y] & matrixContent[x - 1][y] & matrixContent[x][y - 1] & matrixContent[x - 1][y - 1] & 0xFF;
                    d2Or = matrixContent[x][y] & 0xFF | matrixContent[x - 1][y] & 0xFF | matrixContent[x][y - 1] & 0xFF | matrixContent[x - 1][y - 1] & 0xFF;
                }
                int maskNumber = 0;
                while (maskNumber < 8) {
                    xData[maskNumber] = (xData[maskNumber] & 0x3F) << 1 | (matrixContent[x][y] & 0xFF) >>> maskNumber & 1;
                    yData[maskNumber] = (yData[maskNumber] & 0x3F) << 1 | (matrixContent[y][x] & 0xFF) >>> maskNumber & 1;
                    if ((matrixContent[x][y] & 1 << maskNumber) != 0) {
                        int n = maskNumber;
                        d4Counter[n] = d4Counter[n] + 1;
                    }
                    if (xData[maskNumber] == 93) {
                        int n = maskNumber;
                        d3[n] = d3[n] + 40;
                    }
                    if (yData[maskNumber] == 93) {
                        int n = maskNumber;
                        d3[n] = d3[n] + 40;
                    }
                    if (x > 0 && y > 0) {
                        if ((d2And & 1) != 0 || (d2Or & 1) == 0) {
                            int n = maskNumber;
                            d2[n] = d2[n] + 3;
                        }
                        d2And >>= 1;
                        d2Or >>= 1;
                    }
                    if ((xData[maskNumber] & 0x1F) == 0 || (xData[maskNumber] & 0x1F) == 31) {
                        if (x > 3) {
                            if (xD1Flag[maskNumber]) {
                                int n = maskNumber;
                                d1[n] = d1[n] + 1;
                            } else {
                                int n = maskNumber;
                                d1[n] = d1[n] + 3;
                                xD1Flag[maskNumber] = true;
                            }
                        }
                    } else {
                        xD1Flag[maskNumber] = false;
                    }
                    if ((yData[maskNumber] & 0x1F) == 0 || (yData[maskNumber] & 0x1F) == 31) {
                        if (x > 3) {
                            if (yD1Flag[maskNumber]) {
                                int n = maskNumber;
                                d1[n] = d1[n] + 1;
                            } else {
                                int n = maskNumber;
                                d1[n] = d1[n] + 3;
                                yD1Flag[maskNumber] = true;
                            }
                        }
                    } else {
                        yD1Flag[maskNumber] = false;
                    }
                    ++maskNumber;
                }
                ++x;
            }
            ++y;
        }
        int minValue = 0;
        byte res = 0;
        int[] nArray = new int[21];
        nArray[0] = 90;
        nArray[1] = 80;
        nArray[2] = 70;
        nArray[3] = 60;
        nArray[4] = 50;
        nArray[5] = 40;
        nArray[6] = 30;
        nArray[7] = 20;
        nArray[8] = 10;
        nArray[11] = 10;
        nArray[12] = 20;
        nArray[13] = 30;
        nArray[14] = 40;
        nArray[15] = 50;
        nArray[16] = 60;
        nArray[17] = 70;
        nArray[18] = 80;
        nArray[19] = 90;
        nArray[20] = 90;
        int[] d4Value = nArray;
        int maskNumber = 0;
        while (maskNumber < 8) {
            d4[maskNumber] = d4Value[20 * d4Counter[maskNumber] / maxCodewordsBitWithRemain];
            int demerit = d1[maskNumber] + d2[maskNumber] + d3[maskNumber] + d4[maskNumber];
            if (demerit < minValue || maskNumber == 0) {
                res = (byte)maskNumber;
                minValue = demerit;
            }
            ++maskNumber;
        }
        return res;
    }
}

