/*
 * Decompiled with CFR 0.152.
 */
package ext.scf4.fx;

import ext.base.event.BcEventHandler;
import ext.base.log.BcLogUtil;
import ext.lib.fx.FxPlatform;
import ext.lib.fx.control.FxTextField;
import ext.lib.fx.layout.FxBorderPane;
import ext.lib.fx.layout.FxTitledPane;
import ext.lib.fx.util.FxUtil;
import ext.lib.task.TskTaskEvent;
import ext.scf4.fx.HfxElapsedTimePanel;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextFormatter;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.Pane;

class HfxTaskConsolePane
extends FxBorderPane
implements BcEventHandler<TskTaskEvent> {
    FxTitledPane titledPane = new FxTitledPane();
    FxBorderPane borderPane = new FxBorderPane();
    FxTextField logField;
    FlowPane bottomPane = new FlowPane();
    HfxElapsedTimePanel elapsedTimePanel = new HfxElapsedTimePanel();
    Pane rightPane = new Pane();
    int width = 0;
    int height = 80;
    public boolean successfullyMessageEnable = true;
    private final int MAX_LINES = 6;

    public HfxTaskConsolePane() throws Exception {
        this.initComponent();
    }

    protected void initComponent() throws Exception {
        this.logField = new FxTextField();
        this.borderPane.setTop((Node)this.logField);
        this.bottomPane.getChildren().add((Object)this.elapsedTimePanel);
        this.borderPane.setBottom((Node)this.bottomPane);
        this.titledPane.setContentNode((Node)this.borderPane);
        this.setCenter((Node)this.titledPane);
        FxUtil.setEditable((Node)this, false);
        this.setPadding(new Insets(8.0, 8.0, 8.0, 8.0));
        this.setPrefSize(this.width, this.height);
    }

    public void start(long stratMillis, String title) throws Exception {
        this.titledPane.setTitle(title, 10.0);
        this.elapsedTimePanel.start(stratMillis);
    }

    public void stop() {
    }

    private TextArea createConsole() {
        TextArea appConsole = new TextArea();
        appConsole.setWrapText(false);
        appConsole.setEditable(false);
        Pattern newline = Pattern.compile("\n");
        appConsole.setTextFormatter(new TextFormatter(change -> {
            String newText = change.getControlNewText();
            Matcher matcher = newline.matcher(newText);
            int lines = 1;
            while (matcher.find()) {
                ++lines;
            }
            if (lines <= 6) {
                return change;
            }
            int linesToDrop = lines - 6;
            int index = 0;
            int i = 0;
            while (i < linesToDrop) {
                index = newText.indexOf(10, index);
                ++i;
            }
            change.setRange(0, change.getControlText().length());
            change.setText(newText.substring(index + 1));
            return change;
        }));
        return appConsole;
    }

    @Override
    public void handle(final TskTaskEvent event) throws Exception {
        if (event.getEventType() == TskTaskEvent.EventType.Log) {
            FxPlatform.runLater(new Runnable(){

                @Override
                public void run() {
                    HfxTaskConsolePane.this.logField.setText(BcLogUtil.convertMessage(event.getUserObject()));
                }
            });
        }
    }
}

